/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.daq;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.daq.ims.DAQDriverStats;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.DAQFirmwareStats;
import org.lsst.ccs.daq.ims.DAQRdsStats;
import org.lsst.ccs.daq.ims.DAQRmsStats;
import org.lsst.ccs.daq.ims.Stats;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class DaqStatsMonitor
implements HasLifecycle {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dataProviderDictionaryService;
    private String partition;
    private String fullName;
    private boolean online;
    private boolean inited;
    private Stats stats;
    private Store store;
    private static final Logger LOG = Logger.getLogger(DaqStatsMonitor.class.getName());
    private final LocationSet locSetAll;
    private LocationSet locSet;
    private final Duration publishInterval;
    @ConfigurationParameter(isBuild=true, description="enable periodic publication")
    boolean enablePeriodicPublication;
    @ConfigurationParameter(isFinal=true, description="Driver Stats for sums over location")
    protected List<String> sumDriverStats;
    @ConfigurationParameter(isFinal=true, description="Firmware Stats for sums over location")
    protected List<String> sumFirmwareStats;
    @ConfigurationParameter(isFinal=true, description="Rds Stats for sums over location")
    protected List<String> sumRdsStats;
    @ConfigurationParameter(isFinal=true, description="Rms Stats for sums over location")
    protected List<String> sumRmsStats;

    public DaqStatsMonitor() {
        this.locSet = this.locSetAll = LocationSet.all();
        this.publishInterval = Duration.ofSeconds(15L);
        this.sumDriverStats = new ArrayList<String>();
        this.sumFirmwareStats = new ArrayList<String>();
        this.sumRdsStats = new ArrayList<String>();
        this.sumRmsStats = new ArrayList<String>();
    }

    public boolean isOnline() {
        return this.online;
    }

    public void build() {
        Runnable publishStats = new Runnable(){

            @Override
            public void run() {
                try {
                    for (Location loc : DaqStatsMonitor.this.locSet) {
                        DaqStatsMonitor.this.agent.publishSubsystemDataOnStatusBus(DaqStatsMonitor.this.getDataForLocation(loc));
                    }
                    DaqStatsMonitor.this.agent.publishSubsystemDataOnStatusBus(DaqStatsMonitor.this.getSummedData());
                }
                catch (DAQException ex) {
                    LOG.warning("DAQ Exception while acquiring data for publication: " + (Object)((Object)ex));
                }
            }
        };
        if (this.enablePeriodicPublication) {
            AgentPeriodicTask periodicTask = new AgentPeriodicTask("publishStats", publishStats).withPeriod(this.publishInterval);
            this.periodicTaskService.scheduleAgentPeriodicTask(periodicTask);
            LOG.info(this.name + "  publication of trending data is enabled");
        } else {
            LOG.info(this.name + "  publication of trending data is disabled");
        }
    }

    void setPartition(String pname) {
        this.partition = pname;
    }

    public void init() {
        this.fullName = this.name + ": (partition" + this.partition + ")";
        try {
            if (this.stats != null) {
                this.close();
            }
            this.stats = new Stats(this.partition);
            this.online = true;
            LOG.info("\n " + this.name + " Connected to DAQ partition " + this.partition);
            this.store = new Store(this.partition);
            this.locSet = this.store.getConfiguredSources();
            this.store.close();
            LOG.info(this.name + String.format(":  using %d DAQ configured locations", this.locSet.size()));
            if (!this.locSet.iterator().hasNext()) {
                throw new RuntimeException(this.name + ":  there are no configured locations");
            }
            Location loc = (Location)this.locSet.iterator().next();
            Map map = this.stats.getDAQDriverStats(loc, Stats.Clear.NO).getMap();
            for (String par : this.sumDriverStats) {
                if (map.containsKey(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumDriverStats", (String)(par + " is invalid entry"));
            }
            map = this.stats.getDAQFirmwareStats(loc, Stats.Clear.NO).getMap();
            for (String par : this.sumFirmwareStats) {
                if (map.containsKey(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumFirmwareStats", (String)(par + " is invalid entry"));
            }
            map = this.stats.getDAQRdsStats(loc, Stats.Clear.NO).getMap();
            for (String par : this.sumRdsStats) {
                if (map.containsKey(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumRdsStats", (String)(par + " is invalid entry"));
            }
            map = this.stats.getDAQRmsStats(loc, Stats.Clear.NO).getMap();
            for (String par : this.sumRmsStats) {
                if (map.containsKey(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumRmsStats", (String)(par + " is invalid entry"));
            }
        }
        catch (DAQException ex) {
            if (!this.inited) {
                throw new RuntimeException("DAQException while connecting to " + this.fullName + ":  " + ex.getMessage());
            }
            try {
                this.close();
            }
            catch (DAQException map) {
                // empty catch block
            }
        }
        this.inited = true;
        if (this.enablePeriodicPublication) {
            try {
                for (Location loc : this.locSet) {
                    this.dataProviderDictionaryService.registerData(this.getDataForLocation(loc));
                }
                this.dataProviderDictionaryService.registerData(this.getSummedData());
                LOG.info(this.name + " Registration of Stats data complete");
            }
            catch (DAQException ex) {
                throw new RuntimeException(this.name + " data registration failed: " + (Object)((Object)ex));
            }
        }
    }

    void close() throws DAQException {
        if (this.stats != null) {
            this.stats.close();
            this.stats = null;
            this.online = false;
        }
    }

    private KeyValueData getDataForLocation(Location location) throws DAQException {
        KeyValueDataList list = new KeyValueDataList();
        String lname = location.toString();
        list.addData(lname + "/Rms", (Serializable)this.stats.getDAQRmsStats(location, Stats.Clear.NO));
        list.addData(lname + "/Rds", (Serializable)this.stats.getDAQRdsStats(location, Stats.Clear.NO));
        list.addData(lname + "/Driver", (Serializable)this.stats.getDAQDriverStats(location, Stats.Clear.NO));
        list.addData(lname + "/Firmware", (Serializable)this.stats.getDAQFirmwareStats(location, Stats.Clear.NO));
        return list;
    }

    private KeyValueData getSummedData() throws DAQException {
        long sum;
        KeyValueDataList list = new KeyValueDataList();
        for (String key : this.sumDriverStats) {
            sum = 0L;
            for (Location loc : this.locSet) {
                sum += this.stats.getDAQDriverStats(loc, Stats.Clear.NO).getStatistic(key).longValue();
            }
            list.addData("Sum/Driver/" + key, (Serializable)Long.valueOf(sum));
        }
        for (String key : this.sumFirmwareStats) {
            sum = 0L;
            for (Location loc : this.locSet) {
                sum += this.stats.getDAQFirmwareStats(loc, Stats.Clear.NO).getStatistic(key).longValue();
            }
            list.addData("Sum/Firmware/" + key, (Serializable)Long.valueOf(sum));
        }
        for (String key : this.sumRdsStats) {
            sum = 0L;
            for (Location loc : this.locSet) {
                sum += this.stats.getDAQRdsStats(loc, Stats.Clear.NO).getStatistic(key).longValue();
            }
            list.addData("Sum/Rds/" + key, (Serializable)Long.valueOf(sum));
        }
        for (String key : this.sumRmsStats) {
            sum = 0L;
            for (Location loc : this.locSet) {
                sum += this.stats.getDAQRmsStats(loc, Stats.Clear.NO).getStatistic(key).longValue();
            }
            list.addData("Sum/Rms/" + key, (Serializable)Long.valueOf(sum));
        }
        return list;
    }

    private String makeStatsTable(String sname, Map<String, Long> statMap, String location) {
        Set<String> keys = statMap.keySet();
        String table = "DAQ " + sname + " Stats for " + location + "\n" + this.timestamp() + "\n";
        for (String key : keys) {
            table = table + String.format("\n  %-22s %d", key, statMap.get(key));
        }
        table = table + "\n";
        return table;
    }

    @Command(type=Command.CommandType.QUERY, name="readAllStats", description="Read all sets of DAQ stats")
    public String readAllStats(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        return "\n" + this.readAllRms(location) + "\n" + this.readAllRds(location) + "\n" + this.readAllDriver(location) + "\n" + this.readAllFirmware(location) + "\n";
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllStats", description="Read and clear all sets of DAQ stats")
    public String clearAllStats(@Argument(name="location", description="clearout board in format R<nn>Reb<m>") String location) throws DAQException {
        return "\n" + this.clearAllRms(location) + "\n" + this.clearAllRds(location) + "\n" + this.clearAllDriver(location) + "\n" + this.clearAllFirmware(location) + "\n";
    }

    @Command(type=Command.CommandType.QUERY, name="readAllRms", description="Read all DAQ Rms stats")
    public String readAllRms(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQRmsStats rmsStats = this.stats.getDAQRmsStats(Location.of((String)location), Stats.Clear.NO);
        Map statMap = rmsStats.getMap();
        return this.makeStatsTable("Rms", statMap, location);
    }

    @Command(type=Command.CommandType.QUERY, name="readAllRds", description="Read all DAQ Rds stats")
    public String readAllRds(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQRdsStats rdsStats = this.stats.getDAQRdsStats(Location.of((String)location), Stats.Clear.NO);
        Map statMap = rdsStats.getMap();
        return this.makeStatsTable("Rds", statMap, location);
    }

    @Command(type=Command.CommandType.QUERY, name="readAllDriver", description="Read all DAQ Driver stats")
    public String readAllDriver(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQDriverStats driverStats = this.stats.getDAQDriverStats(Location.of((String)location), Stats.Clear.NO);
        Map statMap = driverStats.getMap();
        return this.makeStatsTable("Driver", statMap, location);
    }

    @Command(type=Command.CommandType.QUERY, name="readAllFirmware", description="Read all DAQ Firmware stats")
    public String readAllFirmware(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQFirmwareStats firmwareStats = this.stats.getDAQFirmwareStats(Location.of((String)location), Stats.Clear.NO);
        Map statMap = firmwareStats.getMap();
        return this.makeStatsTable("Firmware", statMap, location);
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllRms", description="Read and clear DAQ Rms stats")
    public String clearAllRms(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQRmsStats rmsStats = this.stats.getDAQRmsStats(Location.of((String)location), Stats.Clear.YES);
        Map statMap = rmsStats.getMap();
        return this.makeStatsTable("Rms", statMap, location) + "Cleared";
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllRds", description="Read and clear DAQ Rds stats")
    public String clearAllRds(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQRdsStats rdsStats = this.stats.getDAQRdsStats(Location.of((String)location), Stats.Clear.YES);
        Map statMap = rdsStats.getMap();
        return this.makeStatsTable("Rds", statMap, location) + "Cleared";
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllDriver", description="Read and clear DAQ Driver stats")
    public String clearAllDriver(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQDriverStats driverStats = this.stats.getDAQDriverStats(Location.of((String)location), Stats.Clear.YES);
        Map statMap = driverStats.getMap();
        return this.makeStatsTable("Driver", statMap, location) + "Cleared";
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllFirmware", description="Read and clear DAQ Firmware stats")
    public String clearAllFirmware(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQFirmwareStats firmwareStats = this.stats.getDAQFirmwareStats(Location.of((String)location), Stats.Clear.YES);
        Map statMap = firmwareStats.getMap();
        return this.makeStatsTable("Firmware", statMap, location) + "Cleared";
    }

    @Command(type=Command.CommandType.QUERY, name="readRmsStat", description="read specified DAQ Rms statistic for specified locaation")
    public String readRmsStat(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQRmsStats rmsStats = this.stats.getDAQRmsStats(Location.of((String)location), Stats.Clear.NO);
        return rmsStats.getStatistic(quantity).toString();
    }

    @Command(type=Command.CommandType.QUERY, name="readRdsStat", description="read specified DAQ Rds statistic for specified locaation")
    public String readRdsStat(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQRdsStats rdsStats = this.stats.getDAQRdsStats(Location.of((String)location), Stats.Clear.NO);
        return rdsStats.getStatistic(quantity).toString();
    }

    @Command(type=Command.CommandType.QUERY, name="readDriverStat", description="read specified DAQ Driver statistic for specified locaation")
    public String readDriverStat(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQDriverStats driverStats = this.stats.getDAQDriverStats(Location.of((String)location), Stats.Clear.NO);
        return driverStats.getStatistic(quantity).toString();
    }

    @Command(type=Command.CommandType.QUERY, name="readFirmwareStat", description="read specified DAQ Firmware statistic for specified locaation")
    public String readFirmwareStat(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQFirmwareStats firmwareStats = this.stats.getDAQFirmwareStats(Location.of((String)location), Stats.Clear.NO);
        return firmwareStats.getStatistic(quantity).toString();
    }

    @Command(name="timestamp", description="Prints current time")
    public String timestamp() {
        Date now = new Date();
        return now.toString();
    }
}

