import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.vacuum.VacuumMain
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice
import org.lsst.ccs.subsystem.vacuum.IonPumpControl
import org.lsst.ccs.subsystem.vacuum.Mks9xxDevice
import org.lsst.ccs.subsystem.vacuum.CryoTurboDevice
import org.lsst.ccs.subsystem.vacuum.data.VacSysState
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Page
import org.lsst.ccs.monitor.Alarm

taskConfig = ["monitor-update/taskPeriodMillis":1000, "monitor-publish/taskPeriodMillis":10000]

CCSBuilder builder = ["vacuum"]

builder.main (VacuumMain, nodeTags:taskConfig, cryoPressChan:"CryoVac", turboPressChan:"TurboVac",
              turboSpeedChan:"TurboSpeed", forelinePressChan:"ForelineVac",
              switches:[VacSysState.SW_CRYO_TURBO, VacSysState.SW_CRYO_ION_PUMP1,
                        VacSysState.SW_CRYO_ION_PUMP2, VacSysState.SW_CRYO_ION_PUMP3,
                        VacSysState.SW_CRYO_ION_PUMP4, VacSysState.SW_CRYO_ION_PUMP5,
                        VacSysState.SW_CRYO_ION_PUMP6, VacSysState.SW_CRYO_VALVE]) {

    AlarmGeneric (Alarm, description:"Vacuum System Alarm - Generic", eventParm:23)

    VacPluto (VacPlutoDevice, node:"192.168.1.131",
              latchesUsed:[VacSysState.LATCH_CR_GATE_AO, VacSysState.LATCH_CR_GATE_NFC,
                           VacSysState.LATCH_CR_PUMP, VacSysState.LATCH_CR_VACUUM,
			   VacSysState.LATCH_HX_VACUUM],
              condsUsed:[VacSysState.COND_CR_FORELINE_VAC, VacSysState.COND_CR_TRB_PRESS_10,
                         VacSysState.COND_CR_TRB_PUMP_OFF, VacSysState.COND_CR_VACUUM_001,
                         VacSysState.COND_CR_VACUUM_01, VacSysState.COND_HX_VACUUM_001,
			 VacSysState.COND_HX_VACUUM_01, VacSysState.COND_HX_FORELINE_VAC])

    int cip1 = IonPumpDevice.CHAN_CIP1
    int cip2 = IonPumpDevice.CHAN_CIP2
    int cip3 = IonPumpDevice.CHAN_CIP3
    int cip4 = IonPumpDevice.CHAN_CIP4
    int cip5 = IonPumpDevice.CHAN_CIP5
    int cip6 = IonPumpDevice.CHAN_CIP6
    int hip1 = IonPumpDevice.CHAN_HIP1
    int hip2 = IonPumpDevice.CHAN_HIP2
    int oip  = IonPumpDevice.CHAN_OIP

    IonPumps (IonPumpDevice, ipAddr:"192.168.1.71") {

        CIP1C (IonPumpControl, hwChan:cip1, voltage:6000, current:0.005, power:9.9)

        CIP2C (IonPumpControl, hwChan:cip2, voltage:6000, current:0.005, power:9.9)

        CIP3C (IonPumpControl, hwChan:cip3, voltage:6000, current:0.005, power:9.9)

        CIP4C (IonPumpControl, hwChan:cip4, voltage:6000, current:0.005, power:9.9)

        CIP5C (IonPumpControl, hwChan:cip5, voltage:6000, current:0.005, power:9.9)

        CIP6C (IonPumpControl, hwChan:cip6, voltage:6000, current:0.005, power:9.9)

        CIP1_I (Channel, description:"Cryo ion pump 1 current", units:"mA",
                hwChan:cip1, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP2_I (Channel, description:"Cryo ion pump 2 current", units:"mA",
                hwChan:cip2, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP3_I (Channel, description:"Cryo ion pump 3 current", units:"mA",
                hwChan:cip3, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP4_I (Channel, description:"Cryo ion pump 4 current", units:"mA",
                hwChan:cip4, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP5_I (Channel, description:"Cryo ion pump 5 current", units:"mA",
                hwChan:cip5, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP6_I (Channel, description:"Cryo ion pump 6 current", units:"mA",
                hwChan:cip6, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP1_V (Channel, description:"Cryo ion pump 1 voltage", units:"Volts", format:".1f",
                hwChan:cip1, type:"VOLTAGE")

        CIP2_V (Channel, description:"Cryo ion pump 2 voltage", units:"Volts", format:".1f",
                hwChan:cip2, type:"VOLTAGE")

        CIP3_V (Channel, description:"Cryo ion pump 3 voltage", units:"Volts", format:".1f",
                hwChan:cip3, type:"VOLTAGE")

        CIP4_V (Channel, description:"Cryo ion pump 4 voltage", units:"Volts", format:".1f",
                hwChan:cip4, type:"VOLTAGE")

        CIP5_V (Channel, description:"Cryo ion pump 5 voltage", units:"Volts", format:".1f",
                hwChan:cip5, type:"VOLTAGE")

        CIP6_V (Channel, description:"Cryo ion pump 6 voltage", units:"Volts", format:".1f",
                hwChan:cip6, type:"VOLTAGE")

    }

    TurboPump (CryoTurboDevice, devcId:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A104D6TK-if00-port0",
    	       model304:true, lowSpeedMode:false, waterCooling:false,
               ventValveByCmnd:false, interlockType:true, softStartMode:true, activeStopMode:true) {

        TurboSpeed (Channel, description:"Turbo pump speed", units:"rpm", format:".0f",
                    type:"Numeric", subtype:"DRIVEFREQ", scale:60, limitHi:100000)

        TurboCurrent (Channel, description:"TurboPump current", units:"mA dc",
                      type:"Numeric", subtype:"CURRENT",
                      checkLo:"none", checkHi:"none", format:"%.0f")

        TurboVoltage (Channel, description:"TurboPump voltage", units:"V dc",
                      type:"Numeric", subtype:"VOLTAGE",
                      checkLo:"none", checkHi:"none", format:"%.0f")

        TurboPower   (Channel, description:"TurboPump power", units:"W",
                      type:"Numeric", subtype:"POWER",
                      checkLo:"none", checkHi:"alarm", alarmHi:"AlarmGeneric", format:"%.0f",
                      limitHi:150.0, dbandHi:100.0)

        TurboPumpTemp (Channel, description:"TurboPump pump temperature",
                       units:"deg C",
                       type:"Numeric", subtype:"PUMP_TEMP", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0,
                       limitHi:40.0, checkHi:"alarm", alarmHi:"AlarmGeneric", dbandHi:10.0)
    }

    CryoVacGauge (Mks9xxDevice, devcId:"/dev/ttyS0", busAddr:1) {

        CryoVac (Channel, description:"Cryostat vacuum", units:"Torr", format:".3g",
                 limitHi:1000)
    }

    TurboVacGauge (Mks9xxDevice, devcId:"/dev/ttyS0", busAddr:2) {

        TurboVac (Channel, description:"Turbo pump vacuum", units:"Torr", format:".3g",
                  limitHi:1000)
    }

    ForelineVacGauge (Mks9xxDevice, devcId:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A104D6TJ-if00-port0") {

        ForelineVac (Channel, description:"Foreline pump vacuum", units:"Torr", format:".3g",
                     limitHi:1000)
    }

    Hex1VacGauge (Mks9xxDevice, devcId:"/dev/ttyS1", busAddr:3) {

        Hex1Vac (Channel, description:"Heat exchanger 1 vacuum", units:"Torr", format:".3g",
                 limitHi:1000)
    }

    Hex2VacGauge (Mks9xxDevice, devcId:"/dev/ttyS1", busAddr:4) {

        Hex2Vac (Channel, description:"Heat exchanger 2 vacuum", units:"Torr", format:".3g",
                 limitHi:1000)
    }


/*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1, pageId:0, 
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/

}
