/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.DataChannel;
import org.lsst.ccs.drivers.lighthouse.DataRecord;
import org.lsst.ccs.drivers.lighthouse.LighthouseClient;
import org.lsst.ccs.drivers.lighthouse.RecordFlag;
import org.lsst.ccs.subsystem.airwatch.main.Instrument;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentChannel;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentStatus;
import org.lsst.ccs.subsystem.airwatch.main.LocationConfig;
import org.lsst.ccs.subsystem.airwatch.main.TrendableModbusRecord;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;
import org.lsst.ccs.utilities.logging.Logger;

public class LighthouseModbus
implements Instrument {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.airwatch");
    private static final Duration DEVICE_TIMEOUT = Duration.ofSeconds(10L);
    private static final boolean DEVICE_DEBUG = false;
    private static final Duration DEVICE_CLOCK_MAX_ERROR = Duration.ofSeconds(10L);
    private final int index;
    private final boolean enabled;
    private final String location;
    private final Instant lastDataTime;
    private final String connectionInfo;
    private final Optional<HardwareException> lastException;
    private final List<TrendableRecord> trendables;

    public LighthouseModbus(InstrumentConfig config) {
        this.index = config.index;
        this.enabled = false;
        this.location = config.loc;
        this.lastDataTime = config.lastDataTime;
        this.connectionInfo = config.conn;
        this.lastException = Optional.empty();
        this.trendables = Collections.emptyList();
    }

    private LighthouseModbus(int index, boolean enabled, String location, Instant lastDataTime, String connectionInfo, Optional<HardwareException> lastException, List<TrendableRecord> trendables) {
        this.index = index;
        this.enabled = enabled;
        this.location = location;
        this.lastDataTime = lastDataTime;
        this.connectionInfo = connectionInfo;
        this.lastException = lastException;
        this.trendables = trendables;
    }

    @Override
    public Optional<HardwareException> getLastException() {
        return this.lastException;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public InstrumentStatus getStatus() {
        return new InstrumentStatus(this.index, this.enabled, this.location, this.lastDataTime);
    }

    @Override
    public Stream<TrendableRecord> getTrendables() {
        return this.trendables.stream();
    }

    @Override
    public Instrument disable() {
        return new LighthouseModbus(this.index, false, this.location, this.lastDataTime, this.connectionInfo, this.lastException, this.trendables);
    }

    @Override
    public Instrument enable(LocationConfig loc) {
        boolean newEnabled = this.enabled;
        String newLocation = this.location;
        HardwareException hwexc = null;
        try (ClientHolder holder = new ClientHolder(LighthouseModbus.parseConnectionInfo(this.connectionInfo));){
            LighthouseClient client = holder.getClient();
            client.stopRecording();
            client.setClock(DEVICE_CLOCK_MAX_ERROR);
            client.setLocationIndex(loc.index + 1);
            String locCheck = client.getLocationName();
            if (!locCheck.equalsIgnoreCase(loc.name)) {
                String msg = String.format("Location table error for instrument at '%s'.%nLocation #%d is '%s', should be '%s'.", this.location, loc.index, locCheck, loc.name);
                hwexc = new HardwareException(true, msg);
            }
            for (DataChannel dchan : DataChannel.values()) {
                if (dchan.isAnalog()) continue;
                InstrumentChannel ichan = InstrumentChannel.parse(dchan.getName()).get();
                if (loc.thresholds.containsKey((Object)ichan)) {
                    long thresh = loc.thresholds.get((Object)ichan);
                    client.setAlarmThreshold(dchan, thresh);
                    client.setAlarmEnable(dchan, true);
                    continue;
                }
                client.setAlarmEnable(dchan, false);
            }
            newEnabled = true;
            newLocation = loc.name;
        }
        catch (DriverException exc) {
            hwexc = new HardwareException(true, (Throwable)exc);
        }
        catch (Exception exc) {
            throw new Error(exc);
        }
        return new LighthouseModbus(this.index, newEnabled, newLocation, this.lastDataTime, this.connectionInfo, Optional.ofNullable(hwexc), Collections.emptyList());
    }

    @Override
    public Instrument read() {
        HardwareException hwexc = null;
        List records = Collections.emptyList();
        List<Object> newData = Collections.emptyList();
        Instant newLast = this.lastDataTime;
        LighthouseModbus ins = null;
        try (ClientHolder holder = new ClientHolder(LighthouseModbus.parseConnectionInfo(this.connectionInfo));){
            LighthouseClient client = holder.getClient();
            client.stopRecording();
            client.setClock(DEVICE_CLOCK_MAX_ERROR);
            records = client.getRecentRecords(this.lastDataTime);
        }
        catch (DriverException exc) {
            hwexc = new HardwareException(true, (Throwable)exc);
        }
        catch (Exception exc) {
            throw new Error(exc);
        }
        newData = LighthouseModbus.extractTrendables(records.stream());
        if (newData.size() > 0) {
            newLast = ((TrendableRecord)newData.get(0)).getMasterTimestamp();
        }
        ins = new LighthouseModbus(this.index, this.enabled, this.location, newLast, this.connectionInfo, Optional.ofNullable(hwexc), Collections.unmodifiableList(newData));
        return ins;
    }

    private static LighthouseClient parseConnectionInfo(String info) throws DriverException {
        String[] words = info.trim().split("\\s+");
        String method = words[0].toLowerCase();
        String parameters = words[1];
        LighthouseClient client = null;
        if (method.equals("serial")) {
            client = LighthouseClient.serialOpen((String)parameters, (Duration)DEVICE_TIMEOUT, (boolean)false);
        } else if (method.equals("ftdi")) {
            client = LighthouseClient.ftdiOpen((String)parameters, (Duration)DEVICE_TIMEOUT, (boolean)false);
        } else if (method.equals("net")) {
            words = parameters.split(":");
            String host = words[0];
            int portNo = Integer.parseUnsignedInt(words[1]);
            client = LighthouseClient.netOpen((String)host, (int)portNo, (Duration)DEVICE_TIMEOUT, (boolean)false);
        } else {
            throw new IllegalArgumentException("Illegal Lighthouse connection type: " + method);
        }
        return client;
    }

    private static List<TrendableRecord> extractTrendables(Stream<DataRecord> records) {
        return records.map(rec -> {
            String key = rec.getLocation().toLowerCase();
            Instant stamp = rec.getStartTime();
            Map<String, Serializable> items = rec.getChannels().collect(Collectors.toMap(datum -> datum.getChannel().getName(), datum -> Double.valueOf(datum.getValue())));
            EnumSet flags = EnumSet.copyOf(rec.getFlags());
            flags.retainAll(EnumSet.of(RecordFlag.HIGH, RecordFlag.LOW));
            items.put(TrendableModbusRecord.LIMIT_VIOLATION_KEY, flags.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(1));
            flags = EnumSet.copyOf(rec.getFlags());
            flags.retainAll(EnumSet.of(RecordFlag.FLOW_RATE, RecordFlag.LASER, RecordFlag.MALFUNCTION, RecordFlag.OVERFLOW, RecordFlag.SAMPLER));
            items.put(TrendableModbusRecord.MALFUNCTION_KEY, flags.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(1));
            return new TrendableModbusRecord(key, stamp, items);
        }).collect(Collectors.toList());
    }

    private static class ClientHolder
    implements AutoCloseable {
        private final LighthouseClient client;

        public ClientHolder(LighthouseClient client) {
            this.client = client;
        }

        public LighthouseClient getClient() {
            return this.client;
        }

        @Override
        public void close() throws DriverException {
            this.client.startRecording();
            this.client.close();
        }
    }
}

