/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm.ir2.actions;

import java.util.Map;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher;
import org.lsst.ccs.subsystem.mcm.AlertNotification;
import org.lsst.ccs.subsystem.mcm.MCM_IR2;
import org.lsst.ccs.subsystem.mcm.MinionIR2;
import org.lsst.ccs.subsystem.power.states.RebPowerState;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;

public class RebTemperatureTooHighAction
extends AlertDispatcher.AlertAction {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    AlertDispatcher dispatcher;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    MCM_IR2 mcm;

    @Override
    public void accept(AlertNotification t) {
        String alertId;
        if (t.getSubsystemType() == MinionIR2.RAFT && ((alertId = t.getAlert().getAlertId()).equals(RaftAlert.ASPICS_TEMPERATURE_TOO_HIGH.getAlertId()) || alertId.equals(RaftAlert.REB_BOARD_TEMPERATURE_TOO_HIGH.getAlertId()))) {
            this.getLogger().info((Object)("REB temperature too high action required at level: " + t.getSeverity() + " (" + t.getCause() + ")"));
            String destination = this.dispatcher.getMcmUtilities().getDestination(this.dispatcher.getGroup(), MinionIR2.POWER);
            StateBundle powerStateBundle = this.dispatcher.getMcmUtilities().getState(this.dispatcher.getGroup(), MinionIR2.POWER);
            if (powerStateBundle != null) {
                Map powerStates = powerStateBundle.getComponentsWithState(RebPowerState.class);
                this.getLogger().info((Object)("Overall Power state: " + powerStateBundle.getState(RebPowerState.class)));
                this.getLogger().info((Object)("Component Power state " + powerStates));
                if (t.getSeverity() == AlertState.ALARM) {
                    this.getLogger().warn((Object)("********** Powering off the rebs for group " + this.dispatcher.getGroupName()));
                    for (int i = 0; i < 3; ++i) {
                        String command = "sequencePower " + i + " false";
                        this.getLogger().warn((Object)("Sending command \"" + command + "\" to " + destination));
                        try {
                            this.dispatcher.getMcmUtilities().send(destination, "sequencePower", i, false);
                            continue;
                        }
                        catch (Exception e) {
                            this.getLogger().severe((Object)("FAILED TO TURN OFF REB " + i), (Throwable)e);
                        }
                    }
                }
            } else {
                this.getLogger().warning((Object)("No state information is available for " + destination + ". The subsystem might not be available on the buses."));
                this.getLogger().warning((Object)"The Reb Temperature Too High Action is skipped!");
            }
        }
    }

    @Override
    public String getDescription() {
        return "Powers off the Rebs upon ALARM by sending sequencePower i false to " + this.dispatcher.getMcmUtilities().getDestination(this.dispatcher.getGroup(), MinionIR2.POWER);
    }
}

