/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.mcm.AlertException;
import org.lsst.ccs.subsystem.mcm.GenericMCM;
import org.lsst.ccs.subsystem.mcm.Minion;
import org.lsst.ccs.subsystem.mcm.MinionGroup;
import org.lsst.ccs.subsystem.mcm.data.InvalidStateException;
import org.lsst.ccs.subsystem.mcm.data.MCMEvent;
import org.lsst.ccs.subsystem.mcm.data.MCMState;
import org.lsst.ccs.subsystem.mcm.data.OperationTimeoutException;
import org.lsst.ccs.subsystem.mcm.data.RaftState;
import org.lsst.ccs.subsystem.mcm.data.ShutterState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public class MCM
extends GenericMCM<Minion, MinionGroup, MCMEvent, MCMState, MCMCommand> {
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    volatile ScheduledFuture<?> imageTimeoutFuture = null;

    public MCM() {
        super("MCM");
    }

    @Override
    protected void initMCM() {
        this.setState(MCMState.IDLE);
        this.mu.addSingleStateChangeToEventRule(Minion.FILTER, FcsEnumerations.FilterState.ONLINE_U, MCMEvent.filterULoaded);
        this.mu.addSingleStateChangeToEventRule(Minion.FILTER, FcsEnumerations.FilterState.ONLINE_G, MCMEvent.filterGLoaded);
        this.mu.addSingleStateChangeToEventRule(Minion.FILTER, FcsEnumerations.FilterState.ONLINE_R, MCMEvent.filterRLoaded);
        this.mu.addSingleStateChangeToEventRule(Minion.FILTER, FcsEnumerations.FilterState.ONLINE_I, MCMEvent.filterILoaded);
        this.mu.addSingleStateChangeToEventRule(Minion.FILTER, FcsEnumerations.FilterState.ONLINE_Z, MCMEvent.filterZLoaded);
        this.mu.addSingleStateChangeToEventRule(Minion.FILTER, FcsEnumerations.FilterState.ONLINE_Y, MCMEvent.filterYLoaded);
        this.mu.addSingleStateChangeToEventRule(Minion.FILTER, FcsEnumerations.FilterState.ONLINE_NONE, MCMEvent.filterNoneLoaded);
        this.mu.addDefaultStateChangeToEventRule(Minion.FILTER, FcsEnumerations.FilterState.class, MCMEvent.filterSystemMoving);
        this.mu.addSingleStateChangeToEventRule(Minion.RAFTS, RaftState.QUIESCENT, MCMEvent.ccdCleared);
        this.mu.addSingleStateChangeToEventRule(Minion.RAFTS, RaftState.INTEGRATING, MCMEvent.startIntegration);
        this.mu.addSingleStateChangeToEventRule(Minion.RAFTS, RaftState.READING_OUT, MCMEvent.startReadout);
        this.mu.addSingleStateChangeOutToEventRule(Minion.RAFTS, RaftState.READING_OUT, MCMEvent.endReadout);
        this.mu.addSingleStateChangeToEventRule(Minion.RAFTS, RaftState.NEEDS_CLEAR, MCMEvent.ccdNotReady);
        this.mu.addSingleStateChangeToEventRule(Minion.SHUTTER, ShutterState.OPENING, MCMEvent.startShutterOpen);
        this.mu.addSingleStateChangeToEventRule(Minion.SHUTTER, ShutterState.OPEN, MCMEvent.endShutterOpen);
        this.mu.addSingleStateChangeToEventRule(Minion.SHUTTER, ShutterState.CLOSING, MCMEvent.startShutterClose);
        this.mu.addSingleStateChangeToEventRule(Minion.SHUTTER, ShutterState.CLOSED, MCMEvent.endShutterClose);
    }

    @Override
    protected void initAllowedTransitions() {
        HashSet<MCMCommand> s = new HashSet<MCMCommand>();
        s.addAll(Arrays.asList(MCMCommand.values()));
        s.remove((Object)MCMCommand.DISCARDROWS);
        s.remove((Object)MCMCommand.ENDIMAGE);
        this.allowedTransition.put(MCMState.IDLE, s);
        s = new HashSet();
        s.add(MCMCommand.INITGUIDER);
        this.allowedTransition.put(MCMState.TAKINGIMAGES, s);
        s = new HashSet();
        s.add(MCMCommand.INITIMAGES);
        this.allowedTransition.put(MCMState.SETTINGFILTER, s);
        s = new HashSet();
        this.allowedTransition.put(MCMState.PREPARING, s);
        s = new HashSet();
        s.add(MCMCommand.INITGUIDER);
        s.add(MCMCommand.ENDIMAGE);
        s.add(MCMCommand.DISCARDROWS);
        this.allowedTransition.put(MCMState.IMAGESTARTED, s);
        s = new HashSet();
        this.allowedTransition.put(MCMState.CONFIGURING, s);
    }

    @Override
    protected Class<MCMState> getStateClass() {
        return MCMState.class;
    }

    @Command
    public void initImages(long delay) {
        this.checkCommandValidity(MCMCommand.INITIMAGES);
        this.setState(MCMState.PREPARING);
        this.doInitImages(delay);
        this.setState(MCMState.IDLE);
    }

    protected void doInitImages(long delay) {
        this.setAbortingOnAlarmMinions(MinionGroup.CAMERA, new Minion[0]);
        if (delay < 70L) {
            log.info((Object)"sending clear to rafts");
            this.sendAsync(MinionGroup.CAMERA, Minion.RAFTS, "clear", new Object[0]);
            log.info((Object)"sending prepare to shutter");
            this.sendAsync(MinionGroup.CAMERA, Minion.SHUTTER, "prepare", new Object[0]);
        } else {
            this.schedule(() -> this.sendAsync(MinionGroup.CAMERA, Minion.RAFTS, "clear", new Object[0]), Duration.ofMillis(delay - 70L));
            if (delay < 150L) {
                this.sendAsync(MinionGroup.CAMERA, Minion.SHUTTER, "prepare", new Object[0]);
            } else {
                this.schedule(() -> this.sendAsync(MinionGroup.CAMERA, Minion.SHUTTER, "prepare", new Object[0]), Duration.ofMillis(delay - 150L));
            }
        }
    }

    @Command
    public void configureCamera(String configId) {
        this.checkCommandValidity(MCMCommand.CONFIGURECAMERA);
        this.setState(MCMState.CONFIGURING);
        Future<?> e1 = this.execute(() -> {
            log.info((Object)"e1 - start");
            this.waitMillis(1000L);
            log.info((Object)"e1 - end");
        });
        Future<?> e2 = this.execute(() -> {
            log.info((Object)"e2 - start");
            this.waitMillis(1500L);
            log.info((Object)"e2 - end");
        });
        try {
            e2.get();
            e1.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error((Object)e);
        }
        log.info((Object)"done");
        this.setState(MCMState.IDLE);
    }

    @Command
    public void setFilter(String filterName) {
        this.setFilterSync(filterName);
    }

    @Command
    public void setFilterAsync(String filterName) {
        FcsEnumerations.FilterState goal;
        this.checkCommandValidity(MCMCommand.SETFILTER);
        this.setAbortingOnAlarmMinions(MinionGroup.CAMERA, new Minion[]{Minion.FILTER});
        filterName = filterName.toUpperCase();
        FcsEnumerations.FilterState filterState = goal = "NONE".equals(filterName) ? FcsEnumerations.FilterState.ONLINE_NONE : FcsEnumerations.FilterState.valueOf((String)("ONLINE_" + filterName));
        if (this.isInState(MinionGroup.CAMERA, Minion.FILTER, goal)) {
            log.info((Object)("MCM : filter already ok for " + filterName));
            return;
        }
        this.setState(MCMState.SETTINGFILTER);
        log.info((Object)("MCM : sending command to fcs : setFilter filter" + filterName));
        this.sendAsync(MinionGroup.CAMERA, Minion.FILTER, "setFilter", filterName);
        this.execute(() -> {
            try {
                this.waitForState(MinionGroup.CAMERA, Minion.FILTER, goal, 60000L);
            }
            catch (OperationTimeoutException e) {
                log.error((Object)"timeout while waiting", (Throwable)e);
                throw e;
            }
            catch (AlertException e) {
                log.error((Object)("alert occurred - cause= " + e.alert.getDescription()));
                throw new RuntimeException("alert occurred " + e.getMessage() + " while setFilter Alert description=" + e.alert.getDescription());
            }
            catch (Exception e) {
                log.error((Object)"error", (Throwable)e);
                throw new RuntimeException("error ", e);
            }
            finally {
                this.setState(MCMState.IDLE);
            }
        });
    }

    @Command
    public void setFilterSync(String filterName) {
        FcsEnumerations.FilterState goal;
        this.checkCommandValidity(MCMCommand.SETFILTER);
        this.setAbortingOnAlarmMinions(MinionGroup.CAMERA, new Minion[]{Minion.FILTER});
        filterName = filterName.toUpperCase();
        FcsEnumerations.FilterState filterState = goal = "NONE".equals(filterName) ? FcsEnumerations.FilterState.ONLINE_NONE : FcsEnumerations.FilterState.valueOf((String)("ONLINE_" + filterName));
        if (this.isInState(MinionGroup.CAMERA, Minion.FILTER, goal)) {
            log.info((Object)("MCM : filter already ok for " + filterName));
            return;
        }
        this.setState(MCMState.SETTINGFILTER);
        log.info((Object)("MCM : sending command to fcs : setFilter filter" + filterName));
        try {
            this.sendLongCommand(MinionGroup.CAMERA, Minion.FILTER, 60000L, "setFilter", filterName);
            this.waitForState(MinionGroup.CAMERA, Minion.FILTER, goal, 60000L);
        }
        catch (OperationTimeoutException e) {
            log.error((Object)"timeout while waiting", (Throwable)e);
            throw e;
        }
        catch (AlertException e) {
            log.error((Object)("alert occurred - cause= " + e.alert.getDescription()));
            throw new RuntimeException("alert occurred " + e.getMessage() + " while setFilter Alert description=" + e.alert.getDescription());
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new RuntimeException("error ", e);
        }
        finally {
            this.setState(MCMState.IDLE);
        }
        log.info((Object)("filter " + filterName + " is ONLINE."));
    }

    @Command
    public void takeImages(int n, int exposureMillis, boolean openShutter, boolean scienceActive, boolean guidingActive, boolean WFSActive, String seqName) {
        this.takeImagesSync(n, exposureMillis, openShutter, scienceActive, guidingActive, WFSActive, seqName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(level=1)
    public void takeImagesSync(int n, int exposureMillis, boolean openShutter, boolean scienceActive, boolean guidingActive, boolean WFSActive, String seqName) {
        this.checkCommandValidity(MCMCommand.TAKEIMAGES);
        if (openShutter && exposureMillis < 1000) {
            throw new RuntimeException("cannot handle opening the shutter for less that 1 second");
        }
        this.checkState(MinionGroup.CAMERA, Minion.FILTER, FcsEnumerations.FilterReadinessState.READY);
        this.setState(MCMState.TAKINGIMAGES);
        if (!this.isInState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.QUIESCENT)) {
            this.doInitImages(0L);
            this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.QUIESCENT, 200L);
        }
        try {
            for (int i = 0; i < n; ++i) {
                try {
                    log.info((Object)"MCM: send raft integrate");
                    this.send(MinionGroup.CAMERA, Minion.RAFTS, "integrate", new Object[0]);
                    this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.INTEGRATING, 200L);
                    log.info((Object)"MCM: raft is integrating");
                    if (openShutter) {
                        log.info((Object)"MCM: send shutter expose");
                        this.sendAsync(MinionGroup.CAMERA, Minion.SHUTTER, "expose", exposureMillis);
                        this.waitForState(MinionGroup.CAMERA, Minion.SHUTTER, ShutterState.OPEN, 1200L);
                        log.info((Object)"MCM: shutter is open");
                        this.waitForState(MinionGroup.CAMERA, Minion.SHUTTER, ShutterState.CLOSED, (long)exposureMillis + 3000L);
                        log.info((Object)"MCM: shutter is closed");
                    } else {
                        this.waitMillis(exposureMillis);
                        log.info((Object)"MCM: exposure time elapsed, with closed shutter");
                    }
                    log.info((Object)"MCM: send raft readout");
                    this.send(MinionGroup.CAMERA, Minion.RAFTS, "readout", new Object[0]);
                    this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.READING_OUT, 200L);
                    log.info((Object)"MCM: raft is reading out");
                    this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.QUIESCENT, 3000L);
                    log.info((Object)"MCM: raft is quiescent");
                    continue;
                }
                catch (OperationTimeoutException e) {
                    log.error((Object)"timeout while waiting", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    log.error((Object)"error", (Throwable)e);
                    throw new RuntimeException("error ", e);
                }
            }
        }
        finally {
            this.setState(MCMState.IDLE);
        }
    }

    @Command(level=1)
    public void takeImagesAsync(int n, int exposureMillis, boolean openShutter, boolean scienceActive, boolean guidingActive, boolean WFSActive, String seqName) {
        this.checkCommandValidity(MCMCommand.TAKEIMAGES);
        if (openShutter && exposureMillis < 1000) {
            throw new RuntimeException("cannot handle opening the shutter for less that 1 second");
        }
        this.checkState(MinionGroup.CAMERA, Minion.FILTER, FcsEnumerations.FilterReadinessState.READY);
        this.setState(MCMState.TAKINGIMAGES);
        if (!this.isInState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.QUIESCENT)) {
            this.doInitImages(0L);
            this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.QUIESCENT, 200L);
        }
        this.execute(() -> {
            try {
                for (int i = 0; i < n; ++i) {
                    try {
                        log.info((Object)"MCM: send raft integrate");
                        this.send(MinionGroup.CAMERA, Minion.RAFTS, "integrate", new Object[0]);
                        this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.INTEGRATING, 200L);
                        log.info((Object)"MCM: raft is integrating");
                        if (openShutter) {
                            log.info((Object)"MCM: send shutter expose");
                            this.sendAsync(MinionGroup.CAMERA, Minion.SHUTTER, "expose", exposureMillis);
                            this.waitForState(MinionGroup.CAMERA, Minion.SHUTTER, ShutterState.OPEN, 1200L);
                            log.info((Object)"MCM: shutter is open");
                            this.waitForState(MinionGroup.CAMERA, Minion.SHUTTER, ShutterState.CLOSED, (long)exposureMillis + 3000L);
                            log.info((Object)"MCM: shutter is closed");
                        } else {
                            this.waitMillis(exposureMillis);
                            log.info((Object)"MCM: exposure time elapsed, with closed shutter");
                        }
                        log.info((Object)"MCM: send raft readout");
                        this.send(MinionGroup.CAMERA, Minion.RAFTS, "readout", new Object[0]);
                        this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.READING_OUT, 200L);
                        log.info((Object)"MCM: raft is reading out");
                        this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.QUIESCENT, 3000L);
                        log.info((Object)"MCM: raft is quiescent");
                        continue;
                    }
                    catch (OperationTimeoutException e) {
                        log.error((Object)"timeout while waiting", (Throwable)e);
                        throw e;
                    }
                    catch (Exception e) {
                        log.error((Object)"error", (Throwable)e);
                        throw new RuntimeException("error ", e);
                    }
                }
            }
            finally {
                this.setState(MCMState.IDLE);
            }
        });
    }

    @Command
    public void initGuiders() {
        this.checkCommandValidity(MCMCommand.INITGUIDER);
    }

    @Command
    public void clear(int n) {
        this.checkCommandValidity(MCMCommand.CLEAR);
        try {
            this.send(MinionGroup.CAMERA, Minion.RAFTS, "clear", n);
        }
        catch (OperationTimeoutException e) {
            log.error((Object)"timeout while waiting", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new RuntimeException("error ", e);
        }
    }

    @Command
    public void startImage(String seqName, boolean openShutter, boolean scienceActive, boolean WFSActive, boolean guidingActive, int timeoutMillis) {
        this.checkCommandValidity(MCMCommand.STARTIMAGE);
        this.checkState(MinionGroup.CAMERA, Minion.FILTER, FcsEnumerations.FilterReadinessState.READY);
        this.setState(MCMState.IMAGESTARTED);
        if (!this.isInState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.QUIESCENT)) {
            this.doInitImages(0L);
            this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.QUIESCENT, 200L);
        }
        try {
            log.info((Object)"MCM: send raft integrate");
            this.send(MinionGroup.CAMERA, Minion.RAFTS, "integrate", new Object[0]);
            this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.INTEGRATING, 200L);
            log.info((Object)"MCM: raft is integrating");
            if (openShutter) {
                log.info((Object)"MCM: send shutter expose");
                this.sendAsync(MinionGroup.CAMERA, Minion.SHUTTER, "expose", timeoutMillis);
                this.waitForState(MinionGroup.CAMERA, Minion.SHUTTER, ShutterState.OPEN, 1200L);
                log.info((Object)"MCM: shutter is open");
            }
            this.imageTimeoutFuture = this.scheduler.schedule(() -> this.startImageTimeout(), (long)timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (OperationTimeoutException e) {
            log.error((Object)"timeout while waiting", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new RuntimeException("error ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startImageTimeout() {
        ScheduledFuture<?> scheduledFuture = this.imageTimeoutFuture;
        synchronized (scheduledFuture) {
            if (this.imageTimeoutFuture == null) {
                return;
            }
            this.imageTimeoutFuture = null;
            log.info((Object)"MCM: timeout on startImage");
            this.sendAsync(MinionGroup.CAMERA, Minion.SHUTTER, "close", new Object[0]);
            this.sendAsync(MinionGroup.CAMERA, Minion.RAFTS, "clear", new Object[0]);
            this.waitForState(MinionGroup.CAMERA, Minion.SHUTTER, ShutterState.CLOSED, 2000L);
            log.info((Object)"MCM: shutter is closed");
            this.setState(MCMState.IDLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command
    public void endImage() {
        ScheduledFuture<?> scheduledFuture = this.imageTimeoutFuture;
        synchronized (scheduledFuture) {
            if (this.imageTimeoutFuture == null) {
                return;
            }
            this.imageTimeoutFuture.cancel(false);
            this.imageTimeoutFuture = null;
            this.checkCommandValidity(MCMCommand.ENDIMAGE);
            log.info((Object)"MCM: endImage, closing shutter");
            this.sendAsync(MinionGroup.CAMERA, Minion.SHUTTER, "close", new Object[0]);
            this.waitForState(MinionGroup.CAMERA, Minion.SHUTTER, ShutterState.CLOSED, 2000L);
            log.info((Object)"MCM: shutter is closed, send raft readout");
            this.sendAsync(MinionGroup.CAMERA, Minion.RAFTS, "readout", new Object[0]);
            this.waitForState(MinionGroup.CAMERA, Minion.RAFTS, RaftState.READING_OUT, 200L);
            log.info((Object)"MCM: raft is reading out");
            this.setState(MCMState.IDLE);
        }
    }

    @Command
    public void discardRows(int n) {
        this.checkCommandValidity(MCMCommand.DISCARDROWS);
        try {
            this.send(MinionGroup.CAMERA, Minion.RAFTS, "discardRows", n);
        }
        catch (OperationTimeoutException e) {
            log.error((Object)"timeout while waiting", (Throwable)e);
            throw e;
        }
        catch (InvalidStateException e) {
            log.error((Object)"subsytem not valid state for command", (Throwable)e);
            throw new RuntimeException("subsytem not valid state for command (" + e.getMessage() + ")");
        }
        catch (Exception e) {
            log.error((Object)"error ", (Throwable)e);
            throw new RuntimeException("error ", e);
        }
    }

    public static enum MCMCommand {
        INITIMAGES,
        CONFIGURECAMERA,
        SETFILTER,
        TAKEIMAGES,
        INITGUIDER,
        CLEAR,
        STARTIMAGE,
        ENDIMAGE,
        DISCARDROWS;

    }
}

