/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;

class FocalPlaneConfigurationHandler
implements HasLifecycle {
    private volatile String[] metaDataRegisters;
    private ConfigurationListener configListener;
    private FocalPlaneAgentPresenceListener focalPlanePresenceListener;
    private static final Logger LOG = Logger.getLogger(FocalPlaneConfigurationHandler.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    Agent agent;

    FocalPlaneConfigurationHandler() {
    }

    public void start() {
        this.focalPlanePresenceListener = new FocalPlaneAgentPresenceListener(this.agent);
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.focalPlanePresenceListener);
    }

    public void shutdown() {
        this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this.focalPlanePresenceListener);
    }

    public String[] getMetaDataRegisters() {
        return this.metaDataRegisters;
    }

    private static boolean isFocalPlaneAgent(AgentInfo agentInfo) {
        return AgentCategory.FOCAL_PLANE.name().equals(agentInfo.getAgentProperty("agentCategory"));
    }

    static /* synthetic */ String[] access$102(FocalPlaneConfigurationHandler x0, String[] x1) {
        x0.metaDataRegisters = x1;
        return x1;
    }

    private class FocalPlaneAgentPresenceListener
    implements AgentPresenceListener {
        private final Agent agent;

        FocalPlaneAgentPresenceListener(Agent a) {
            this.agent = a;
        }

        public void connecting(AgentInfo ... agents) {
            for (AgentInfo a : agents) {
                if (!FocalPlaneConfigurationHandler.isFocalPlaneAgent(a)) continue;
                if (FocalPlaneConfigurationHandler.this.configListener != null) {
                    throw new RuntimeException("A configuration listener is already registered. There should be only one!");
                }
                FocalPlaneConfigurationHandler.this.configListener = new ConfigurationListener();
                this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)FocalPlaneConfigurationHandler.this.configListener);
            }
        }

        public void disconnected(AgentInfo ... agents) {
            for (AgentInfo a : agents) {
                if (!FocalPlaneConfigurationHandler.isFocalPlaneAgent(a)) continue;
                if (FocalPlaneConfigurationHandler.this.configListener == null) {
                    throw new RuntimeException("The configuration listener has already been removed!");
                }
                this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)FocalPlaneConfigurationHandler.this.configListener);
                FocalPlaneConfigurationHandler.this.configListener = null;
                FocalPlaneConfigurationHandler.access$102(FocalPlaneConfigurationHandler.this, null);
            }
        }
    }

    private class ConfigurationListener
    implements StatusMessageListener {
        private ConfigurationListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            if (!(msg instanceof StatusConfigurationInfo)) {
                return;
            }
            if (FocalPlaneConfigurationHandler.isFocalPlaneAgent(msg.getOriginAgentInfo())) {
                ConfigurationInfo ci = ((StatusConfigurationInfo)msg).getConfigurationInfo();
                for (ConfigurationParameterInfo cpi : ci.getAllParameterInfo()) {
                    if (!cpi.getComponentName().equals("focalPlaneConfig") || !cpi.getParameterName().equals("metaDataRegisters")) continue;
                    FocalPlaneConfigurationHandler.access$102(FocalPlaneConfigurationHandler.this, (String[])cpi.getCurrentValueObject());
                    LOG.log(Level.FINEST, "Updating metaDataRegister to {0}", new Object[]{Arrays.asList(FocalPlaneConfigurationHandler.this.metaDataRegisters)});
                }
            }
        }
    }
}

