/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePWM;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePulse;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.drivers.modbus.TestModbus;

public class TestMaq20
extends TestModbus {
    private static final Map<Integer, String> funcDescs = new HashMap<Integer, String>();
    private static final Map<Integer, String> timebaseDescs;
    private final Maq20 maq;

    public TestMaq20() {
        super((Modbus)new Maq20());
        this.maq = (Maq20)this.mod;
    }

    @Command(name="open", description="Open connection to general device")
    public void open(@Argument(name="type", description="Connection type") Modbus.ConnType type, @Argument(name="ident", description="Device identifier") String ident) throws DriverException {
        super.open(type, ident);
    }

    @Command(name="open", description="Open connection to general device")
    public void open(@Argument(name="type", description="Connection type") Modbus.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="param", description="Device parameter") int param) throws DriverException {
        super.open(type, ident, param);
    }

    @Command(name="open", description="Open connection to serial device")
    public void open(@Argument(name="type", description="Connection type: net, serial or ftdi") Modbus.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="baud", description="Baud rate") int baud, @Argument(name="dbits", description="The number of data bits") Ascii.DataBits dbits, @Argument(name="sbits", description="The number of stop bits") Ascii.StopBits sbits, @Argument(name="parity", description="The parity") Ascii.Parity parity, @Argument(name="flow", description="The flow control") Ascii.FlowCtrl flow) throws DriverException {
        super.open(type, ident, baud, dbits, sbits, parity, flow);
    }

    @Command(name="openusb", description="Open connection to USB device")
    public void open(@Argument(name="serial", description="Serial number") String serial) throws DriverException {
        this.maq.openUsb(serial);
    }

    @Command(name="register", description="Register modules")
    public void register(String ... serial) throws DriverException {
        this.maq.register(serial);
    }

    @Command(name="showipaddress", description="Show the IP address")
    public String showIPAddress() throws DriverException {
        return "IP address: " + this.maq.getIPAddress();
    }

    @Command(name="setipaddress", description="Set the IP address")
    public void setIPAddress(@Argument(name="ipaddr", description="IP address") String ipAddr) throws DriverException {
        this.maq.setIPAddress(ipAddr);
    }

    @Command(name="showsubnet", description="Show the subnet mask")
    public String showSubnetMask() throws DriverException {
        return "Subnet mask: " + this.maq.getSubnetMask();
    }

    @Command(name="setsubnet", description="Set the subnet mask")
    public void setSubnetMask(@Argument(name="mask", description="subnet mask") String mask) throws DriverException {
        this.maq.setSubnetMask(mask);
    }

    @Command(name="showtemperature", description="Show the temperature")
    public String showTemperature() throws DriverException {
        return "Temperature: " + this.maq.readTemperature();
    }

    @Command(name="saveparams", description="Save the parameters")
    public void saveParams() throws DriverException {
        this.maq.saveParameters();
    }

    @Command(name="showids", description="Show all module IDs")
    public String showIds() throws DriverException {
        int[] ids = this.maq.getModuleIds();
        if (ids.length == 0) {
            return "No modules present";
        }
        StringBuilder text = new StringBuilder("Valid module IDs:");
        for (int id : ids) {
            text.append(" ").append(id);
        }
        return text.toString();
    }

    @Command(name="showmodules", description="Show all modules")
    public String showModules() throws DriverException {
        int[] ids = this.maq.getModuleIds();
        if (ids.length == 0) {
            return "No modules present";
        }
        StringBuilder text = new StringBuilder("ID  Type  Serial No.");
        for (int id : ids) {
            text.append(String.format("\n%2s  %-4s  %s", new Object[]{id, this.maq.getModuleType(id), this.maq.getSerialNumber(id)}));
        }
        return text.toString();
    }

    @Command(name="showid", description="Show module's ID")
    public String showId(@Argument(name="serial", description="Serial number") String serial) throws DriverException {
        return "Module ID: " + this.maq.getModuleId(serial);
    }

    @Command(name="identify", description="Blink a module's status light")
    public void identify(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.identifyModule(modId);
    }

    @Command(name="reset", description="Reset a module")
    public void reset(@Argument(name="modid", description="Module ID") int modId, @Argument(name="deflt", description="Whether to apply defaults") boolean deflt) throws DriverException {
        this.maq.resetModule(modId, deflt);
    }

    @Command(name="showname", description="Show module's name")
    public String showName(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Device name: " + this.maq.getModuleName(modId);
    }

    @Command(name="showtype", description="Show module's type")
    public String showType(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Module type: " + (Object)((Object)this.maq.getModuleType(modId));
    }

    @Command(name="showserial", description="Show module's serial number")
    public String showSerial(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Serial number: " + this.maq.getSerialNumber(modId);
    }

    @Command(name="showrevision", description="Show module's FW revision")
    public String showFwRevision(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Firmware revision: " + this.maq.getFwRevision(modId);
    }

    @Command(name="showdate", description="Show module's date code")
    public String showDate(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Date code: " + this.maq.getDateCode(modId);
    }

    @Command(name="showninput", description="Show module's input channel count")
    public String showNumInput(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Input channel count: " + this.maq.getNumInputs(modId);
    }

    @Command(name="shownoutput", description="Show module's output channel count")
    public String showNumOutput(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Output channel count: " + this.maq.getNumOutputs(modId);
    }

    @Command(name="shownrange", description="Show module's range count")
    public String showNumRange(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Range count: " + this.maq.getAnalog(modId).getNumRanges();
    }

    @Command(name="showrange", description="Show channel's range")
    public String showRange(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return "Range: " + this.maq.getAnalog(modId).getRange(chan);
    }

    @Command(name="setrange", description="Set channel's range")
    public void setRange(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="range", description="Range number") int range) throws DriverException {
        this.maq.getAnalog(modId).setRange(chan, range);
    }

    @Command(name="showenabled", description="Show channel's enabled state")
    public String showEnabled(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return "Enabled state: " + (this.maq.getAnalIn(modId).isEnabled(chan) ? "on" : "off");
    }

    @Command(name="setenabled", description="Set channel's enabled state")
    public void setEnabled(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="state", description="Enabled state") TestModbus.OnOff state) throws DriverException {
        this.maq.getAnalIn(modId).enable(chan, state == TestModbus.OnOff.ON);
    }

    @Command(name="readvalue", description="Read channels' data values")
    public String readValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Number of channels") int count) throws DriverException {
        return this.formatDoubles(this.maq.getAnalog(modId).readValue(chan, count));
    }

    @Command(name="readvalue", description="Read channel's data value")
    public String readValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return this.formatDoubles(new double[]{this.maq.getAnalog(modId).readValue(chan)});
    }

    @Command(name="readvalue", description="Read all channels' data values")
    public String readValue(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatDoubles(this.maq.getAnalog(modId).readValue());
    }

    @Command(name="writevalue", description="Write data to channels")
    public void writeValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="First channel number") int chan, double ... values) throws DriverException {
        this.maq.getAnalOut(modId).writeValue(chan, values.length, values);
    }

    @Command(name="readdiscin", description="Read discrete input channels' values")
    public String readDiscIn(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Number of channels") int count) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).readDiscIn(chan, count));
    }

    @Command(name="readdiscin", description="Read discrete input channel's value")
    public String readDiscIn(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return this.formatIntegers(new int[]{this.maq.getDiscrete(modId).readDiscIn(chan)});
    }

    @Command(name="readdiscin", description="Read all discrete input channels' values")
    public String readDiscIn(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).readDiscIn());
    }

    @Command(name="readdiscout", description="Read discrete output channels' values")
    public String readDiscOut(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Number of channels") int count) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).readDiscOut(chan, count));
    }

    @Command(name="readdiscout", description="Read discrete output channel's value")
    public String readDiscOut(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return this.formatIntegers(new int[]{this.maq.getDiscrete(modId).readDiscOut(chan)});
    }

    @Command(name="readdiscout", description="Read all discrete output channels' values")
    public String readDiscOut(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).readDiscOut());
    }

    @Command(name="readdiscall", description="Read all discrete input channels' values")
    public String readDiscAll(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return String.format("Values mask: %08x", this.maq.getDiscIn(modId).readDiscAll());
    }

    @Command(name="writediscout", description="Write data to discrete channels")
    public void writeDiscOut(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="First channel number") int chan, int ... values) throws DriverException {
        this.maq.getDiscrete(modId).writeDisc(chan, values.length, values);
    }

    @Command(name="writediscall", description="Write data to discrete channels")
    public void writeDiscAll(@Argument(name="modid", description="Module ID") int modId, @Argument(name="value", description="Value to write") int value) throws DriverException {
        this.maq.getDiscOut(modId).writeDiscAll(value);
    }

    @Command(name="setdiscdefault", description="Set default discrete output values")
    public void setDiscDefault(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="First channel number") int chan, int ... values) throws DriverException {
        this.maq.getDiscrete(modId).setDiscDefault(chan, values.length, values);
    }

    @Command(name="setdiscdefaultall", description="Set all default discrete output values")
    public void setDiscDefaultAll(@Argument(name="modid", description="Module ID") int modId, @Argument(name="value", description="Value to write") int value) throws DriverException {
        this.maq.getDiscOut(modId).setDiscDefaultAll(value);
    }

    @Command(name="getdiscdefault", description="Get all default discrete output values")
    public String getDiscDefault(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).getDiscDefault());
    }

    @Command(name="getdiscdefaultall", description="Get all default discrete output values")
    public String getDiscDefaultAll(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return String.format("Values mask: %08x", this.maq.getDiscOut(modId).getDiscDefaultAll());
    }

    @Command(name="setdiscoff", description="Set power-off discrete output values")
    public void setDiscOff(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="First channel number") int chan, int ... values) throws DriverException {
        this.maq.getDiscOut(modId).setDiscOff(chan, values.length, values);
    }

    @Command(name="setdiscoffall", description="Set all default discrete output values")
    public void setDiscOffAll(@Argument(name="modid", description="Module ID") int modId, @Argument(name="value", description="Value to write") int value) throws DriverException {
        this.maq.getDiscOut(modId).setDiscOffAll(value);
    }

    @Command(name="getdiscoff", description="Get all power-off discrete output values")
    public String getDiscOff(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatIntegers(this.maq.getDiscOut(modId).getDiscOff());
    }

    @Command(name="getdiscoffall", description="Get all default discrete output values")
    public String getDiscOffAll(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return String.format("Values mask: %08x", this.maq.getDiscOut(modId).getDiscOffAll());
    }

    @Command(name="setfunction", description="Set discrete function code")
    public void setFunction(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan, @Argument(name="func", description="Function name") DiscFunc func) throws DriverException {
        this.maq.getDiscPulse(modId).setFunction(chan, func.getValue());
    }

    @Command(name="showfunction", description="Show discrete function code")
    public String showFunction(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        int func = this.maq.getDiscPulse(modId).getFunction(chan);
        return "Function: " + func + " (" + funcDescs.get(func) + ")";
    }

    @Command(name="armfunction", description="Arm discrete function")
    public void armFunction(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        this.maq.getDiscPulse(modId).armFunction(chan);
    }

    @Command(name="disarmfunction", description="Disarm discrete function")
    public void disarmFunction(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        this.maq.getDiscPulse(modId).disarmFunction(chan);
    }

    @Command(name="readpulse", description="Show pulse count")
    public String readPulseCount(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        return "Pulse count: " + this.maq.getDiscPulse(modId).readPulseCount(chan);
    }

    @Command(name="readfreq", description="Show frequency")
    public String readFrequency(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        return "Frequency: " + this.maq.getDiscPulse(modId).readFrequency(chan);
    }

    @Command(name="readrpm", description="Show RPM")
    public String readRPM(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        return "RPM: " + this.maq.getDiscPulse(modId).readRPM(chan);
    }

    @Command(name="setpulserev", description="Set pulses per revolution")
    public void setPulsesPerRevn(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan, @Argument(name="ppr", description="Pulses/revolution") int ppr) throws DriverException {
        Maq20DiscretePulse maqDisc = this.maq.getDiscPulse(modId);
        maqDisc.setPulsesPerRevn(chan, ppr);
        maqDisc.armFunction(chan);
    }

    @Command(name="showpulserev", description="Set pulses per revolution")
    public String showPulsesPerRevn(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        return "Pulses/revolution: " + this.maq.getDiscPulse(modId).getPulsesPerRevn(chan);
    }

    @Command(name="settimebase", description="Set PWM timebase")
    public void setTimebase(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan, @Argument(name="time", description="Timebase") Timebase timebase) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.setTimebase(chan, timebase.getValue());
        maqDisc.armFunction(chan);
    }

    @Command(name="showtimebase", description="Show PWM timebase")
    public String showTimebase(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        int timebase = this.maq.getDiscPWM(modId).getTimebase(chan);
        return "PWM timebase: " + timebase + " (" + timebaseDescs.get(timebase) + ")";
    }

    @Command(name="setperiod", description="Set PWM period")
    public void setPeriod(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan, @Argument(name="period", description="PWM period") int period) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.setPeriod(chan, period);
        maqDisc.armFunction(chan);
    }

    @Command(name="showperiod", description="Show PWM period")
    public String showPeriod(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        return "PWM period: " + this.maq.getDiscPWM(modId).getPeriod(chan);
    }

    @Command(name="setlowtime1", description="Set output 1 low time")
    public void setLowTime1(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan, @Argument(name="time", description="Time") int time) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.setLowTime1(chan, time);
        maqDisc.armFunction(chan);
    }

    @Command(name="showlowtime1", description="Show PWM output 1 low time")
    public String showLowTime1(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        return "PWM low time 1: " + this.maq.getDiscPWM(modId).getLowTime1(chan);
    }

    @Command(name="setlowtime2", description="Set output 2 low time")
    public void setLowTime2(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan, @Argument(name="time", description="Time") int time) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.setLowTime2(chan, time);
        maqDisc.armFunction(chan);
    }

    @Command(name="showlowtime2", description="Show PWM output 2 low time")
    public String showLowTime2(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        return "PWM low time 2: " + this.maq.getDiscPWM(modId).getLowTime2(chan);
    }

    @Command(name="enableout2", description="Enable/disable output 2")
    public void enableOut2(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan, @Argument(name="time", description="Time") boolean enable) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.enableOutput2(chan, enable);
        maqDisc.armFunction(chan);
    }

    @Command(name="is2enabled", description="Show whether PWM output 2 is enabled")
    public String is2Enabled(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number") int chan) throws DriverException {
        return "PWM output 2 is " + (this.maq.getDiscPWM(modId).isOutput2Enabled(chan) ? "" : "not ") + "enabled";
    }

    private String formatDoubles(double[] values) {
        StringBuilder text = new StringBuilder(values.length > 1 ? "Values:" : "Value:");
        for (double value : values) {
            text.append(String.format(" %.6g", value));
        }
        return text.toString();
    }

    private String formatIntegers(int[] values) {
        StringBuilder text = new StringBuilder(values.length > 1 ? "Values:" : "Value:");
        for (int value : values) {
            text.append(" ").append(value);
        }
        return text.toString();
    }

    static {
        funcDescs.put(0, "None");
        funcDescs.put(1, "Pulse counter");
        funcDescs.put(2, "Debounced pulse counter");
        funcDescs.put(3, "Waveform measurement");
        funcDescs.put(4, "Time between events");
        funcDescs.put(5, "Frequency generator");
        funcDescs.put(6, "PWM generator");
        funcDescs.put(7, "One-shot pulse generator");
        timebaseDescs = new HashMap<Integer, String>();
        timebaseDescs.put(0, "seconds");
        timebaseDescs.put(1, "milliseconds");
        timebaseDescs.put(2, "microseconds");
    }

    public static enum Timebase {
        SECS(0),
        MSECS(1),
        USECS(2);

        int value;

        private Timebase(int func) {
            this.value = func;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum DiscFunc {
        PULSE(1),
        PWMGEN(6),
        FREQGEN(5);

        int value;

        private DiscFunc(int func) {
            this.value = func;
        }

        int getValue() {
            return this.value;
        }
    }
}

