/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.devices.power.distribution.APC7900Device;
import org.lsst.ccs.subsystem.power.states.RebPowerState;
import org.lsst.ccs.subsystem.teststand.AP9630UPSDevice;
import org.lsst.ccs.subsystem.teststand.CryoDevice;
import org.lsst.ccs.subsystem.teststand.ThermalConfiguration;
import org.lsst.ccs.subsystem.teststand.UPSMonitor;
import org.lsst.ccs.subsystem.teststand.VQMDevice;
import org.lsst.ccs.subsystem.teststand.VacuumConfiguration;
import org.lsst.ccs.subsystem.teststand.data.TS7Outlets;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;
import org.lsst.ccs.subsystem.teststand.limits.ChannelLimits;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.Limits;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;
import org.lsst.ccs.subsystem.teststand.states.ThermalState;
import org.lsst.ccs.subsystem.teststand.states.ThermalTarget;
import org.lsst.ccs.subsystem.teststand.states.VacuumState;
import org.lsst.ccs.subsystem.teststand.states.VacuumTarget;
import org.lsst.ccs.utilities.logging.Logger;

public class TS7
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    CryoDevice cryoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    VQMDevice vqmDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    protected final Map<String, APC7900Device> pduDevicesMap = new HashMap<String, APC7900Device>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    AP9630UPSDevice upsDevc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    ThermalConfiguration thermalConfiguration;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    VacuumConfiguration vacuumConfiguration;
    @ConfigurationParameter(isFinal=true)
    private String rebPsSubsystem = "ccs-rebps";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService als;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    private Channel coldPlate1;
    private Channel coldPlate2;
    private Channel cryoPlate;
    private Channel pressureDevice;
    private final Logger LOGGER = Logger.getLogger((String)this.getClass().getPackage().getName());
    private final Object initializationLock = new Object();
    private boolean initializedRebPowerState = false;
    private RebPowerState currentRebsPowerState = RebPowerState.OFF;
    private TransitionAlgorithm vacuumTransitionAlgorithm;
    private TransitionAlgorithm coldTransitionAlgorithm1;
    private TransitionAlgorithm coldTransitionAlgorithm2;
    private TransitionAlgorithm cryoTransitionAlgorithm;
    private volatile boolean alertResponseEnabled = false;
    private UPSMonitor upsMon;

    public void postInit() {
        if (this.cryoDevc == null) {
            this.LOGGER.warning((Object)"Cryo device not defined");
        }
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, TS7.class.getCanonicalName());
        this.agentStateService.updateAgentState(new Enum[]{ThermalState.UNKNOWN, ThermalTarget.UNKNOWN, VacuumState.UNKNOWN, VacuumTarget.UNKNOWN});
        this.upsMon = new UPSMonitor(this, this.upsDevc, this.LOGGER, this.pts, this.als);
    }

    public void build() {
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("transition-timer", () -> {
            this.updateThermalLimits();
            this.updatePressureLimits();
        }));
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("ups-timer", () -> this.upsMon.monitorUPS()));
        this.pts.setPeriodicTaskPeriod("ups-timer", Duration.ofSeconds(1L));
    }

    @Command(type=Command.CommandType.ACTION, description="Change the thermal goal for the subsystem")
    public void setThermalGoal(ThermalTarget goal) {
        if (!this.agentStateService.isInState((Enum)goal) || goal == ThermalTarget.CURRENT) {
            double cryoPlateNominalInitialValue;
            double coldPlate2NominalInitialValue;
            double coldPlate1NominalInitialValue;
            Limits cryoPlateInitialLimits;
            Limits coldPlate2InitialLimits;
            Limits coldPlate1InitialLimits;
            if (goal == ThermalTarget.UNKNOWN) {
                throw new IllegalArgumentException("Cannot transition to " + goal);
            }
            this.LOGGER.info((Object)("Switching to thermal goal " + goal));
            if (!(this.agentStateService.isComponentInState(this.coldPlate1.getName(), (Enum)DataProviderState.NOMINAL) && this.agentStateService.isComponentInState(this.coldPlate2.getName(), (Enum)DataProviderState.NOMINAL) && this.agentStateService.isComponentInState(this.cryoPlate.getName(), (Enum)DataProviderState.NOMINAL))) {
                throw new IllegalArgumentException("Cannot start a Thermal transition when the temperatures are not NOMINAL.");
            }
            ChannelLimits coldPlateLimits1 = new ChannelLimits(this.coldPlate1);
            ChannelLimits coldPlateLimits2 = new ChannelLimits(this.coldPlate2);
            ChannelLimits cryoPlateLimits = new ChannelLimits(this.cryoPlate);
            if (this.agentStateService.isInState((Enum)ThermalState.AT_TARGET)) {
                coldPlate1InitialLimits = new Limits(this.thermalConfiguration.coldSetPointLimits);
                coldPlate2InitialLimits = new Limits(this.thermalConfiguration.coldSetPointLimits);
                cryoPlateInitialLimits = new Limits(this.thermalConfiguration.cryoSetPointLimits);
                coldPlate1NominalInitialValue = this.thermalConfiguration.coldSetPoint;
                coldPlate2NominalInitialValue = this.thermalConfiguration.coldSetPoint;
                cryoPlateNominalInitialValue = this.thermalConfiguration.cryoSetPoint;
            } else {
                coldPlate1InitialLimits = new Limits(coldPlateLimits1);
                coldPlate2InitialLimits = new Limits(coldPlateLimits2);
                cryoPlateInitialLimits = new Limits(cryoPlateLimits);
                coldPlate1NominalInitialValue = this.coldPlate1.getValue();
                coldPlate2NominalInitialValue = this.coldPlate2.getValue();
                cryoPlateNominalInitialValue = this.cryoPlate.getValue();
            }
            if (goal == ThermalTarget.CURRENT) {
                String thermalConfigurationName = this.subsys.getComponentLookup().getNameOfComponent((Object)this.thermalConfiguration);
                this.configurationService.submitChanges(thermalConfigurationName, this.getCurrentThermalConfigurationParameters());
                this.configurationService.commitBulkChange();
            } else {
                if (this.agentStateService.isInState((Enum)ThermalTarget.UNKNOWN)) {
                    throw new IllegalArgumentException("Cannot initiate a transition to " + goal + " from " + ThermalTarget.UNKNOWN + ". You must first set the ThermalTarget to " + ThermalTarget.CURRENT);
                }
                this.configurationService.loadCategories(new String[]{"thermal:" + goal.name().toLowerCase()});
            }
            long time = System.currentTimeMillis();
            LimitAlgorithm coldLimitsAlgorithm1 = this.thermalConfiguration.createColdLimitsAlgorithm(coldPlate1NominalInitialValue, coldPlate1InitialLimits);
            this.coldTransitionAlgorithm1 = this.thermalConfiguration.createColdTransitionAlgorithm(coldLimitsAlgorithm1, this.coldPlate1.getValue(), coldPlateLimits1, time);
            LimitAlgorithm coldLimitsAlgorithm2 = this.thermalConfiguration.createColdLimitsAlgorithm(coldPlate2NominalInitialValue, coldPlate2InitialLimits);
            this.coldTransitionAlgorithm2 = this.thermalConfiguration.createColdTransitionAlgorithm(coldLimitsAlgorithm2, this.coldPlate2.getValue(), coldPlateLimits2, time);
            LimitAlgorithm cryoLimitsAlgorithm = this.thermalConfiguration.createCryoLimitsAlgorithm(cryoPlateNominalInitialValue, cryoPlateInitialLimits);
            this.cryoTransitionAlgorithm = this.thermalConfiguration.createCryoTransitionAlgorithm(cryoLimitsAlgorithm, this.cryoPlate.getValue(), coldPlateLimits2, time);
            this.agentStateService.updateAgentState(new Enum[]{goal, ThermalState.IN_TRANSITION});
            this.updateThermalLimits();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Change the thermal goal for the subsystem")
    public void setVacuumGoal(VacuumTarget goal) {
        if (!this.agentStateService.isInState((Enum)goal) || goal == VacuumTarget.CURRENT) {
            double pressureNominalInitialValue;
            Limits pressureInitialLimits;
            if (goal == VacuumTarget.UNKNOWN) {
                throw new IllegalArgumentException("Cannot transition to " + goal);
            }
            if (!this.agentStateService.isComponentInState(this.pressureDevice.getName(), (Enum)DataProviderState.NOMINAL)) {
                throw new IllegalArgumentException("Cannot start a Vacuum transition when the pressure is not NOMINAL.");
            }
            ChannelLimits pressureLimits = new ChannelLimits(this.pressureDevice);
            if (this.agentStateService.isInState((Enum)VacuumState.AT_TARGET)) {
                pressureInitialLimits = new Limits(this.vacuumConfiguration.pressureSetPointLimits);
                pressureNominalInitialValue = this.vacuumConfiguration.pressureSetPoint;
            } else {
                pressureInitialLimits = new Limits(pressureLimits);
                pressureNominalInitialValue = this.pressureDevice.getValue();
            }
            if (goal == VacuumTarget.CURRENT) {
                String vacuumConfigurationName = this.subsys.getComponentLookup().getNameOfComponent((Object)this.vacuumConfiguration);
                this.configurationService.submitChanges(vacuumConfigurationName, this.getCurrentVacuumConfigurationParameters());
                this.configurationService.commitBulkChange();
            } else {
                if (this.agentStateService.isInState((Enum)VacuumTarget.UNKNOWN)) {
                    throw new IllegalArgumentException("Cannot initiate a transition to " + goal + " from " + VacuumTarget.UNKNOWN + ". You must first set the VacuumTarget to " + VacuumTarget.CURRENT);
                }
                this.configurationService.loadCategories(new String[]{"vacuum:" + goal.name().toLowerCase()});
            }
            LimitAlgorithm pressureLimitsAlgorithm = this.vacuumConfiguration.createVacuumLimitsAlgorithm(pressureNominalInitialValue, pressureInitialLimits);
            this.vacuumTransitionAlgorithm = this.vacuumConfiguration.createVacuumTransitionAlgorithm(pressureLimitsAlgorithm, this.pressureDevice.getValue(), pressureLimits, System.currentTimeMillis());
            this.agentStateService.updateAgentState(new Enum[]{goal, VacuumState.IN_TRANSITION});
            this.updatePressureLimits();
        }
    }

    private synchronized void updateThermalLimits() {
        long time = System.currentTimeMillis();
        if (this.agentStateService.isInState((Enum)ThermalState.IN_TRANSITION)) {
            boolean allAtTarget = true;
            double dataPoint = this.coldPlate1.getValue();
            boolean atTarget = this.coldTransitionAlgorithm1.isAtTarget(dataPoint, time);
            if (!atTarget) {
                this.coldTransitionAlgorithm1.adjustLimits(dataPoint, time);
                allAtTarget = false;
            } else {
                this.coldTransitionAlgorithm1.completeTransition(time);
            }
            this.LOGGER.info((Object)("Update: Cold plate 1 state is " + (atTarget ? "in transition" : "at target") + " current limits are " + this.coldTransitionAlgorithm1.getLimits()));
            dataPoint = this.coldPlate2.getValue();
            atTarget = this.coldTransitionAlgorithm2.isAtTarget(dataPoint, time);
            if (!atTarget) {
                this.coldTransitionAlgorithm2.adjustLimits(dataPoint, time);
                allAtTarget = false;
            } else {
                this.coldTransitionAlgorithm2.completeTransition(time);
            }
            this.LOGGER.info((Object)("Update: Cold plate 2 state is " + (atTarget ? "in transition" : "at target") + " current limits are " + this.coldTransitionAlgorithm2.getLimits()));
            dataPoint = this.cryoPlate.getValue();
            atTarget = this.cryoTransitionAlgorithm.isAtTarget(dataPoint, time);
            if (!atTarget) {
                this.cryoTransitionAlgorithm.adjustLimits(dataPoint, time);
                allAtTarget = false;
            } else {
                this.cryoTransitionAlgorithm.completeTransition(time);
            }
            if (allAtTarget) {
                this.agentStateService.updateAgentState(new Enum[]{ThermalState.AT_TARGET});
            }
        } else {
            ThermalState state = this.getCurrentThermalState();
            this.agentStateService.updateAgentState(new Enum[]{state});
        }
    }

    private ThermalState getCurrentThermalState() {
        ThermalState state = ThermalState.UNKNOWN;
        if (this.coldTransitionAlgorithm1 != null && this.coldTransitionAlgorithm2 != null && this.cryoTransitionAlgorithm != null) {
            state = ThermalState.AT_TARGET;
            long time = System.currentTimeMillis();
            double dataPoint = this.coldPlate1.getValue();
            if (!this.coldTransitionAlgorithm1.isAtTarget(dataPoint, time)) {
                return ThermalState.OFF_TARGET;
            }
            dataPoint = this.coldPlate2.getValue();
            if (!this.coldTransitionAlgorithm2.isAtTarget(dataPoint, time)) {
                return ThermalState.OFF_TARGET;
            }
            dataPoint = this.cryoPlate.getValue();
            if (!this.cryoTransitionAlgorithm.isAtTarget(dataPoint, time)) {
                return ThermalState.OFF_TARGET;
            }
        }
        return state;
    }

    private synchronized void updatePressureLimits() {
        long time = System.currentTimeMillis();
        if (this.agentStateService.isInState((Enum)VacuumState.IN_TRANSITION)) {
            double dataPoint = this.pressureDevice.getValue();
            boolean atTarget = this.vacuumTransitionAlgorithm.isAtTarget(dataPoint, time);
            if (!atTarget) {
                this.vacuumTransitionAlgorithm.adjustLimits(dataPoint, time);
            } else {
                this.vacuumTransitionAlgorithm.completeTransition(time);
                this.agentStateService.updateAgentState(new Enum[]{VacuumState.AT_TARGET});
            }
        } else {
            VacuumState state = this.getCurrentVacuumState();
            this.agentStateService.updateAgentState(new Enum[]{state});
        }
    }

    private VacuumState getCurrentVacuumState() {
        VacuumState state = VacuumState.UNKNOWN;
        if (this.vacuumTransitionAlgorithm != null) {
            state = VacuumState.AT_TARGET;
            long time = System.currentTimeMillis();
            double dataPoint = this.pressureDevice.getValue();
            if (!this.vacuumTransitionAlgorithm.isAtTarget(dataPoint, time)) {
                return VacuumState.OFF_TARGET;
            }
        }
        return state;
    }

    public void postStart() {
        Predicate filter = BusMessageFilterFactory.messageOrigin((String)this.rebPsSubsystem);
        this.subsys.getMessagingAccess().addStatusMessageListener(msg -> this.handlePowerSupplyMessage(msg), filter);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU names")
    public List<String> getPduNames() {
        return new ArrayList<String>(this.pduDevicesMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU outlet names")
    public List<String> getOutletNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            for (String outletName : this.pduDevicesMap.get(pduName).getOutletNames()) {
                names.add(pduName + "/" + outletName);
            }
        }
        return names;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the map of PDU outlet on states")
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        HashMap<String, Boolean> states = new HashMap<String, Boolean>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            Map pduStates = this.pduDevicesMap.get(pduName).getOutletOnStateMap();
            for (String outletName : pduStates.keySet()) {
                states.put(pduName + "/" + outletName, (Boolean)pduStates.get(outletName));
            }
        }
        return states;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePowerSupplyMessage(StatusMessage msg) {
        Object object = this.initializationLock;
        synchronized (object) {
            StateBundle sb;
            if (this.initializedRebPowerState && msg instanceof StatusStateChangeNotification) {
                StatusStateChangeNotification ssn = (StatusStateChangeNotification)msg;
                sb = ssn.getNewState();
            } else {
                sb = !this.initializedRebPowerState ? msg.getState() : null;
            }
            if (sb != null) {
                RebPowerState powerState = (RebPowerState)sb.getState(RebPowerState.class);
                if (powerState != null) {
                    this.initializedRebPowerState = true;
                }
                if (this.currentRebsPowerState != powerState) {
                    this.currentRebsPowerState = powerState;
                    new Thread(() -> this.updatePowerState(this.currentRebsPowerState, sb.getComponentsWithState(RebPowerState.class))).start();
                }
            }
        }
    }

    public RebPowerState getCurrentRebsPowerState() {
        return this.currentRebsPowerState;
    }

    private void updatePowerState(RebPowerState state, Map<String, RebPowerState> map) {
        String rebStateStr = "";
        for (Map.Entry<String, RebPowerState> e : map.entrySet()) {
            rebStateStr = rebStateStr + e.getKey() + "=" + e.getValue() + " ";
        }
        this.LOGGER.info((Object)("Updating power state to " + state + " " + rebStateStr));
    }

    @Command(type=Command.CommandType.ACTION, description="Turn Off named outlet")
    public void turnOutletOff(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, false);
    }

    @Command(type=Command.CommandType.ACTION, description="Turn On named outlet")
    public void turnOutletOn(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, true);
    }

    private void changeOutletState(TS7Outlets outlet, boolean on) throws DriverException {
        String outletName = outlet.getOutletName();
        for (APC7900Device pdu : this.pduDevicesMap.values()) {
            if (!pdu.getOutletNames().contains(outletName)) continue;
            if (on) {
                pdu.forceOutletOn(outletName);
            } else {
                pdu.forceOutletOff(outletName);
            }
            return;
        }
        throw new IllegalArgumentException("Could not find device to turn off outlet " + outletName);
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/disable alert response")
    public void enableAlertResponse(boolean enable) {
        this.alertResponseEnabled = enable;
    }

    @Command(type=Command.CommandType.QUERY, description="Get true/false if the alert response is enabled")
    public boolean isAlertResponseEnabled() {
        return this.alertResponseEnabled;
    }

    private Map getCurrentThermalConfigurationParameters() {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("coldSetPoint", (this.coldPlate1.getValue() + this.coldPlate2.getValue()) / 2.0);
        changes.put("cryoSetPoint", this.cryoPlate.getValue());
        double coldPlateLimitLow = Math.min(this.coldPlate1.getLimitLo(), this.coldPlate2.getLimitLo());
        double coldPlateWarningLow = coldPlateLimitLow + Math.min(this.coldPlate1.getDbandLo(), this.coldPlate2.getDbandLo());
        double coldPlateLimitHigh = Math.max(this.coldPlate1.getLimitHi(), this.coldPlate1.getLimitHi());
        double coldPlateWarningHigh = coldPlateLimitHigh - Math.min(this.coldPlate1.getDbandHi(), this.coldPlate2.getDbandHi());
        ArrayList<Double> coldSetPointLimits = new ArrayList<Double>();
        coldSetPointLimits.add(coldPlateLimitLow);
        coldSetPointLimits.add(coldPlateWarningLow);
        coldSetPointLimits.add(coldPlateWarningHigh);
        coldSetPointLimits.add(coldPlateLimitHigh);
        double cryoPlateLimitLow = this.cryoPlate.getLimitLo();
        double cryoPlateWarningLow = cryoPlateLimitLow + this.cryoPlate.getDbandLo();
        double cryoPlateLimitHigh = this.cryoPlate.getLimitHi();
        double cryoPlateWarningHigh = cryoPlateLimitHigh - this.cryoPlate.getDbandHi();
        ArrayList<Double> cryoSetPointLimits = new ArrayList<Double>();
        cryoSetPointLimits.add(cryoPlateLimitLow);
        cryoSetPointLimits.add(cryoPlateWarningLow);
        cryoSetPointLimits.add(cryoPlateWarningHigh);
        cryoSetPointLimits.add(cryoPlateLimitHigh);
        changes.put("coldSetPointLimits", coldSetPointLimits);
        changes.put("cryoSetPointLimits", cryoSetPointLimits);
        changes.put("coldMonitoringLimitAlgorithm", "DELTA");
        changes.put("cryoMonitoringLimitAlgorithm", "DELTA");
        changes.put("coldMonitoringLimitAlgorithmParameters", new ArrayList());
        changes.put("cryoMonitoringLimitAlgorithmParameters", new ArrayList());
        changes.put("coldMonitoringTransitionAlgorithm", "RATCHET");
        changes.put("cryoMonitoringTransitionAlgorithm", "RATCHET");
        changes.put("coldMonitoringTransitionAlgorithmParameters", new ArrayList());
        changes.put("cryoMonitoringTransitionAlgorithmParameters", new ArrayList());
        return changes;
    }

    private Map getCurrentVacuumConfigurationParameters() {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("pressureSetPoint", this.pressureDevice.getValue());
        double pressurePlateLimitLow = this.pressureDevice.getLimitLo();
        double pressurePlateWarningLow = pressurePlateLimitLow + this.pressureDevice.getDbandLo();
        double pressurePlateLimitHigh = this.pressureDevice.getLimitHi();
        double pressurePlateWarningHigh = pressurePlateLimitHigh - this.pressureDevice.getDbandHi();
        ArrayList<Double> pressureSetPointLimits = new ArrayList<Double>();
        pressureSetPointLimits.add(pressurePlateLimitLow);
        pressureSetPointLimits.add(pressurePlateWarningLow);
        pressureSetPointLimits.add(pressurePlateWarningHigh);
        pressureSetPointLimits.add(pressurePlateLimitHigh);
        changes.put("pressureSetPointLimits", pressureSetPointLimits);
        changes.put("pressureMonitoringLimitAlgorithm", "PROPORTIONAL");
        changes.put("pressureMonitoringLimitAlgorithmParameters", new ArrayList());
        changes.put("pressureMonitoringTransitionAlgorithm", "RATCHET");
        changes.put("pressureMonitoringTransitionAlgorithmParameters", new ArrayList());
        return changes;
    }
}

