/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.ValveMaq20Device;
import org.lsst.ccs.subsystem.refrig.constants.ValvePosnState;
import org.lsst.ccs.subsystem.refrig.constants.ValveSetState;

public class HexValve
implements HasLifecycle {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    ValveMaq20Device maqDevc;
    private String set;
    private String getOpen;
    private String getShut;
    private static final Logger LOG = Logger.getLogger(HexValve.class.getName());
    private int setIndex;
    private int setChan;
    private int getOpenIndex;
    private int getOpenChan;
    private int getShutIndex;
    private int getShutChan;

    public void init() {
        if (this.maqDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MAQ20 device", (String)"not defined");
        }
        if (this.set == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"set", (String)"not specified");
        }
        int[] values = this.getChanParams("set", this.set);
        this.setIndex = values[0];
        this.setChan = values[1];
        if (!this.maqDevc.registerOut(this.setIndex, this.setChan)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"set", (String)"is a duplicate or refers to incorrect module type");
        }
        if (this.getOpen == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"getOpen", (String)"not specified");
        }
        values = this.getChanParams("getOpen", this.getOpen);
        this.getOpenIndex = values[0];
        this.getOpenChan = values[1];
        if (!this.maqDevc.registerIn(this.getOpenIndex, this.getOpenChan)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"getOpen", (String)"is a duplicate or refers to incorrect module type");
        }
        if (this.getShut == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"getShut", (String)"not specified");
        }
        values = this.getChanParams("getShut", this.getShut);
        this.getShutIndex = values[0];
        this.getShutChan = values[1];
        if (!this.maqDevc.registerIn(this.getShutIndex, this.getShutChan)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"getShut", (String)"is a duplicate or refers to incorrect module type");
        }
    }

    public void setOpen() {
        this.maqDevc.setValve(this.setIndex, this.setChan, false);
    }

    public void setShut() {
        this.maqDevc.setValve(this.setIndex, this.setChan, true);
    }

    public ValveSetState getSetState() {
        Boolean outState = this.maqDevc.isValveSet(this.setIndex, this.setChan);
        return outState == null ? ValveSetState.OFFLINE : (outState != false ? ValveSetState.SHUT : ValveSetState.OPEN);
    }

    public ValvePosnState getPosnState() {
        Boolean openState = this.maqDevc.isPositionSet(this.getOpenIndex, this.getOpenChan);
        Boolean shutState = this.maqDevc.isPositionSet(this.getShutIndex, this.getShutChan);
        return openState == null || shutState == null ? ValvePosnState.OFFLINE : (openState.booleanValue() ? (shutState.booleanValue() ? ValvePosnState.BOTH : ValvePosnState.OPEN) : (shutState != false ? ValvePosnState.SHUT : ValvePosnState.NONE));
    }

    private int[] getChanParams(String chanName, String chanDesc) {
        String[] fields = chanDesc.split(":");
        if (fields.length != 2) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)chanName, (String)"must have two colon-separated values");
        }
        int[] values = new int[2];
        for (int j = 0; j < 2; ++j) {
            try {
                values[j] = Integer.decode(fields[j]);
                continue;
            }
            catch (NumberFormatException e) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)chanName, (String)"must specify integer values");
            }
        }
        if (values[0] < 0 || values[0] >= this.maqDevc.getModuleCount()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)chanName, (String)"has invalid module index");
        }
        if (values[1] < 0 || values[1] >= 20) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)chanName, (String)"has invalid channel number");
        }
        return values;
    }
}

