/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.subsystem.common.devices.pluto.PlutoDevice;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;

public class CompPlutoDevice
extends PlutoDevice
implements Compressor.SwitchDevice {
    public static final int SW_ENABLE = 0;
    public static final int SW_LIGHTS = 1;
    public static final int NUM_COLD_SWITCHES = 2;
    public static final int SW_HEATER = 2;
    public static final int NUM_CRYO_SWITCHES = 3;
    private static final int NUM_AREAS = 15;
    private static final int SWDI_ON_BIT = 0;
    private static final int SWDI_READ_AREA = 1;
    private static final int SWDI_READ_BIT = 2;
    private static final int LTDI_AREA = 0;
    private static final int LTDI_READ_BIT = 1;
    private static final int LTDI_WARN_BIT = 2;
    private static final int LTDI_PEND_BIT = 3;
    private static final int CNDI_READ_AREA = 0;
    private static final int CNDI_READ_BIT = 1;
    private static final int RESET_BIT = 0;
    private static final int[][] COLD_SWITCHES = new int[2][];
    private static final int[][] CRYO_SWITCHES;
    private static final int[][] COLD_LATCHES;
    private static final int[][] CRYO_LATCHES;
    private static final int[][] COLD_CONDITIONS;
    private static final int[][] CRYO_CONDITIONS;
    private int[][] switches;
    private int[][] latches;
    private int[][] conditions;

    public CompPlutoDevice() {
        super(15);
    }

    public void setType(int type) {
        this.switches = type == 0 ? COLD_SWITCHES : CRYO_SWITCHES;
        this.latches = type == 0 ? COLD_LATCHES : CRYO_LATCHES;
        this.conditions = type == 0 ? COLD_CONDITIONS : CRYO_CONDITIONS;
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        int bitNum = this.switches[sw][0];
        this.writeBit(bitNum / 16, bitNum & 0xF, on ? 1 : 0);
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        int[] swData = this.switches[sw];
        Integer value = this.readAddBit(swData[1], swData[2]);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public LatchState getLatchState(int cond) {
        int[] latchData = this.latches[cond];
        Integer value = this.readAddInt(latchData[0]);
        return value == null ? LatchState.OFFLINE : ((value & 1 << latchData[3]) != 0 ? LatchState.LATCHED : ((value & 1 << latchData[1]) == 0 ? LatchState.ACTIVE : ((value & 1 << latchData[2]) != 0 ? LatchState.WARNING : LatchState.CLEAR)));
    }

    public ConditionState getConditionState(int cond) {
        int[] condData = this.conditions[cond];
        Integer value = this.readAddBit(condData[0], condData[1]);
        return value == null ? ConditionState.OFF : (value != 0 ? ConditionState.YES : ConditionState.NO);
    }

    public void resetLatches() {
        this.writeBit(0, 0, 1);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.writeBit(0, 0, 0);
    }

    static {
        CompPlutoDevice.COLD_SWITCHES[0] = new int[]{1, 10, 23};
        CompPlutoDevice.COLD_SWITCHES[1] = new int[]{2, 14, 18};
        CRYO_SWITCHES = new int[3][];
        CompPlutoDevice.CRYO_SWITCHES[0] = new int[]{1, 10, 23};
        CompPlutoDevice.CRYO_SWITCHES[1] = new int[]{2, 14, 18};
        CompPlutoDevice.CRYO_SWITCHES[2] = new int[]{3, 14, 26};
        COLD_LATCHES = new int[10][];
        CompPlutoDevice.COLD_LATCHES[0] = new int[]{11, 17, 20, 19};
        CompPlutoDevice.COLD_LATCHES[1] = new int[]{11, 22, 32, 24};
        CompPlutoDevice.COLD_LATCHES[2] = new int[]{11, 27, 32, 29};
        CompPlutoDevice.COLD_LATCHES[3] = new int[]{12, 17, 20, 19};
        CompPlutoDevice.COLD_LATCHES[4] = new int[]{12, 27, 30, 29};
        CompPlutoDevice.COLD_LATCHES[5] = new int[]{13, 17, 32, 19};
        CompPlutoDevice.COLD_LATCHES[6] = new int[]{13, 22, 32, 24};
        CompPlutoDevice.COLD_LATCHES[7] = new int[]{13, 27, 32, 29};
        CompPlutoDevice.COLD_LATCHES[9] = new int[]{14, 27, 32, 29};
        CRYO_LATCHES = new int[10][];
        CompPlutoDevice.CRYO_LATCHES[0] = new int[]{11, 17, 20, 19};
        CompPlutoDevice.CRYO_LATCHES[1] = new int[]{11, 22, 32, 24};
        CompPlutoDevice.CRYO_LATCHES[9] = new int[]{11, 27, 32, 29};
        CompPlutoDevice.CRYO_LATCHES[3] = new int[]{12, 17, 20, 19};
        CompPlutoDevice.CRYO_LATCHES[4] = new int[]{12, 27, 30, 29};
        CompPlutoDevice.CRYO_LATCHES[5] = new int[]{13, 17, 32, 19};
        CompPlutoDevice.CRYO_LATCHES[6] = new int[]{13, 22, 32, 24};
        CompPlutoDevice.CRYO_LATCHES[7] = new int[]{12, 22, 32, 24};
        CompPlutoDevice.CRYO_LATCHES[8] = new int[]{13, 27, 32, 29};
        COLD_CONDITIONS = new int[16][];
        CompPlutoDevice.COLD_CONDITIONS[1] = new int[]{10, 24};
        CompPlutoDevice.COLD_CONDITIONS[2] = new int[]{10, 28};
        CompPlutoDevice.COLD_CONDITIONS[3] = new int[]{10, 29};
        CompPlutoDevice.COLD_CONDITIONS[7] = new int[]{10, 19};
        CompPlutoDevice.COLD_CONDITIONS[4] = new int[]{10, 16};
        CompPlutoDevice.COLD_CONDITIONS[6] = new int[]{10, 18};
        CompPlutoDevice.COLD_CONDITIONS[8] = new int[]{10, 20};
        CompPlutoDevice.COLD_CONDITIONS[5] = new int[]{10, 17};
        CompPlutoDevice.COLD_CONDITIONS[9] = new int[]{10, 21};
        CompPlutoDevice.COLD_CONDITIONS[10] = new int[]{10, 22};
        CompPlutoDevice.COLD_CONDITIONS[11] = new int[]{10, 25};
        CompPlutoDevice.COLD_CONDITIONS[0] = new int[]{14, 19};
        CompPlutoDevice.COLD_CONDITIONS[12] = new int[]{14, 23};
        CompPlutoDevice.COLD_CONDITIONS[13] = new int[]{13, 30};
        CRYO_CONDITIONS = new int[16][];
        CompPlutoDevice.CRYO_CONDITIONS[1] = new int[]{10, 24};
        CompPlutoDevice.CRYO_CONDITIONS[2] = new int[]{10, 28};
        CompPlutoDevice.CRYO_CONDITIONS[3] = new int[]{10, 29};
        CompPlutoDevice.CRYO_CONDITIONS[7] = new int[]{10, 19};
        CompPlutoDevice.CRYO_CONDITIONS[4] = new int[]{10, 16};
        CompPlutoDevice.CRYO_CONDITIONS[15] = new int[]{10, 18};
        CompPlutoDevice.CRYO_CONDITIONS[8] = new int[]{10, 20};
        CompPlutoDevice.CRYO_CONDITIONS[5] = new int[]{10, 17};
        CompPlutoDevice.CRYO_CONDITIONS[9] = new int[]{10, 21};
        CompPlutoDevice.CRYO_CONDITIONS[10] = new int[]{10, 22};
        CompPlutoDevice.CRYO_CONDITIONS[11] = new int[]{10, 25};
        CompPlutoDevice.CRYO_CONDITIONS[0] = new int[]{14, 19};
        CompPlutoDevice.CRYO_CONDITIONS[12] = new int[]{14, 23};
        CompPlutoDevice.CRYO_CONDITIONS[13] = new int[]{12, 25};
        CompPlutoDevice.CRYO_CONDITIONS[14] = new int[]{12, 16};
    }
}

