/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.LoaderDisconnectedException;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;

public class APCTestBench2CanBusMain
extends MainModule {
    protected BridgeToHardware bridgeToLoader;
    private Thermometer thermometer;
    private CanOpenLED led;
    private CanOpenLED fakeLed;
    private Thermometer fakeSensor;
    public double temperature;
    private boolean ledOn = false;

    public APCTestBench2CanBusMain(BridgeToHardware bridge, BridgeToHardware bridgeToLoader) {
        super(bridge);
        this.bridgeToLoader = bridgeToLoader;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the changer is connected.")
    public boolean isChangerConnected() {
        return this.bridge.isReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected.")
    public boolean isLoaderConnected() {
        return this.bridgeToLoader.isReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the changer is ready.")
    public boolean isChangerReady() {
        return this.bridge.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the loader is ready.")
    public boolean isLoaderReady() {
        return this.bridgeToLoader.allDevicesBooted();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Disconnect the (fake) loader.")
    public void disconnectLoader() throws InterruptedException {
        this.bridgeToLoader.disconnectHardware();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Connect the (fake) loader.")
    public void connectLoader() {
        this.bridgeToLoader.connectHardware();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read temperature.")
    public double readTemperature() throws LoaderDisconnectedException {
        try {
            return this.thermometer.readTemperature();
        }
        catch (FcsHardwareException ex) {
            if (ex instanceof HardwareNotDetectedException) {
                throw new LoaderDisconnectedException(ex.getMessage());
            }
            return 0.0;
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Turn ON the Led.")
    public String turnOnLED() {
        this.led.turnON();
        this.ledOn = true;
        return "LED is turned ON";
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Turn OFF the Led.")
    public String turnOffLED() {
        this.led.turnOFF();
        this.ledOn = false;
        return "LED is turned OFF";
    }

    @Override
    public void updateStateWithSensors() {
    }

    @Override
    public void initializeHardware() {
        this.bridge.bootProcess();
        this.bridgeToLoader.bootProcess();
    }
}

