/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;

public class LoaderHook {
    @LookupName
    private String name;
    private final DigitalSensor closeSensor;
    private final DigitalSensor openSensor;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private boolean inError;

    public LoaderHook(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.closeSensor = closeSensor;
        this.openSensor = openSensor;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state from sensors values.")
    public void updateState() {
        boolean bl = this.inError = this.closeSensor.isOn() && this.openSensor.isOn();
        this.lockStatus = this.closeSensor.isOn() && this.openSensor.isOn() ? FcsEnumerations.LockStatus.ERROR : (this.closeSensor.isOn() ? FcsEnumerations.LockStatus.CLOSED : (this.openSensor.isOn() ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="display sensors info")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("#closeSensor=");
        sb.append(this.closeSensor.toString());
        sb.append("#openSensor=");
        sb.append(this.openSensor.toString());
        return sb.toString();
    }

    StatusDataPublishedByLoaderHook createStatusDataPublishedByLoaderHook() {
        return new StatusDataPublishedByLoaderHook(this.closeSensor.isOn(), this.openSensor.isOn(), this.inError, this.lockStatus);
    }
}

