/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;

public class ScriptingCommands {
    private final FocalPlaneSubsystem subsys;
    private static final Logger LOG = Logger.getLogger(ScriptingCommands.class.getName());

    ScriptingCommands(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }

    @Command(type=Command.CommandType.QUERY, description="Wait for FITS files to be saved", level=0, autoAck=false)
    public FileList waitForFitsFiles(@Argument(defaultValue="PT30S") Duration timeout) {
        return (FileList)this.subsys.helper().enterFaultOnException(true).duration(timeout).action(() -> this.subsys.getImageMessageHandling().waitForFITSFiles(timeout));
    }

    @Command(type=Command.CommandType.QUERY, description="Wait for image data to arrive", level=0, autoAck=false)
    public void waitForImages(@Argument(defaultValue="PT30S") Duration timeout) {
        this.subsys.helper().enterFaultOnException(true).duration(timeout).action(() -> this.subsys.getImageMessageHandling().waitForImages(timeout));
    }

    @Command(type=Command.CommandType.QUERY, description="Wait for sequencer to stop", level=0, autoAck=false)
    public void waitForSequencer(@Argument(defaultValue="PT30S") Duration timeout) {
        this.subsys.helper().enterFaultOnException(true).duration(timeout).action(() -> ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).waitFor(t -> t.isInState((Enum)FocalPlaneState.QUIESCENT) || t.isInState((Enum)FocalPlaneState.NEEDS_CLEAR), timeout.toMillis(), TimeUnit.MILLISECONDS));
    }
}

