/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.utility.MpmMain;

public class WattsUpDevice
extends Device
implements WattsUp.Listener {
    public static final int CHAN_WATTS = 0;
    public static final int CHAN_VOLTS = 1;
    public static final int CHAN_FREQ = 2;
    private static final int N_DEV_CHANS = 3;
    private static final int LOG_PERIOD = 1;
    private static final Map<String, DriverConstants.ConnType> cTypeMap = new HashMap<String, DriverConstants.ConnType>();
    private String connType;
    private String devcId;
    private static final Logger LOG;
    private DriverConstants.ConnType connTypeE;
    private final WattsUp wtu = new WattsUp();
    private final double[] value = new double[3];

    protected void initDevice() {
        if (this.connType == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"connType", (String)"is missing");
        }
        this.connTypeE = cTypeMap.get(this.connType.toUpperCase());
        if (this.connTypeE == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"connType", (String)("is invalid: " + this.connType));
        }
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.wtu.addListener((WattsUp.Listener)this);
        this.fullName = "WattsUp meter (" + this.devcId + ")";
    }

    protected void initialize() {
        try {
            this.wtu.open(this.connTypeE, this.devcId);
            this.wtu.restart();
            this.initSensors();
            this.setOnline(true);
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        return this.online ? this.value[chan] : super.readChannel(chan, type);
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(65539);
                this.wtu.setExternalLogging(1);
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error configuring {0}: {1}", new Object[]{this.fullName, e});
            }
        } else {
            for (int j = 0; j < 3; ++j) {
                this.value[j] = 0.0;
            }
        }
    }

    public void setClosed() {
        this.setOnline(false);
    }

    public void processData(double[] data) {
        this.value[0] = data[0];
        this.value[1] = data[1];
        this.value[2] = data[16];
    }

    static {
        cTypeMap.put("SERIAL", DriverConstants.ConnType.SERIAL);
        cTypeMap.put("FTDI", DriverConstants.ConnType.FTDI);
        LOG = Logger.getLogger(MpmMain.class.getName());
    }
}

