/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.channel.Decompress18BitChannel;
import org.lsst.ccs.daq.ims.channel.DemultiplexingIntChannel;
import org.lsst.ccs.daq.ims.channel.FitsAsyncWriteChannel;
import org.lsst.ccs.daq.ims.channel.ReadoutConfig;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;
import org.lsst.ccs.daq.ims.channel.XORWritableIntChannel;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.readout.GeometryFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.readout.PropertiesFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.readout.ReadOutImageSet;
import org.lsst.ccs.utilities.readout.ReadOutParameters;
import org.lsst.ccs.utilities.readout.ReadOutParametersBuilder;
import org.lsst.ccs.utilities.readout.ReadOutParametersNew;

public class FitsIntWriter
implements WritableIntChannel {
    private static final DateTimeFormatter DATE_FORMAT;
    private final Decompress18BitChannel decompress;
    private final FitsFileWriter[] writers;

    public FitsIntWriter(Source source, Reb reb, Map<String, HeaderSpecification> headerSpecifications, FileNamer fileNamer, PerCCDMetaDataProvider extraMetaDataProvider) throws DAQException, IOException, FitsException {
        int ccdCount = source.getSourceType().getCCDCount();
        SourceMetaData smd = source.getMetaData();
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            ImageName in = new ImageName(source.getImage().getMetaData().getName());
            props.put("ImageName", in.toString());
            props.put("ImageDate", in.getDateString());
            props.put("ImageNumber", in.getNumberString());
            props.put("ImageController", in.getController().getCode());
            props.put("ImageSource", in.getSource().getCode());
        }
        catch (IllegalArgumentException x) {
            props.put("ImageName", source.getImage().getMetaData().getName());
            props.put("ImageDate", DATE_FORMAT.format(source.getImage().getMetaData().getTimestamp()));
        }
        props.put("FileCreationTime", new Date());
        props.put("DAQTriggerTime", source.getImage().getMetaData().getTimestamp());
        props.put("Tag", String.format("%x", source.getImage().getMetaData().getId()));
        props.put("RaftBay", source.getLocation().getRaftName());
        props.put("RebSlot", source.getLocation().getBoardName());
        props.put("Firmware", String.format("%x", smd.getFirmware()));
        props.put("Platform", smd.getPlatform());
        props.put("CCDControllerSerial", String.format("%x", smd.getSerialNumber() & 0xFFFFFFFFL));
        props.put("DAQVersion", smd.getSoftware().toString());
        props.put("DAQPartition", source.getImage().getStore().getPartition());
        props.put("DAQFolder", source.getImage().getMetaData().getCreationFolderName());
        props.put("DAQAnnotation", source.getImage().getMetaData().getAnnotation());
        PropertiesFitsHeaderMetadataProvider propsFitsHeaderMetadataProvider = new PropertiesFitsHeaderMetadataProvider(props);
        int[] registerValues = smd.getRegisterValues();
        ReadOutParametersBuilder builder = ReadOutParametersBuilder.create();
        builder.readoutParameterValues(registerValues);
        builder.readoutParameterNames(ReadOutParametersNew.DEFAULT_NAMES);
        ReadOutParameters readoutParameters = builder.build();
        if (source.getSourceType() == Location.LocationType.SCIENCE) {
            reb.setCCDType(readoutParameters.getCCDType());
        }
        File[] files = new File[source.getSourceType() == Location.LocationType.WAVEFRONT ? 2 : ccdCount];
        this.writers = new FitsFileWriter[files.length];
        ReadoutConfig readoutConfig = new ReadoutConfig(source.getSourceType());
        WritableIntChannel[] fileChannels = new WritableIntChannel[ccdCount * 16];
        try {
            for (int i = 0; i < files.length; ++i) {
                int sensorIndex = readoutConfig.getDataSensorMap()[i];
                props.put("CCDSlot", source.getLocation().getSensorName(sensorIndex));
                files[i] = fileNamer.computeFileName(props);
                CCD ccd = (CCD)reb.getCCDs().get(sensorIndex);
                if (!ccd.getName().equals(props.get("CCDSlot"))) {
                    throw new IOException(String.format("Geometry (%s) inconsistent with DAQ location (%s)", ccd.getName(), props.get("CCDSlot")));
                }
                ReadOutImageSet imageSet = new ReadOutImageSet(ccd, readoutParameters);
                ArrayList<Object> providers = new ArrayList<Object>();
                providers.add(new GeometryFitsHeaderMetadataProvider(ccd));
                providers.add(propsFitsHeaderMetadataProvider);
                if (extraMetaDataProvider != null) {
                    providers.addAll(extraMetaDataProvider.getMetaDataProvider(ccd));
                }
                this.writers[i] = new FitsFileWriter(files[i], (ImageSet)imageSet, headerSpecifications, providers);
                for (int j = 0; j < imageSet.getNumberOfImages(); ++j) {
                    fileChannels[i * imageSet.getNumberOfImages() + j] = new FitsAsyncWriteChannel(this.writers[i], readoutConfig.getDataSegmentMap()[j]);
                }
            }
            DemultiplexingIntChannel demultiplex = new DemultiplexingIntChannel(fileChannels);
            XORWritableIntChannel xor = new XORWritableIntChannel(demultiplex, readoutConfig.getXor());
            this.decompress = new Decompress18BitChannel(xor);
        }
        catch (Throwable t) {
            for (FitsFileWriter writer : this.writers) {
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw t;
        }
    }

    @Override
    public void write(int i) throws IOException {
        this.decompress.write(i);
    }

    @Override
    public void write(IntBuffer buffer) throws IOException {
        this.decompress.write(buffer);
    }

    @Override
    public boolean isOpen() {
        return this.decompress.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.decompress.close();
        for (FitsFileWriter writer : this.writers) {
            if (writer == null) continue;
            writer.close();
        }
    }

    static {
        FitsFactory.setUseHierarch(true);
        DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    }

    public static interface PerCCDMetaDataProvider {
        public List<FitsHeaderMetadataProvider> getMetaDataProvider(CCD var1);
    }

    public static interface FileNamer {
        public File computeFileName(Map<String, Object> var1);
    }
}

