/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.time.Duration;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.Transport;

public class NetTransport
implements Transport {
    private final Ascii port;

    public NetTransport(String hostname, int portNo) throws DriverException {
        Ascii newPort = null;
        try {
            newPort = new Ascii();
            newPort.open(DriverConstants.ConnType.NET, hostname, portNo);
            newPort.setTerminator(MODBUS_FRAME_TERMINATOR);
            this.port = newPort;
        }
        catch (Exception exc) {
            if (newPort != null) {
                newPort.closeSilent();
            }
            throw exc;
        }
    }

    @Override
    public void send(String command) throws DriverException {
        this.port.write(command);
    }

    @Override
    public String receive(Duration timeout) throws DriverException {
        this.port.setTimeout(timeout.getSeconds());
        return this.port.read();
    }

    @Override
    public void close() {
        this.port.closeSilent();
    }
}

