/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.AbortableCountDownLatch;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageDatabase
implements AutoCloseable {
    private static final int MAX_RETRIES = 1;
    private final String dbURL;
    private Connection conn;
    private PreparedStatement stmt1;
    private static final Logger LOG = Logger.getLogger(ImageDatabase.class.getName());
    final ImageDAO dao;

    ImageDatabase(String dbURL) {
        this.dbURL = dbURL;
        this.dao = new ImageDAO();
    }

    void ingest(ImageName currentImage, FileList fitsFiles, AbortableCountDownLatch fitsFileCountDown) {
        this.dao.setCurrentImage(currentImage);
        Runnable runnable = () -> {
            try {
                fitsFileCountDown.await();
                this.dao.fileLocation = fitsFiles.getCommonParentDirectory().toString();
                this.insertImage();
            }
            catch (InterruptedException | SQLException ex) {
                LOG.log(Level.INFO, "Did not commit to database due to error", ex);
                this.dao.clear();
            }
        };
        Thread t = new Thread(runnable, "Database Ingest Thread");
        t.start();
    }

    void addLocations(LocationSet locations) {
        this.dao.addLocations(locations);
    }

    void setMetaData(ImageMetaData imageMetaData) {
        this.dao.setMetaData(imageMetaData);
    }

    void addMetaData(Map<String, Serializable> headersMap) {
        this.dao.addMetaData(headersMap);
    }

    static int raftsMaskFromLocations(LocationSet locations) {
        int raftMask = 0;
        for (Location location : locations) {
            raftMask |= 1 << location.index() / 4;
        }
        return raftMask;
    }

    private void openConnection() throws SQLException {
        this.conn = DriverManager.getConnection(this.dbURL);
        this.conn.setAutoCommit(false);
        this.conn.setTransactionIsolation(8);
        try (PreparedStatement stmt = this.conn.prepareStatement("create table if not exists ccs_image (telCode varchar(2) not null, seqnum integer not null, dayobs varchar(8) not null, controller varchar(2) not null, darkTime float, exposureTime float, fileLocation varchar(255), imageTag bigint, imgType varchar(20), obsDate timestamp, raftMask integer, runNumber varchar(20), testType varchar(20), tseqnum integer, tstand varchar(20), primary key (telCode, seqnum, dayobs, controller))");){
            stmt.execute();
        }
        this.stmt1 = this.conn.prepareStatement("insert into ccs_image (telcode, seqnum, dayobs, controller, darkTime, exposureTime, fileLocation,imageTag, imgType, obsDate, raftMask, runNumber, testType, tseqnum, tstand) values (?, ?, ?, ?, ?,        ?, ?, ?, ?, ?,         ?, ?, ?, ?, ?) ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertImage() throws SQLException {
        try {
            int i = 0;
            while (true) {
                if (this.conn == null || this.conn.isClosed()) {
                    this.openConnection();
                }
                try {
                    this.stmt1.setString(1, this.dao.imageName.getSource().getCode());
                    this.stmt1.setInt(2, this.dao.imageName.getNumber());
                    this.stmt1.setString(3, this.dao.imageName.getDateString());
                    this.stmt1.setString(4, this.dao.imageName.getController().getCode());
                    this.stmt1.setObject(5, this.dao.darkTime);
                    this.stmt1.setObject(6, this.dao.exposureTime);
                    this.stmt1.setString(7, this.dao.fileLocation);
                    this.stmt1.setObject(8, this.dao.imageTag);
                    this.stmt1.setString(9, this.dao.imageType);
                    this.stmt1.setObject(10, this.dao.obsDate != null ? Timestamp.from(this.dao.obsDate) : null);
                    this.stmt1.setInt(11, ImageDatabase.raftsMaskFromLocations(this.dao.locations));
                    this.stmt1.setString(12, this.dao.runNumber);
                    this.stmt1.setString(13, this.dao.testType);
                    this.stmt1.setObject(14, this.dao.tSeqNum);
                    this.stmt1.setString(15, "BOT");
                    this.stmt1.executeUpdate();
                    this.conn.commit();
                }
                catch (SQLException x) {
                    if (i < 1) {
                        LOG.log(Level.WARNING, "Database update failed", x);
                        try {
                            this.close();
                        }
                        catch (SQLException sQLException) {}
                    } else {
                        throw x;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        finally {
            this.dao.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    private static class ImageDAO {
        private ImageName imageName;
        private String imageType;
        private String testType;
        private String runNumber;
        private Integer tSeqNum;
        private final String testStand = "BOT";
        private String fileLocation;
        private Instant obsDate;
        private final LocationSet locations = new LocationSet();
        private Float exposureTime;
        private Float darkTime;
        private Long imageTag;

        private ImageDAO() {
        }

        void addMetaData(Map<String, Serializable> metaData) {
            metaData.forEach((name, value) -> {
                switch (name) {
                    case "DarkTime": {
                        this.darkTime = this.toFloat(value);
                        break;
                    }
                    case "ExposureTime": {
                        this.exposureTime = this.toFloat(value);
                        break;
                    }
                    case "TestSeqNum": {
                        this.tSeqNum = this.toInt(value);
                        break;
                    }
                    case "TestType": {
                        this.testType = this.toString(value);
                        break;
                    }
                    case "ImageType": {
                        this.imageType = this.toString(value);
                        break;
                    }
                    case "RunNumber": {
                        this.runNumber = this.toString(value);
                    }
                }
            });
        }

        private Float toFloat(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }

        private Integer toInt(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }

        private String toString(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        private Date toDate(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value instanceof Instant) {
                return Date.from((Instant)value);
            }
            throw new RuntimeException("Cannot convert " + value + " to date");
        }

        private void setMetaData(ImageMetaData imageMetaData) {
            this.obsDate = imageMetaData.getTimestamp();
            this.imageTag = imageMetaData.getId();
        }

        private void addLocations(LocationSet locations) {
            this.locations.addAll((Collection)locations);
        }

        private void setCurrentImage(ImageName currentImage) {
            this.imageName = currentImage;
        }

        private void clear() {
            this.imageName = null;
            this.locations.clear();
            this.imageType = null;
            this.testType = null;
            this.runNumber = null;
            this.tSeqNum = null;
            this.fileLocation = null;
            this.obsDate = null;
            this.exposureTime = null;
            this.darkTime = null;
            this.imageTag = null;
        }
    }
}

