/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class WeightedAverageChannel
extends DerivedChannel {
    private Channel[] channels;
    private double[] weights;
    private final Map<String, Integer> nameMap = new LinkedHashMap<String, Integer>();

    public void init() {
        if (this.channels == null) {
            throw new RuntimeException(this.getPath() + " parameter error: channels array has not been defined");
        }
        if (this.weights == null) {
            this.weights = new double[this.channels.length];
            Arrays.fill(this.weights, 1.0);
        } else if (this.weights.length != this.channels.length) {
            throw new RuntimeException(this.getPath() + " parameter error : channels and weights arrays have different sizes");
        }
        for (int ix = 0; ix < this.channels.length; ++ix) {
            this.nameMap.put(this.channels[ix].getPath(), ix);
        }
        super.init();
    }

    public double evaluateDerivedValue() {
        double valueSum = 0.0;
        double weightSum = 0.0;
        for (int ix = 0; ix < this.channels.length; ++ix) {
            double value = this.channels[ix].getValue();
            if (Double.isNaN(value)) continue;
            valueSum += this.weights[ix] * value;
            weightSum += this.weights[ix];
        }
        return weightSum != 0.0 ? valueSum / weightSum : Double.NaN;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the channel weights", level=0)
    public Map<String, Double> getChannelWeights() {
        LinkedHashMap<String, Double> weightMap = new LinkedHashMap<String, Double>();
        for (int ix = 0; ix < this.channels.length; ++ix) {
            weightMap.put(this.channels[ix].getPath(), this.weights[ix]);
        }
        return weightMap;
    }

    @Command(type=Command.CommandType.ACTION, description="Set a channel weight")
    public void setChannelWeight(@Argument(description="Channel name") String name, @Argument(description="Channel weight") double weight) throws UtilityException {
        Integer ix = this.nameMap.get(name);
        if (ix == null) {
            throw new UtilityException("Invalid channel name: " + name);
        }
        this.weights[ix.intValue()] = weight;
    }
}

