import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.mcm.MCM_IR2;
import org.lsst.ccs.subsystem.mcm.MinionIR2;
import org.lsst.ccs.subsystem.mcm.MinionIR2Group;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.AlertHandler;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.AlertAction;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.EmailAlertAction;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.EmailAlertDeliveryStrategy;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.CommandAlertAction;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher;
import org.lsst.ccs.subsystem.mcm.AlertNotification;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.bus.states.AlertState;
import java.util.function.Predicate;
import java.time.Duration;
import org.lsst.ccs.subsystem.mcm.ir2.actions.RebTemperatureTooHighAction
import org.lsst.ccs.subsystem.mcm.ir2.actions.FocalPlaneRebTemperatureTooHighAction
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

CCSBuilder builder = ["comcam-mcm"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def isSimulated = props.getProperty("org.lsst.ccs.run.mode", "normal").equals("simulation")


def fromEmail = isSimulated ? "SIMULATED-ccs-alarm@lsst-mcm.slac.stanford.edu" : "comcam@lsst.org"
def replyToEmail = isSimulated ? "SIMULATED-lsstcam-opsprob@slac.stanford.edu" : "BStalder@lsst.org";

def infrastructureList = ["turri@slac.stanford.edu", "homer@slac.stanford.edu"];
def comcamList = isSimulated ? infrastructureList : ["turri@slac.stanford.edu","homer@SLAC.Stanford.EDU","gmorris@slac.stanford.edu","tonyj@slac.stanford.edu","margaux@SLAC.Stanford.EDU","reil@SLAC.Stanford.EDU","BStalder@lsst.org","MReuter@lsst.org"];



builder.
    main(MCM_IR2, 
        minions:[(MinionIR2Group.INFRASTRUCTURE):["localdb":MinionIR2.LOCALBD, "rest-server":MinionIR2.REST_SERVER, "comcam-mcm":MinionIR2.MCM, "cluster-monitor":MinionIR2.CLUSTER_MONITOR],
                 (MinionIR2Group.COMCAM) :["comcam-vacuum":MinionIR2.VACUUM, "comcam-fp":MinionIR2.FOCAL_PLANE, "comcam-rebps":MinionIR2.POWER]
                ] ) {

    infrastructure (AlertDispatcher, group: MinionIR2Group.INFRASTRUCTURE) {
        infrastructureEmailNotification (AlertHandler, handlerName: "infrastructureEmailNotification") {
            infrastructurePublicMailAction (EmailAlertAction, emailList: infrastructureList, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail", smtpHost:"mail.lsst.org") {
                localDbEmailStrategy (EmailAlertDeliveryStrategy, sendFirstEmail: false, origin:"localdb", maxAccumulation: Duration.ofMinutes(30))
                defaultEmailStrategy (EmailAlertDeliveryStrategy, sendFirstEmail: true, origin:".*", maxAccumulation: Duration.ofMinutes(0))
            }
        }        
    }
    

    comcam (AlertDispatcher, group: MinionIR2Group.COMCAM) {
        comcamEmailNotification (AlertHandler, handlerName: "comcamEmailNotification") {
             comcamPublicMailAction (EmailAlertAction, emailList: comcamList, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail", smtpHost:"mail.lsst.org")
        }        
        comcamRebTemperatureTooHighHandler (AlertHandler, handlerName: "comcamRebTemperatureTooHighHandler") {
            comcamRebTemperatureTooHighAction (FocalPlaneRebTemperatureTooHighAction)
        }        
    }
}
