/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.airwatch.main.Alerts;
import org.lsst.ccs.subsystem.airwatch.main.EmailSender;
import org.lsst.ccs.subsystem.airwatch.main.Instrument;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentReport;
import org.lsst.ccs.subsystem.airwatch.main.LocalConfigService;
import org.lsst.ccs.subsystem.airwatch.main.LocationConfig;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public final class AirwatchMain
implements ClearAlertHandler,
HardwareController,
HasLifecycle,
SignalHandler {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private volatile LocalConfigService config = null;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile AlertService alertService = null;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    private Map<String, LocationConfig> locations = null;
    private final CopyOnWriteArrayList<Instrument> instruments = new CopyOnWriteArrayList();
    private final Lock readoutLock;
    private PeriodicTask readoutTask = null;
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.airwatch");
    private EmailSender mailSender;

    @Command(type=Command.CommandType.QUERY, description="Displays a short report on instrument status.")
    public String instruments() {
        return new InstrumentReport(this.instruments).toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Prevents further readout of an instrument")
    public String disable(@Argument(description="Instrument index number or location.") String ident) throws Exception {
        return this.callIfNotBusy(() -> {
            List<Instrument> insList = this.findInstruments(ident);
            if (insList.size() != 1) {
                throw new IllegalArgumentException("There are " + insList.size() + " instruments at " + ident);
            }
            Instrument ins = insList.get(0);
            this.instruments.set(ins.getIndex(), ins.disable());
            return "OK";
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Sets new location for and enables instrument.")
    public String enable(@Argument(description="Instrument index number or current location.") String ident, @Argument(description="New location.") String newLocation) throws Exception {
        return this.callIfNotBusy(() -> {
            List<Instrument> insList = this.findInstruments(ident);
            if (insList.size() != 1) {
                throw new IllegalArgumentException("There are " + insList.size() + " instruments at " + ident);
            }
            String loc = null;
            if (this.locations.containsKey(newLocation)) {
                loc = newLocation;
            } else if (this.locations.containsKey(newLocation.toLowerCase())) {
                loc = newLocation.toLowerCase();
            }
            if (loc == null) {
                throw new IllegalArgumentException("Unknown location " + newLocation);
            }
            Instrument ins = insList.get(0);
            Instrument newIns = ins.enable(this.locations.get(loc));
            this.instruments.set(ins.getIndex(), newIns);
            if (newIns.getLastException().isPresent()) {
                throw newIns.getLastException().get();
            }
            return "OK";
        });
    }

    public TreeWalkerDiag signal(Signal sig) {
        if (sig.getLevel() == SignalLevel.STOP) {
            this.readoutTask.cancel(false);
        } else if (sig.getLevel() == SignalLevel.HALT) {
            this.readoutTask.cancel(true);
        }
        return TreeWalkerDiag.GO;
    }

    public AirwatchMain() {
        this.readoutLock = new ReentrantLock();
    }

    public void init() {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.config == null) {
            missing.add("LocalConfigService component");
        }
        if (this.alertService == null) {
            missing.add("CCS alert service");
        }
        if (!missing.isEmpty()) {
            throw new RuntimeException("Can't find " + String.join((CharSequence)", ", missing));
        }
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        this.config.makeConfigurationObjects();
        this.readConfiguration();
        this.enableAllInstruments();
        this.scheduleFirstReadout(Duration.ZERO);
        return TreeWalkerDiag.GO;
    }

    public void start() {
        this.mailSender = new EmailSender(this.config, this.alertService);
    }

    private void readConfiguration() {
        this.locations = Collections.unmodifiableMap(this.config.getLocationConfigs().stream().collect(Collectors.toMap(loc -> loc.name.toLowerCase(), Function.identity())));
        List<InstrumentConfig> configs = this.config.getInstrumentConfigs();
        List insts = configs.stream().map(cfg -> cfg.type.make((InstrumentConfig)cfg)).collect(Collectors.toList());
        this.instruments.addAll(insts);
    }

    private void enableAllInstruments() throws HardwareException {
        ArrayList exceptions = new ArrayList();
        this.instruments.forEach(inst -> {
            LocationConfig loc = this.locations.get(inst.getStatus().location.toLowerCase());
            Instrument newIns = inst.enable(loc);
            this.instruments.set(inst.getIndex(), newIns);
            newIns.getLastException().ifPresent(exc -> exceptions.add(exc));
        });
        if (exceptions.size() > 0) {
            HardwareException top = (HardwareException)exceptions.remove(0);
            for (HardwareException exc : exceptions) {
                top = new HardwareException(exc);
            }
            throw top;
        }
    }

    private void scheduleFirstReadout(Duration initialDelay) {
        this.readoutTask = this.subsys.getScheduler().scheduleAtFixedRate(this::readoutTaskBody, initialDelay.getSeconds(), this.config.getReadoutInterval().getSeconds(), TimeUnit.SECONDS);
    }

    private void readoutTaskBody() {
        try {
            this.readoutLock.lockInterruptibly();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            this.instruments.stream().filter(ins -> ins.getStatus().enabled).forEach(ins -> {
                if (Thread.currentThread().isInterrupted()) {
                    throw new TerminationException();
                }
                this.readAndUpdate((Instrument)ins);
            });
        }
        catch (TerminationException exc) {
            this.log.warning((Object)"Instrument readout was interrupted!");
        }
        finally {
            this.readoutLock.unlock();
        }
    }

    private void readAndUpdate(Instrument ins) {
        Instrument newIns = ins.read();
        this.instruments.set(ins.getIndex(), newIns);
        this.checkForExceptionDuringReadout(newIns);
        newIns.getTrendables().forEach(msg -> msg.post(this.subsys));
        this.config.updateInstrument(newIns.getStatus());
    }

    private boolean checkForExceptionDuringReadout(Instrument newIns) {
        newIns.getLastException().ifPresent(exc -> {
            String badloc = newIns.getStatus().location;
            String cause = badloc + ": " + exc.getMessage();
            this.alertService.raiseAlert(Alerts.instrumentIOAlert(badloc), AlertState.WARNING, cause);
            this.mailSender.send(cause, (Throwable)exc);
        });
        return newIns.getLastException().isPresent();
    }

    public void postStart() {
    }

    public void checkStopped() throws HardwareException {
        this.readoutTask.cancel(false);
        if (!this.readoutTask.isCancelled()) {
            throw new HardwareException(false, "Could not cancel the readout task.");
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
    }

    private List<Instrument> findInstruments(String ident) {
        List<Instrument> ins = new ArrayList<Instrument>();
        try {
            int i2 = Integer.parseInt(ident);
            ins.add(this.instruments.get(i2));
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        if (ins.isEmpty()) {
            ins = this.instruments.stream().filter(i -> i.getStatus().location.equalsIgnoreCase(ident)).collect(Collectors.toList());
        }
        return ins;
    }

    private String callIfNotBusy(Callable<String> cmd) throws Exception {
        if (!this.readoutLock.tryLock()) {
            return "BUSY";
        }
        try {
            String string = cmd.call();
            return string;
        }
        finally {
            this.readoutLock.unlock();
        }
    }

    private static class TerminationException
    extends RuntimeException {
        private TerminationException() {
        }
    }
}

