/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.doorman.main;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.lsst.ccs.subsystem.doorman.main.ChilledDoor;
import org.lsst.ccs.subsystem.doorman.main.DummyInstrument;
import org.lsst.ccs.subsystem.doorman.main.Instrument;
import org.lsst.ccs.subsystem.doorman.main.InstrumentConfig;

public enum InstrumentType {
    CHILLED_DOOR("chilledDoor", ChilledDoor::new),
    DUMMY("dummy", DummyInstrument::new);

    private final String configName;
    private final Function<InstrumentConfig, Instrument> maker;

    private InstrumentType(String configName, Function<InstrumentConfig, Instrument> maker) {
        this.configName = configName;
        this.maker = maker;
    }

    public String getConfigName() {
        return this.configName;
    }

    public Instrument make(InstrumentConfig config) {
        return this.maker.apply(config);
    }

    public static Optional<InstrumentType> parse(String name) {
        return Stream.of(InstrumentType.values()).filter(x -> name.equalsIgnoreCase(x.getConfigName())).findAny();
    }
}

