import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.utility.AuxTest
import org.lsst.ccs.subsystem.utility.FanControl
import org.lsst.ccs.subsystem.common.devices.Maq20Device
import org.lsst.ccs.subsystem.common.devices.Maq20PWMControl
import org.lsst.ccs.subsystem.common.devices.Maq20PulseControl
import org.lsst.ccs.subsystem.common.devices.PlutoDevice
import org.lsst.ccs.subsystem.common.devices.PlutoControl
import org.lsst.ccs.subsystem.utility.CpfeDevice
import org.lsst.ccs.subsystem.utility.CmsDevice
import org.lsst.ccs.subsystem.utility.WattsUpDevice
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Page

CCSBuilder builder = ["ccs-auxtest"]

builder.main (AuxTest) {

    FanCtrl   (FanControl, gain:0.5, timeConst:600.0, smoothTime:120.0, minOutput:1.2, maxOutput:8.8, awGain:4.0, baseDuty:0.0,
               tolerance:0.05, updateTime:20000, fans:["FanControl"], tempChans:["AirHexIn"])

    Lambda24 (CpfeDevice, connType:"serial", devcId:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_AK04OZZ3-if00-port0", address:0xa0)

    Lambda48 (CpfeDevice, connType:"serial", devcId:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_AK04OZZ3-if00-port0", address:0xa2)

    Maq20 (Maq20Device, node:"192.168.0.105",
           modules:["TTC:0098488-10","IS:0104377-12","VO:0105893-02","DIOL:0106270-02:pwm:pulse"] as String[]) {

       FanControl (Maq20PWMControl, type:"3:0", frequency:200.0)

       PulseControl (Maq20PulseControl, type:"3:1", pulsesPerRevn:6)
    }

    Pluto (PlutoDevice, node:"192.168.0.106", areas:[1, 7, 1, 8, 2, 1, 2, 2, 2, 3, 2, 4, 2, 5, 2, 6])

    Cms (CmsDevice, connType:"serial", devcId:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A105HJ5C-if00-port0")

    WattsUp (WattsUpDevice, connType:"serial", devcId:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_AD0201J9-if00-port0")

/*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1, pageId:0, 
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/

    RkTmpHigh (Channel, description:"rack temperature 15 high", units:"\u00b0C",
              devcName:"Maq20", hwChan:0, type:"0", subtype:"T220")

    RkTmpLow (Channel, description:"rack temperature 5 high", units:"\u00b0C",
              devcName:"Maq20", hwChan:1, type:"0", subtype:"T220")

    AirHexIn (Channel, description:"Hex air in temp", units:"\u00b0C",
              devcName:"Maq20", hwChan:2, type:"0", subtype:"T220")

    AirHexOut (Channel, description:"HEx air out temp", units:"\u00b0C",
              devcName:"Maq20", hwChan:3, type:"0", subtype:"T220")

   TmpWaterRet (Channel, description:"Water return temp.", units:"\u00b0C",
              devcName:"Maq20", hwChan:0, type:"1", subtype:"MA0_20", offset:-34.55, scale:4167)

    TmpWaterSup (Channel, description:"Water supply temp.", units:"\u00b0C",
              devcName:"Maq20", hwChan:1, type:"1", subtype:"MA0_20", offset:-34.55, scale:4167)

    VoutMaq0 (Channel, description:"Maq20 out voltage 0", units:"Volts",
              devcName:"Maq20", hwChan:0, type:"2", subtype:"VP10")

    DinMaq0  (Channel, description:"Maq20 discrete in 0", format:".0f",
              devcName:"Maq20", hwChan:0, type:"3")

    DoutMaq0 (Channel, description:"Maq20 discrete out 0", format:".0f",
              devcName:"Maq20", hwChan:0, type:"3", subtype:"out")

    FreqMaq  (Channel, description:"Maq20 pulse frequency", format:".0f",
              devcName:"Maq20", hwChan:Maq20Device.CHAN_FREQUENCY, type:"3", subtype:"1")

    RpmMaq   (Channel, description:"Maq20 pulse RPM", format:".0f",
              devcName:"Maq20", hwChan:Maq20Device.CHAN_PULSE_RPM, type:"3", subtype:"1")

    Temp24   (Channel, description:"Lambda24 temperature", units:"\u00b0C",
              devcName:"Lambda24", hwChan:CpfeDevice.CHAN_TEMPERATURE)

    Volts24  (Channel, description:"Lambda24 voltage", units:"Volts",
              devcName:"Lambda24", hwChan:CpfeDevice.CHAN_VOLTAGE)

    Curr24   (Channel, description:"Lambda24 current", units:"Amps",
              devcName:"Lambda24", hwChan:CpfeDevice.CHAN_CURRENT)

    Status24 (Channel, description:"Lambda24 status", format:".0f",
              devcName:"Lambda24", hwChan:CpfeDevice.CHAN_STATUS)

    Temp48   (Channel, description:"Lambda48 temperature", units:"\u00b0C",
              devcName:"Lambda48", hwChan:CpfeDevice.CHAN_TEMPERATURE)

    Volts48  (Channel, description:"Lambda48 voltage", units:"Volts",
              devcName:"Lambda48", hwChan:CpfeDevice.CHAN_VOLTAGE)

    Curr48   (Channel, description:"Lambda48 current", units:"Amps",
              devcName:"Lambda48", hwChan:CpfeDevice.CHAN_CURRENT)

    Status48 (Channel, description:"Lambda48 status", format:".0f",
              devcName:"Lambda48", hwChan:CpfeDevice.CHAN_STATUS)

    CurrCms1 (Channel, description:"CMS current 1", units:"Amps",
              devcName:"Cms", hwChan:1)

    CurrCms2 (Channel, description:"CMS current 2", units:"Amps",
              devcName:"Cms", hwChan:2)

    CurrCms5 (Channel, description:"CMS current 5", units:"Amps",
              devcName:"Cms", hwChan:5)

    WUPower  (Channel, description:"WattsUp power", units:"Watts",
              devcName:"WattsUp", hwChan:WattsUpDevice.CHAN_WATTS)

    WUVolts  (Channel, description:"WattsUp voltage", units:"Volts",
              devcName:"WattsUp", hwChan:WattsUpDevice.CHAN_VOLTS)

    Pluto1_24V  (Channel, description: "Pluto 1 24V supply", units: "Volts",
                 devcName: "Pluto", hwChan: 1, type: "ADDREG:1", scale: 0.1)

    ColdPltTmp (Channel, description: "Cold plate temperature", units:"\u00b0C",
                devcName: "Pluto", hwChan: 0, type: "ADDREG:0", scale: 0.01)

    Pluto2_24V  (Channel, description: "Pluto 2 24V supply", units: "Volts",
                 devcName: "Pluto", hwChan: 1, type: "ADDREG:3", scale: 0.1)

    CmprTemp   (Channel, description: "Compressor temperature", units:"\u00b0C",
                devcName: "Pluto", hwChan: 0, type: "ADDREG:2", scale: 0.01)

    SuctionTmp (Channel, description: "Suction line temperature", units:"\u00b0C",
                devcName: "Pluto", hwChan: 1, type: "ADDREG:4", scale: 0.01)

    PhsSepTmp  (Channel, description: "Phase separator temperature", units:"\u00b0C",
                devcName: "Pluto", hwChan: 0, type: "ADDREG:5", scale: 0.01)

    CmpDisPrs (Channel, description: "Discharge pressure", units: "Psia",
               devcName: "Pluto", hwChan: 1, type: "ADDREG:2", offset: 0.0, scale: 0.02)

    CmpSucPrs (Channel, description: "Suction pressure", units: "Psia",
               devcName: "Pluto", hwChan: 0, type: "ADDREG:3", offset: 0.0, scale: 0.02)

/*
    CmprLine1  (Line, devcName: "PlutoCmpr", chan: 16)

     "C1.CmpFlowLow" (Channel, description: "Water flow low latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 29, type: "GLOBAL:1", pageId: 1)

    "C1.CmpTempHi" (Channel, description: "Temperature high latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 24, type: "GLOBAL:1", pageId: 1)

    CurrCms1 (Channel, description:"CMS current 1", units:"Amps",
              devcName:"Cms", hwChan:1, type:"RMS")

    CurrCms2 (Channel, description:"CMS current 2", units:"Amps",
              devcName:"Cms", hwChan:2, type:"RMS")

    CurrCms5 (Channel, description:"CMS current 5", units:"Amps",
              devcName:"Cms", hwChan:5, type:"RMS")
*/
}
