import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.RefrigMain;
import org.lsst.ccs.subsystem.refrig.ColdCompressor;
import org.lsst.ccs.subsystem.refrig.CompSimPlutoDevice;
import org.lsst.ccs.subsystem.refrig.CompSimMaq20Device;
import org.lsst.ccs.subsystem.refrig.CryoCompressor;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.monitor.Channel;

taskConfig = ["monitor-update/taskPeriodMillis":1000, "monitor-publish/taskPeriodMillis":10000]
numCold = 2
coldNames = ["Cold1", "Cold2"]
numCryo = 6
cryoNames = ["Cryo5", "Cryo6", "Cryo4", "Cryo3", "Cryo2", "Cryo1"]

CCSBuilder builder = ["refrig"]

builder.main (RefrigMain, nodeTags: taskConfig) {

    for (j = 0; j < numCold; j++) {

        "${coldNames[j]}" (ColdCompressor, discTempChan: "DischrgTmp_P", discPressChan: "DischrgPrs",
                           suctTempChan: "SuctionTmp_P", cmprPowerChan: "CompPower", liquidTempChan: "LiquidTmp_P") {

            Plc (CompSimPlutoDevice)

            Maq20 (CompSimMaq20Device)

            plc = "${coldNames[j]}/Plc"

            DischrgTmp_P (Channel, description: "Discharge Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:0")

            DischrgPrs   (Channel, description: "Discharge Pressure", units: "psia", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:3")

            SuctionTmp_P (Channel, description: "Suction Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:1")

            SuctionPrs   (Channel, description: "Suction Pressure", units: "psia", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:4")

            LiquidTmp_P  (Channel, description: "Liquid Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:2")

            CompVoltage  (Channel, description: "Compressor Voltage", units: "Volts", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:6")

            CompCurrent  (Channel, description: "Compressor Current", units: "Amps", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:5")

            CompPower    (Channel, description: "Compressor Power", units: "VA", format: ".1f",
                          devcName: "$plc", hwChan: 0, type: "ADDINT:9")

        }
    }

    for (j = 0; j < numCryo; j++) {

        comp = cryoNames[j]
        "${cryoNames[j]}" (CryoCompressor, discTempChan: "DischrgTmp_P", discPressChan: "DischrgPrs",
                           suctTempChan: "SuctionTmp_P", cmprPowerChan: "CompPower", phaseSepTempChan: "PhaseSepTmp") {

            Plc (CompSimPlutoDevice)

            Maq20 (CompSimMaq20Device)

            plc = "${cryoNames[j]}/Plc"
            maq20 = "${cryoNames[j]}/Maq20"

            DischrgTmp_P (Channel, description: "Discharge Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:0")

            DischrgTmp_M (Channel, description: "Discharge Temperature (MAQ20)", units: "\u00b0C", format: ".1f",
                          devcName: "$maq20", hwChan: 3, type: "0", subtype: "T220")

            DischrgPrs   (Channel, description: "Discharge Pressure", units: "psia", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:3")

            SuctionTmp_P (Channel, description: "Suction Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:1")

            SuctionTmp_M (Channel, description: "Suction Temperature (MAQ20)", units: "\u00b0C", format: ".1f",
                          devcName: "$maq20", hwChan: 2, type: "0", subtype: "T220")

            SuctionPrs   (Channel, description: "Suction Pressure", units: "psia", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:4")

            OilLevel     (Channel, description: "Oil Level", units: "mm", format: ".0f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:2")

            CompVoltage  (Channel, description: "Compressor Voltage", units: "Volts", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:6")

            CompCurrent  (Channel, description: "Compressor Current", units: "Amps", format: ".1f",
                          devcName: "$plc", hwChan: 1, type: "ADDREG:5")

            CompPower    (Channel, description: "Compressor Power", units: "VA", format: ".1f",
                          devcName: "$plc", hwChan: 0, type: "ADDINT:9")

            WaterInTmp   (Channel, description: "Water Inlet Temperature", units: "\u00b0C", format: ".1f",
                          devcName: "$maq20", hwChan: 0, type: "0", subtype: "T220")

            WaterOutTmp  (Channel, description: "Water Outlet Temperature", units: "\u00b0C", format: ".1f",
                          devcName: "$maq20", hwChan: 4, type: "0", subtype: "T220")

            AfterCoolTmp (Channel, description: "After Cooler Temperature", units: "\u00b0C", format: ".1f",
                          devcName: "$maq20", hwChan: 1, type: "0", subtype: "T220")

            PhaseSepTmp  (Channel, description: "Phase Separator Temperature", units: "\u00b0C", format: ".1f",
                          devcName: "$maq20", hwChan: 5, type: "0", subtype: "T220")

            OilSepTmp    (Channel, description: "Oil Separator Temperature", units: "\u00b0C", format: ".1f",
                          devcName: "$maq20", hwChan: 6, type: "0", subtype: "T220")

            SurgeTankTmp (Channel, description: "Surge Tank Temperature", units: "\u00b0C", format: ".1f",
                          devcName: "$maq20", hwChan: 7, type: "0", subtype: "T220")

            if (j % 3 == 0) {
                CabinetTmp (Channel, description: "Cabinet Temperature", units: "\u00b0C", format: ".1f",
                            devcName: "$maq20", hwChan: 1, type: "1", subtype: "T220")

                AmbientTmp (Channel, description: "Ambient Temperature", units: "\u00b0C", format: ".1f",
                            devcName: "$maq20", hwChan: 0, type: "1", subtype: "T220")
            }

        }

    }

}
