import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.RefrigMain;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.SimDevice;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["ccs-refrig-cold"]

builder.main (RefrigMain, tickMillis: 5000, monMillis: 1000, checkMillis: 0,
              cmprPowerLines: [["CmprLine"]] as List[],
              loadPowerDevc: "Power",
              alarmDsabChans: ["CryoCtrTmp"] as String[],
              loadTempChans: ["CryoCtrTmp"] as String[],
              tempCtrl: "TempCtrl") {

    TempCtrl   (TempControl, gain: 1, timeConst: 10, smoothTime: 60,
                maxOutput: 500, awGain: 4, basePower: 0, tolerance: 0.1,
                updateTime: 10000)

    Sim        (SimDevice, loadTmpChan: "CryoCtrTmp", loadPwrChan: "LoadPower", loadAlwaysOn: true)

    Power      (SimDevice.Power)

    CmprLine   (Line, devcName: "Sim", chan: 0)

    LoadLine   (Line, devcName: "Sim", chan: 1)

    AlarmMain  (Alarm, description: "Trips off all power", eventParm: 0)
/*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1,
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/
    CmprPower  (Channel, description: "Compressor\\Power", units: "Watts",
                devcName: "Sim", hwChan: 5, type: "POWER", subtype: "1050: 0: 0: 0")

    CmpDisPrs  (Channel, description: "Discharge pressure", units: "Psig",
                devcName: "Sim", hwChan: 3, type: "VOLTS", subtype: "300: 30: 50: 30")

    CmpSucPrs  (Channel, description: "Suction pressure", units: "Psig",
                devcName: "Sim", hwChan: 4, type: "VOLTS", subtype: "10:30:50:30")

    CmpDisTmp  (Channel, description: "Discharge temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 0, type: "TEMP", subtype: "110:120:10:1200",
                checkHi: "alarm", alarmHi: "AlarmMain")

    CmpRetnTmp (Channel, description: "C1 oil temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 1, type: "TEMP", subtype: "-100:1800:25:7200")

    CmpSepTmp  (Channel, description: "Separator temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 2, type: "TEMP", subtype: "-100:1800:25:7200")

    CmprVolts  (Channel, description: "Line voltage", units: "Volts",
                devcName: "Sim", hwChan: 6, type: "POWER", subtype: "208:0:0:0")

    C3LiqdTmp  (Channel, description: "Heat Exchanger\\C3 liq capillary temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 12, type: "TEMP", subtype: "-120:1800:25:7200")

    PreC4Tmp   (Channel, description: "Pre C4 temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 13, type: "TEMP", subtype: "-120:1800:25:7200")

    PostC4Tmp  (Channel, description: "Post C4 temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 14, type: "TEMP", subtype: "-100:1800:25:7200")

    HexVapPrs  (Channel, description: "Vapor supply pressure", units: "Psig",
                devcName: "Sim", hwChan: 23, type: "VOLTS", subtype: "300:30:50:30")

    HexLiqPrs  (Channel, description: "Liquid supply pressure", units: "Psig",
                devcName: "Sim", hwChan: 22, type: "VOLTS", subtype: "300:30:50:30")

    HexPrsDiff (Channel, description: "Vapor/liquid delta P", units: "Psi",
                devcName: null, type: "DIFF", subtype: "HexLiqPrs:HexVapPrs")

    HexSucPrs  (Channel, description: "Return pressure", units: "Psig",
                devcName: "Sim", hwChan: 25, type: "VOLTS", subtype: "300:30:50:30")

    HexExitTmp (Channel, description: "Return temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 24, type: "TEMP", subtype: "-100:1800:25:7200")

    LoadTmp1   (Channel, description: "Cryostat\\Load temperature 1 RTD", units: "\u00b0C",
                devcName: "Sim", hwChan: 7, type: "TEMP", subtype: "-100:1800:25:7200")

    LoadTmp2   (Channel, description: "Load temperature 2 RTD", units: "\u00b0C",
                devcName: "Sim", hwChan: 8, type: "TEMP", subtype: "-100:1800:25:7200")

    LoadTmp3   (Channel, description: "Load temperature 3 RTD", units: "\u00b0C",
                devcName: "Sim", hwChan: 9, type: "TEMP", subtype: "-100:1800:25:7200")

    LoadTmp4   (Channel, description: "Load temperature 4 RTD", units: "\u00b0C",
                devcName: "Sim", hwChan: 10, type: "TEMP", subtype: "-100:1800:25:7200")

    LoadTmp5   (Channel, description: "Load temperature 5 RTD", units: "\u00b0C",
                devcName: "Sim", hwChan: 11, type: "TEMP", subtype: "-100:1800:25:7200")

    LoadPower  (Channel, description: "Heat load power", units: "Watts",
                devcName: "Power", hwChan: 0, type: "POWER", subtype: "")

    LoadVolts  (Channel, description: "Heat load voltage", units: "Volts",
                devcName: "Power", hwChan: 1, type: "POWER", subtype: "")

    CryoCtrTmp (Channel, description: "Cryoplate center temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 16, type: "TEMP", subtype: "-100:1800:25:7200",
                checkHi: "alarm", alarmHi: "AlarmMain")

    PostCryTmp (Channel, description: "Cryoplate exit temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 15, type: "TEMP", subtype: "-110:1800:25:7200")

    HexPostEvp (Channel, description: "HEX post evap temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 18, type: "TEMP", subtype: "-100:1800:25:7200")

    GridFceTmp (Channel, description: "Grid face temperature", units: "\u00b0C",
                devcName: "Sim", hwChan: 19, type: "TEMP", subtype: "-100:1800:25:7200")

    CryStrWTmp (Channel, description: "Mock grid strap warm end", units: "\u00b0C",
                devcName: "Sim", hwChan: 20, type: "TEMP", subtype: "-100:1800:25:7200")

    CryStrCTmp (Channel, description: "Mock grid strap cold end", units: "\u00b0C",
                devcName: "Sim", hwChan: 21, type: "TEMP", subtype: "-100:1800:25:7200")

    Running    (Channel, description: "Control Chassis\\Running state", format: ".0f",
                devcName: "Sim", hwChan: 26, type: "SWITCH", subtype: "1:0:0:0")

    Interlock  (Channel, description: "Interlock state", format: ".0f",
                devcName: "Sim", hwChan: 27, type: "SWITCH", subtype: "1:0:0:0")

    ThermRelay (Channel, description: "Thermal relay state", format: ".0f",
                devcName: "Sim", hwChan: 28, type: "SWITCH", subtype: "1:0:1:0")

    LoadEnable (Channel, description: "Load enable state", format: ".0f",
                devcName: "Sim", hwChan: 29, type: "SWITCH", subtype: "1:0:0:0")

    V5Power    (Channel, description: "5-Volt power state", format: ".0f",
                devcName: "Sim", hwChan: 30, type: "SWITCH", subtype: "1:0:1:0")
}
