import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.refrig.HexMain
import org.lsst.ccs.subsystem.common.devices.Maq20Device
import org.lsst.ccs.monitor.Channel

taskConfig = ["monitor-update/taskPeriodMillis":1000, "monitor-publish/taskPeriodMillis":10000]

CCSBuilder builder = ["hex"]

builder.main (HexMain, nodeTags: taskConfig) {

    Maq20 (Maq20Device, node: "192.168.1.128",
           modules: ["RTD:0121348-07",             // RFG-UTT-SCD-01
                     "RTD:0121348-06",             // RFG-UTT-SCD-00
                     "RTD:0121348-09",             // RFG-UTT-SCD-02
                     "RTD:0121348-08",             // RFG-UTT-SCD-03
                     "RTD:0122975-02",             // RFG-UTT-SCD-05
                     "RTD:0119418-08",             // RFG-UTT-SCD-04
                     "RTD:0121348-01",             // RFG-UTT-SCD-06
                     "IS:0104377-14",              // RFG-UTT-ISN-00
                     "IS:0104377-15"] as String[]) // RFG-UTT-ISN-01

    "Cold1/PreExpnTmp"  (Channel, description: "Pre Expn Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 0, type: "6", subtype: "R200")

    "Cold1/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 1, type: "6", subtype: "R200")

    "Cold1/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 2, type: "6", subtype: "R200")

    "Cold1/SupplyPrs"   (Channel, description: "Supply Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 2, type: "8", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Cold1/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 3, type: "8", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Cold2/PreExpnTmp"  (Channel, description: "Pre Expn Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 3, type: "6", subtype: "R200")

    "Cold2/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 4, type: "6", subtype: "R200")

    "Cold2/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 5, type: "6", subtype: "R200")

    "Cold2/SupplyPrs"   (Channel, description: "Supply Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 4, type: "8", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Cold2/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 5, type: "8", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Cryo5/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 0, type: "4", subtype: "R200")

    "Cryo5/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 1, type: "4", subtype: "R200")

    "Cryo5/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 2, type: "4", subtype: "R200")

    "Cryo5/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 3, type: "4", subtype: "R200")

    "Cryo5/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 4, type: "4", subtype: "R200")

    "Cryo5/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 5, type: "4", subtype: "R200")

    "Cryo5/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 12, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo5/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 13, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo5/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 14, type: "7", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Cryo6/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 0, type: "5", subtype: "R200")

    "Cryo6/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 1, type: "5", subtype: "R200")

    "Cryo6/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 2, type: "5", subtype: "R200")

    "Cryo6/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 3, type: "5", subtype: "R200")

    "Cryo6/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 4, type: "5", subtype: "R200")

    "Cryo6/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 5, type: "5", subtype: "R200")

    "Cryo6/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 15, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo6/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 0, type: "8", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo6/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 1, type: "8", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Cryo4/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 0, type: "3", subtype: "R200")

    "Cryo4/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 1, type: "3", subtype: "R200")

    "Cryo4/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 2, type: "3", subtype: "R200")

    "Cryo4/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 3, type: "3", subtype: "R200")

    "Cryo4/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 4, type: "3", subtype: "R200")

    "Cryo4/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 5, type: "3", subtype: "R200")

    "Cryo4/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 9, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo4/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 10, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo4/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 11, type: "7", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Cryo3/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 0, type: "2", subtype: "R200")

    "Cryo3/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 1, type: "2", subtype: "R200")

    "Cryo3/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 2, type: "2", subtype: "R200")

    "Cryo3/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 3, type: "2", subtype: "R200")

    "Cryo3/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 4, type: "2", subtype: "R200")

    "Cryo3/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 5, type: "2", subtype: "R200")

    "Cryo3/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 6, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo3/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 7, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo3/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 8, type: "7", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Cryo2/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 0, type: "1", subtype: "R200")

    "Cryo2/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 1, type: "1", subtype: "R200")

    "Cryo2/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 2, type: "1", subtype: "R200")

    "Cryo2/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 3, type: "1", subtype: "R200")

    "Cryo2/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 4, type: "1", subtype: "R200")

    "Cryo2/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 5, type: "1", subtype: "R200")

    "Cryo2/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 3, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo2/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 4, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo2/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 5, type: "7", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Cryo1/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 0, type: "0", subtype: "R200")

    "Cryo1/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 1, type: "0", subtype: "R200")

    "Cryo1/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 2, type: "0", subtype: "R200")

    "Cryo1/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 3, type: "0", subtype: "R200")

    "Cryo1/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 4, type: "0", subtype: "R200")

    "Cryo1/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "Maq20", hwChan: 5, type: "0", subtype: "R200")

    "Cryo1/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 0, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo1/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 1, type: "7", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "Cryo1/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "Maq20", hwChan: 2, type: "7", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

}
