/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;

public class FocalPlaneAlertHandler
implements Monitor.AlarmHandler {
    private static final Logger LOG = Logger.getLogger(FocalPlaneAlertHandler.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        if (parm == RaftAlert.ASPICS_TEMPERATURE_TOO_LOW.ordinal()) {
            switch (event) {
                case 0: {
                    LOG.severe("The REB Aspec temperature is below the low alarm limit");
                    break;
                }
                case 1: {
                    LOG.warning("The REB Aspec temperature was raised above the low warning limit");
                    break;
                }
                case 2: {
                    LOG.warning("The REB Aspec temperature has gone below the low warning limit");
                    break;
                }
                case 3: {
                    LOG.info("The REB Aspec temperature is back above the low warning limit");
                }
            }
            return false;
        }
        if (parm == RaftAlert.ASPICS_TEMPERATURE_TOO_HIGH.ordinal()) {
            AlertState state = AlertState.NOMINAL;
            switch (event) {
                case 0: {
                    LOG.severe("The REB Aspec temperature is above the high alarm limit");
                    state = AlertState.ALARM;
                    break;
                }
                case 1: {
                    LOG.warning("The REB Aspec temperature has gone below the high warning limit");
                    state = AlertState.WARNING;
                    break;
                }
                case 2: {
                    LOG.warning("The REB Aspec temperature has gone above the high warning limit");
                    state = AlertState.WARNING;
                    break;
                }
                case 3: {
                    LOG.info("The REB Aspec temperature is back below the high warning limit");
                    state = AlertState.NOMINAL;
                }
            }
            this.alertService.raiseAlert(RaftAlert.ASPICS_TEMPERATURE_TOO_HIGH.getAlert(), state, alarmName + ": " + cause);
            return true;
        }
        if (parm == RaftAlert.REB_BOARD_TEMPERATURE_TOO_LOW.ordinal()) {
            switch (event) {
                case 0: {
                    LOG.severe("The REB Board temperature is below the low alarm limit");
                    break;
                }
                case 1: {
                    LOG.warning("The REB Board temperature was raised above the low warning limit");
                    break;
                }
                case 2: {
                    LOG.warning("The REB Board temperature has gone below the low warning limit");
                    break;
                }
                case 3: {
                    LOG.info("The REB Board temperature is back above the low warning limit");
                }
            }
            return false;
        }
        if (parm == RaftAlert.REB_BOARD_TEMPERATURE_TOO_HIGH.ordinal()) {
            AlertState state = AlertState.NOMINAL;
            switch (event) {
                case 0: {
                    LOG.severe("The REB Board temperature is above the high alarm limit");
                    state = AlertState.ALARM;
                    break;
                }
                case 1: {
                    LOG.warning("The REB Board temperature has gone below the high warning limit");
                    state = AlertState.WARNING;
                    break;
                }
                case 2: {
                    LOG.warning("The REB Board temperature has gone above the high warning limit");
                    state = AlertState.WARNING;
                    break;
                }
                case 3: {
                    LOG.info("The REB Board temperature is back below the high warning limit");
                    state = AlertState.NOMINAL;
                }
            }
            this.alertService.raiseAlert(RaftAlert.REB_BOARD_TEMPERATURE_TOO_HIGH.getAlert(), state, alarmName + ": " + cause);
            return true;
        }
        return false;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        for (RaftAlert raftAlert : RaftAlert.values()) {
            if (!raftAlert.getAlertId().equals(alert.getAlertId())) continue;
            this.getAlarmById(raftAlert.ordinal()).clearState();
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }
}

