/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;

public class Port
extends NdrObject {
    public String portSpec;

    public Port() {
        this(null);
    }

    public Port(String portSpec) {
        this.portSpec = portSpec;
    }

    @Override
    public void read(NetworkDataRepresentation ndr) {
        int length = ndr.readUnsignedShort();
        if (length > 0) {
            NdrBuffer buf = ndr.getBuffer();
            char[] portSpec = new char[length - 1];
            ndr.readCharacterArray(portSpec, 0, portSpec.length);
            ndr.readUnsignedSmall();
            this.portSpec = new String(portSpec);
        } else {
            this.portSpec = null;
        }
    }

    @Override
    public void write(NetworkDataRepresentation ndr) {
        char[] spec;
        if (this.portSpec != null) {
            spec = new char[this.portSpec.length() + 1];
            this.portSpec.getChars(0, this.portSpec.length(), spec, 0);
        } else {
            spec = new char[]{};
        }
        ndr.writeUnsignedShort(spec.length);
        if (spec.length > 0) {
            ndr.writeCharacterArray(spec, 0, spec.length);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Port)) {
            return false;
        }
        return this.portSpec != null ? this.portSpec.equals(((Port)obj).portSpec) : ((Port)obj).portSpec == null;
    }
}

