/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.constants;

import org.lsst.ccs.bus.data.Alert;

public enum CompAlert {
    DISC_PRESS_HIGH("DiscPressHigh", "Discharge pressure high"),
    DISC_TEMP_HIGH("DiscTempHigh", "Discharge temperature high"),
    COMP_POWER_HIGH("CompPowerHigh", "Compressor power high"),
    SUCT_TEMP_LOW("SuctTempLow", "Suction temperature low"),
    OIL_LEVEL_LOW("OilLevelLow", "Oil level low"),
    PHASE_TEMP_HIGH("PhaseTempHigh", "Phase separator temperature high"),
    LIQD_TEMP_HIGH("LiqdTempHigh", "Liquid line temperature high"),
    CRYO_TEMP_LOW("CryoTempLow", "Cryo plate temperature low"),
    COLD_TEMP_LOW("ColdTempLow", "Cold plate temperature low"),
    DISC_PRESS_HIGH_PLC("DiscPressHighPLC", "Discharge pressure high (PLC)"),
    DISC_TEMP_HIGH_PLC("DiscTempHighPLC", "Discharge temperature high (PLC)"),
    COMP_POWER_HIGH_PLC("CompPowerHighPLC", "Compressor power high (PLC)"),
    SUCT_TEMP_LOW_PLC("SuctTempLowPLC", "Suction temperature low (PLC)"),
    OIL_LEVEL_LOW_PLC("OilLevelLowPLC", "Oil level low (PLC)"),
    LIQD_TEMP_HIGH_PLC("LiqdTempHighPLC", "Liquid line temperature high (PLC)"),
    AFTER_TEMP_HIGH_PLC("AfterTempHighPLC", "After cooler temperature high (PLC)"),
    SENS_READ_BAD_PLC("SensReadBadPLC", "Sensor reading bad (PLC)"),
    SMOKE_DETC_PLC("SmokeDetc_PLC", "Smoke detector (PLC)"),
    EXT_PERMIT_PLC("ExtPermitPLC", "External permit (PLC)");

    private final String id;
    private final String description;

    private CompAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId(String comp) {
        return comp + this.id;
    }

    public String getDescription(String comp) {
        return comp + " " + this.description;
    }

    public Alert newAlert(String comp) {
        return new Alert(this.getId(comp), this.getDescription(comp));
    }
}

