/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gantry;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.motorplatform.gantry.Axis;
import org.lsst.ccs.subsystem.motorplatform.gantry.ReadIO;

public class AnalogInput {
    private String description;
    private int order;
    private int channel;
    private volatile int globalOrder = -1;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private volatile Axis axis;
    @ConfigurationParameter(description="The voltage reading corresponding to an engineeering value of zero.")
    private volatile double voltageOrigin = 0.0;
    @ConfigurationParameter(description="The scale factor used to convert volts to engineering units.")
    private volatile double voltageScaleFactor = 1.0;

    public String getDescription() {
        return this.description;
    }

    public int getOrder() {
        return this.order;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getGlobalOrder() {
        return this.globalOrder;
    }

    public void setGlobalOrder(int globalOrder) {
        this.globalOrder = globalOrder;
    }

    public int getDescriptor() {
        return ReadIO.descriptor(this.getAxis().getIndex(), 2, this.getChannel(), 0);
    }

    public double getVoltageOrigin() {
        return this.voltageOrigin;
    }

    public double getVoltageScaleFactor() {
        return this.voltageScaleFactor;
    }

    public double voltsToEngineeringUnits(double volts) {
        return this.voltageScaleFactor * (volts - this.voltageOrigin);
    }

    public double engineeringUnitsToVolts(double engine) {
        return engine / this.voltageScaleFactor + this.voltageOrigin;
    }

    public double readValue(AerotechPro165 aero) throws DriverException {
        if (this.globalOrder < 0) {
            throw new IllegalArgumentException("Unset globalOrder.");
        }
        double volts = aero.readDoubleAP(String.format("DGLOBAL(%d)", 32 + this.globalOrder));
        return this.voltsToEngineeringUnits(volts);
    }
}

