/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.utils;

import java.util.logging.Logger;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Pong;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.services.AgentService;

public class InfluxDbClientService
implements AgentService,
ServiceLifecycle {
    private static final Logger LOG = Logger.getLogger(InfluxDbClientService.class.getName());
    @ConfigurationParameter(isFinal=true, category="InfluxDb")
    private String influxDbUrl;
    @ConfigurationParameter(isFinal=true, category="InfluxDb")
    private String influxDbName;
    @ConfigurationParameter(isFinal=true, category="InfluxDb")
    private String influxDbUsername;
    @ConfigurationParameter(isFinal=true, category="InfluxDb")
    private String influxDbPassword;
    private InfluxDB influxDb;

    public String getAgentServiceName() {
        return "influxDbClientService";
    }

    public boolean startForAgent(AgentInfo agentInfo) {
        if (BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.use.influxdb.service", "false").toLowerCase().equals("true")) {
            LOG.info("Starting InfluxDbClientService for agent " + agentInfo.getName());
            return true;
        }
        return false;
    }

    public void preStart() {
        if (this.influxDbUrl != null && !this.influxDbUrl.isEmpty()) {
            this.influxDb = InfluxDBFactory.connect((String)this.influxDbUrl, (String)this.influxDbUsername, (String)this.influxDbPassword);
            this.influxDb = this.influxDb.setDatabase(this.influxDbName);
            Pong p = this.influxDb.ping();
            if (p == null || !p.isGood()) {
                throw new RuntimeException("Could not connect with InfluxDb " + p);
            }
            this.influxDb = this.influxDb.enableBatch(BatchOptions.DEFAULTS.actions(2000).flushDuration(500).exceptionHandler((failedPoints, throwable) -> LOG.severe(throwable.toString())));
        }
    }

    public void preShutdown() {
        if (this.influxDb != null) {
            this.influxDb.close();
        }
    }

    public InfluxDB getInfluxDbClient() {
        return this.influxDb;
    }
}

