/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.influxdb.dto.Point;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.utils.InfluxDbClientService;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.cluster.monitor.Accumulate;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.python.netty.util.internal.ConcurrentSet;

public class BusTrafficMonitor
implements HasLifecycle {
    private static final Object counterLock = new Object();
    private static final Logger LOG = Logger.getLogger(BusTrafficMonitor.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    InfluxDbClientService influxDbClientService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    private static BlockingQueue<Runnable> statusQueue = null;
    private static BlockingQueue<Runnable> commandQueue = null;
    private static BlockingQueue<Runnable> logQueue = null;
    private Thread statusThread;
    private Thread commandThread;
    private Thread logThread;
    private static Map<Tags, Integer> agentCountersMap = new ConcurrentHashMap<Tags, Integer>();
    private static Map<Tags, Map<String, Accumulate>> tagsAccumMap = new ConcurrentHashMap<Tags, Map<String, Accumulate>>();

    public void build() {
        this.agentPropertiesService.setAgentProperty("org.lsst.ccs.use.full.paths", "true");
        AgentPeriodicTask resetCounterAndPublish = new AgentPeriodicTask("busTrafficStatsUpdate", () -> this.resetCounterAndPublish()).withPeriod(Duration.ofSeconds(60L));
        ((AgentPeriodicTaskService)this.agent.getAgentService(AgentPeriodicTaskService.class)).scheduleAgentPeriodicTask(resetCounterAndPublish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounters() {
        Thread oldStatusThread = this.statusThread;
        Thread oldCommandThread = this.commandThread;
        Thread oldLogThread = this.logThread;
        Object object = counterLock;
        synchronized (object) {
            agentCountersMap = new ConcurrentHashMap<Tags, Integer>();
            tagsAccumMap = new ConcurrentHashMap<Tags, Map<String, Accumulate>>();
            if (statusQueue != null) {
                statusQueue.add(new DoneWork());
                commandQueue.add(new DoneWork());
                logQueue.add(new DoneWork());
            }
            statusQueue = new LinkedBlockingQueue<Runnable>();
            commandQueue = new LinkedBlockingQueue<Runnable>();
            logQueue = new LinkedBlockingQueue<Runnable>();
            this.statusThread = new MyQueueWorker(statusQueue);
            this.commandThread = new MyQueueWorker(commandQueue);
            this.logThread = new MyQueueWorker(logQueue);
            this.statusThread.start();
            this.commandThread.start();
            this.logThread.start();
        }
        try {
            if (oldStatusThread != null) {
                oldStatusThread.join();
            }
            if (oldCommandThread != null) {
                oldCommandThread.join();
            }
            if (oldLogThread != null) {
                oldLogThread.join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public void start() {
        this.resetCounters();
        this.agent.getMessagingAccess().addCommandMessageListener((CommandMessageListener)new CommandBusCounterListener());
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)new StatusBusCounterListener());
        this.agent.getMessagingAccess().addLogMessageListener((LogMessageListener)new LogBusCounterListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounterAndPublish() {
        ConcurrentSet allTags;
        Map<Tags, Map<String, Accumulate>> agentTimeAccumulatorsMapOld;
        Map<Tags, Integer> agentCountersMapOld;
        Object object = counterLock;
        synchronized (object) {
            agentCountersMapOld = agentCountersMap;
            agentTimeAccumulatorsMapOld = tagsAccumMap;
        }
        this.resetCounters();
        if (this.influxDbClientService != null && this.influxDbClientService.getInfluxDbClient() != null) {
            allTags = new ConcurrentSet();
            allTags.addAll(agentCountersMapOld.keySet());
            allTags.addAll(agentTimeAccumulatorsMapOld.keySet());
            long time = System.currentTimeMillis();
            for (Tags tag : allTags) {
                Point.Builder pointBuilder = Point.measurement((String)"cluster_metrics").time(time, TimeUnit.MILLISECONDS);
                Integer counter = agentCountersMapOld.get(tag);
                if (counter != null) {
                    pointBuilder = pointBuilder.addField("traffic", (Number)counter);
                }
                Map<String, Accumulate> accumMap = agentTimeAccumulatorsMapOld.get(tag);
                for (String key : accumMap.keySet()) {
                    Accumulate accum = accumMap.get(key);
                    if (accum.getCounts() <= 0) continue;
                    pointBuilder = pointBuilder.addField(key + "_avg", accum.getAverageValue()).addField(key + "_max", accum.getMaxValue()).addField(key + "_min", accum.getMinValue());
                }
                if (!pointBuilder.hasFields()) continue;
                AgentInfo.AgentType agentType = tag.agentInfo.getType();
                String agentName = agentType == AgentInfo.AgentType.CONSOLE ? "console" : tag.agentInfo.getName();
                Point point = pointBuilder.tag("bus", tag.bus.name()).tag("agent", agentName).tag("host", tag.agentInfo.getAgentProperty("org.lsst.ccs.agent.hostname", "")).tag("user", tag.agentInfo.getAgentProperty("org.lsst.ccs.agent.username", "")).tag("type", agentType.name()).build();
                LOG.fine("Writing to influxDb " + point);
                this.influxDbClientService.getInfluxDbClient().write(point);
            }
        } else {
            allTags = new ConcurrentSet();
            allTags.addAll(agentCountersMapOld.keySet());
            allTags.addAll(agentTimeAccumulatorsMapOld.keySet());
            KeyValueDataList dataList = new KeyValueDataList("cluster_metrics");
            HashMap<String, Integer> allCounters = new HashMap<String, Integer>();
            for (Tags tag : allTags) {
                String busName = tag.bus.name();
                String agentName = tag.agentInfo.getType() == AgentInfo.AgentType.CONSOLE ? "console" : tag.agentInfo.getName();
                Integer counter = agentCountersMapOld.get(tag);
                if (counter != null) {
                    dataList.addData("traffic/" + busName + "/" + agentName, (Serializable)counter);
                    allCounters.put(busName, allCounters.getOrDefault(busName, 0) + counter);
                }
                Map<String, Accumulate> accumMap = agentTimeAccumulatorsMapOld.get(tag);
                for (String key : accumMap.keySet()) {
                    Accumulate accum = accumMap.get(key);
                    if (accum.getCounts() <= 0) continue;
                    dataList.addData(key + "_avg/" + busName + "/" + agentName, (Serializable)Double.valueOf(accum.getAverageValue()));
                    dataList.addData(key + "_max/" + busName + "/" + agentName, (Serializable)Double.valueOf(accum.getMaxValue()));
                    dataList.addData(key + "_min/" + busName + "/" + agentName, (Serializable)Double.valueOf(accum.getMinValue()));
                }
            }
            for (String busName : allCounters.keySet()) {
                dataList.addData("traffic/" + busName + "/all", (Serializable)allCounters.get(busName));
            }
            this.agent.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
        }
    }

    private static void incrementAgentCounter(Tags tags) {
        Integer agentCounter = agentCountersMap.get(tags);
        if (agentCounter == null) {
            agentCounter = 0;
        }
        agentCounter = agentCounter + 1;
        agentCountersMap.put(tags, agentCounter);
    }

    private static void incrementAgentKeyAccumulator(Tags tags, String key, double value) {
        Accumulate accum;
        Map<String, Accumulate> keyAccumMap = tagsAccumMap.get(tags);
        if (keyAccumMap == null) {
            keyAccumMap = new HashMap<String, Accumulate>();
            tagsAccumMap.put(tags, keyAccumMap);
        }
        if ((accum = keyAccumMap.get(key)) == null) {
            accum = new Accumulate();
            keyAccumMap.put(key, accum);
        }
        accum.accumulate(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processBusMessage(Bus bus, BusMessage msg, CCSTimeStamp received) {
        AgentInfo agentInfo = msg.getOriginAgentInfo();
        Tags tags = new Tags(bus, agentInfo);
        long deltaT = Duration.between(msg.getCCSTimeStamp().getUTCInstant(), received.getUTCInstant()).toMillis();
        long transferTime = msg.getTransferDuration() != null ? msg.getTransferDuration().toMillis() : 0L;
        long processingOut = msg.getSerializationTime() != null ? Duration.between(msg.getCCSTimeStamp().getUTCInstant(), msg.getSerializationTime().getUTCInstant()).toMillis() : 0L;
        long processingIn = 0L;
        if (msg.getDeSerializationTime() != null && received != null) {
            processingIn = Duration.between(msg.getDeSerializationTime().getUTCInstant(), received.getUTCInstant()).toMillis();
        }
        double size = BusTrafficMonitor.sizeOf((Serializable)msg);
        Object object = counterLock;
        synchronized (object) {
            BusTrafficMonitor.incrementAgentCounter(tags);
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "transfer_total", deltaT);
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "transfer", transferTime);
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "process_out", processingOut);
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "process_in", processingIn);
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "size", size);
        }
    }

    public static double sizeOf(Serializable object) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);){
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException ieo) {
            return 0.0;
        }
        return (double)byteOutputStream.toByteArray().length / 1000.0;
    }

    private class DoneWork
    implements Runnable {
        private DoneWork() {
        }

        @Override
        public void run() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class MyQueueWorker
    extends Thread {
        private final BlockingQueue<Runnable> queue;

        public MyQueueWorker(BlockingQueue<Runnable> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                Runnable r;
                while (!((r = this.queue.take()) instanceof DoneWork)) {
                    r.run();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class StatusBusCounterListener
    implements StatusMessageListener {
        private StatusBusCounterListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            statusQueue.add(() -> BusTrafficMonitor.processBusMessage(Bus.STATUS, (BusMessage)msg, CCSTimeStamp.currentTime()));
        }
    }

    private static class LogBusCounterListener
    implements LogMessageListener {
        private LogBusCounterListener() {
        }

        public void onLogMessage(LogMessage msg) {
            logQueue.add(() -> BusTrafficMonitor.processBusMessage(Bus.LOG, (BusMessage)msg, CCSTimeStamp.currentTime()));
        }
    }

    private static class CommandBusCounterListener
    implements CommandMessageListener {
        private CommandBusCounterListener() {
        }

        public void onCommandMessage(CommandMessage msg) {
            commandQueue.add(() -> BusTrafficMonitor.processBusMessage(Bus.COMMAND, (BusMessage)msg, CCSTimeStamp.currentTime()));
        }
    }

    private static class Tags {
        private final Bus bus;
        private final AgentInfo agentInfo;

        Tags(Bus bus, AgentInfo agentInfo) {
            this.bus = bus;
            this.agentInfo = agentInfo;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Tags) {
                Tags t1 = (Tags)obj;
                return t1.bus.equals((Object)this.bus) && t1.agentInfo.equals((Object)this.agentInfo);
            }
            return false;
        }

        public int hashCode() {
            return this.bus.hashCode() + 34 * this.agentInfo.hashCode();
        }
    }
}

