# Specification file for primary header. Taken from LCA 10140 v1.
# Modified for use with focal-plane
#
HEADVER     Integer 2                           Version number of header
INSTRUME    String  lsstCam                     Instrument
TELESCOP    String  LSST                        Telescope
# Header requested by Merlin, TimJ
TSTAND      String  BOT                         Camera test stand BOT or CCOB
SEQFILE     String  ${focal-plane/RAFT/REB/sequencerFile}  Sequencer file name
SEQCKSUM    String  ${focal-plane/RAFT/REB/sequencerChecksum} Checksum of Sequencer
LSST_NUM    String  ${focal-plane/RAFT/REB/CCD/name} LSST Assigned CCD Number
REBNAME     String  ${focal-plane/RAFT/REB/name} LSST Assigned Name REB name
RAFTNAME    String  ${focal-plane/RAFT/name}    LSST Assigned Raft name
DARKTIME    Float   ${DarkTime}                 Dark Time in Seconds (see TSEIA-91)
# Elements from the image name, see also TSEIA-79
OBSID       String  ${ImageName}                The image name or obs-id
TELCODE     String  ${ImageSource}              The "code" for MainCamera
CONTRLLR    String  ${ImageController}          The controller (e.g. O for OCS, C for CCS)
DAYOBS      String  ${ImageDate}                The observation day as defined in the image name 
SEQNUM      Integer ${ImageNumber}              The sequence number from the image name
#
CCDTEMP     Float   ${focal-plane/RAFT/REB/CCD/Temp} Measured temperature (deg C)
TSEQNUM     Integer ${TestSeqNum}                Sequence number within current test
#
# CCOB items (do they belong in primary header -- probably not)
TEMPLED1    Float   ${ccob/tempLed1}            CCOB daughter board temperature, front
TEMPLED2    Float   ${ccob/tempLed2}            CCOB daughter board temperature, back
TEMPSPH     Float   ${ccob/tempSphere}          CCOB sphere temperature
TEMPBRD     Float   ${ccob/tempBrd}             CCOB board temperature
CCOBLED     String  ${CCOBLED}                  Selected CCOB LED
CCOBCURR    Float   ${CCOBCURR}                 CCOB LED current
CCOBADC     Float   ${CCOBADC}                  CCOB Photodiode value (after exposure)
# BOT items
BOTXCAM     Float ${bot-motorplatform/LampStatus/xcam} X position of lamp/source in camera coordinate system
BOTYCAM     Float ${bot-motorplatform/LampStatus/ycam} Y position of lamp/source in camera coordinate system
BOTX        Float ${bot-motorplatform/LampStatus/xbot} X position of BOT in raw bot coordinates
BOTY        Float ${bot-motorplatform/LampStatus/ybot} Y position of BOT in raw bot coordinates
# Flat Field projector items
FILTER      String ${bot-bench/ColorFWheel/filterName}   Color filter name from Flat Field Projector
FILTER2     String ${bot-bench/NeutralFWheel/filterName} Neutral density filter name from Flat Field Projector
# Used for Fe55+Flat and Spots+Flats
EXPTIME2    Float ${ExposureTime2} Exposure time for second part of 2 part exposure