import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.MainPower
import org.lsst.ccs.subsystem.power.BK1696Device
import org.lsst.ccs.subsystem.power.BK9130Device
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.monitor.Channel

taskConfig = ["monitor-update/taskPeriodMillis":5000,"monitor-publish/taskPeriodMillis":10000]

CCSBuilder builder = ["ccs-vstpower"]

builder.main (MainPower, broadcastMillis:5000, nodeTags:taskConfig) {

    def pwr1 = "Power1"
    def pwr2 = "Power2"

    "$pwr1" (BK9130Device, connType:"ftdi", devcId:"A7032YJX", baudRate:0) {

        "${pwr1}.6V"  (PowerControl, desc:"6V power supply", hwchan:3, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr1}.9V"  (PowerControl, desc:"9V power supply", hwchan:1, voltage:0, current:0, onDelay:0, offDelay:0)

        "${pwr1}.24V" (PowerControl, desc:"24V power supply", hwchan:2, voltage:0, current:0, onDelay:0, offDelay:0)
    }

    "$pwr2" (BK1696Device, connType:"ftdi", devcId:"A402WP2Y", baudRate:0) {

        "${pwr2}.40V" (PowerControl, desc:"40V power supply", hwchan:0, voltage:0, current:0, onDelay:0, offDelay:0)
    }

    "power.6Vv"   (Channel, description: "PS 6V voltage", units: "Volts",
                   devcName: "${pwr1}", hwChan: 3, type: "VOLTAGE")
                          
    "power.6Vi"   (Channel, description: "PS 6V current", units: "Amps",
                   devcName: "${pwr1}", hwChan: 3, type: "CURRENT")
                          
    "power.9Vv"   (Channel, description: "PS 9V voltage", units: "Volts",
                   devcName: "${pwr1}", hwChan: 1, type: "VOLTAGE")
                          
    "power.9Vi"   (Channel, description: "PS 9V current", units: "Amps",
                   devcName: "${pwr1}", hwChan: 1, type: "CURRENT")
                          
    "power.24Vv"  (Channel, description: "PS 24V voltage", units: "Volts",
                   devcName: "${pwr1}", hwChan: 2, type: "VOLTAGE")
                          
    "power.24Vi"  (Channel, description: "PS 24V current", units: "Amps",
                   devcName: "${pwr1}", hwChan: 2, type: "CURRENT")
                          
    "power.40Vv"  (Channel, description: "PS 40V voltage", units: "Volts",
                   devcName: "${pwr2}", hwChan: 0, type: "VOLTAGE")
                          
    "power.40Vi"  (Channel, description: "PS 40V current", units: "Amps",
                   devcName: "${pwr2}", hwChan: 0, type: "CURRENT")
                          
}
