import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.teststand.TSSubSys;
import org.lsst.ccs.subsystem.teststand.TSConfigurable;
import org.lsst.ccs.subsystem.teststand.TSSetDevTypes;
import org.lsst.ccs.subsystem.teststand.KeithleyDevice;
import org.lsst.ccs.subsystem.teststand.CryoCon24cDevice;
import org.lsst.ccs.subsystem.teststand.MicroIonDevice;
import org.lsst.ccs.subsystem.teststand.GPVacMon835Device;
import org.lsst.ccs.subsystem.teststand.NewportLampDevice;
import org.lsst.ccs.subsystem.teststand.OrielShutterDevice;
import org.lsst.ccs.subsystem.teststand.Cornerstone260Device;
import org.lsst.ccs.subsystem.teststand.NetBotzDevice;
import org.lsst.ccs.subsystem.teststand.XEDDevice;
import org.lsst.ccs.subsystem.teststand.AP7900Device;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["ts"]

builder.
    main (TSSubSys, configName:"bnlts5", broadcastMillis:10000) {

    VQMonitor (GPVacMon835Device, serialdev:"/dev/ttyACM0", baud:9600)

//    Bias  (KeithleyDevice, host:"AH032N9T", port:57600)

//    PhotoDiode  (KeithleyDevice, host:"AH032N9V", port:57600)

    Cryo   (CryoCon24cDevice, itype:1, host:"AI02G0LO", port:19200)
  
//    VacuumGauge (MicroIonDevice, itype:1, host:"ZM", port:19200, addr:1)
    
    Enviro (NetBotzDevice, ef:"/home/ts5prod/bnlenviro.dat")

//    Lamp (NewportLampDevice, itype:1, host:"HY", baud:9600)
    
//    Shutter (OrielShutterDevice, host:"?", port:9600, addr:0)
    
    PDU (AP7900Device, host:"130.199.47.43", port:23, major_version:2)

//    Monochromator (Cornerstone260Device, host:"AH032N9X", baud:9600)
    
//    Fe55 (XEDDevice, host:"HX", port:4800)
    
    "TSCFG" (TSSetDevTypes, filter1:'empty',filter2:'275CutOn',filter3:'550CutOn',filter4:' ',filter5:' ',filter6:' ',
            filteredge1:0.0, filteredge2:275.0, filteredge3:560.0, filteredge4:0.0, filteredge5:0.0, filteredge6:0.0,
            pdtype:'KEITHLEY-INSTRUMENTS-INC.,MODEL-6487',
            biastype:'KEITHLEY-INSTRUMENTS-INC.,MODEL-6487',
            srctype:'Newport-Xenon-Arc-Lamp',
            monotype:'Cornerstone260')
        
    "IDLE"(TSConfigurable, name:'IDLE', lambda:500.0, minlmppwr:0.0,
        cryotol:200.0, bias:0.0, vac:1000.0, cryo:-125.0)
     
    "READY"(TSConfigurable, name:'READY', lambda:500.0, minlmppwr:198.0, 
        cryotol:2.0, bias:0.0, vac:1.0e-3, cryo:-125.0)
 
    "TEST"(TSConfigurable, name:'TEST', lambda:500.0, minlmppwr:0.0, 
        cryotol:2.0, bias:-25.0, vac:1.0e-5, cryo:-125.0)
 
    "ACQ1"(TSConfigurable, name:'ACQ1', lambda:500.0, minlmppwr:198.0, 
        cryotol:2.0, bias:-25.0, vac:1.0e-5, cryo:-125.0)
 
    "WARM"(TSConfigurable, name:'WARM', lambda:500.0, minlmppwr:0.0, 
        cryotol:10.0, bias:-25.0, vac:1000.0, cryo:20.0)

     
            

    //    AlarmHDW  (TSSubSys, argMap("OV", 0))
    AlarmHDW  (Alarm, eventParm:TSConfig.EVENT_ID.BIAS.ordinal())

    AlarmHDWC  (Alarm, eventParm:TSConfig.EVENT_ID.CRYO.ordinal())

    AlarmHDWV  (Alarm, eventParm:TSConfig.EVENT_ID.VAC.ordinal())

    AlarmHDWPD (Alarm, eventParm:TSConfig.EVENT_ID.PD.ordinal())

    AlarmHDWLMP (Alarm, eventParm:TSConfig.EVENT_ID.LMP.ordinal())


    /*
    CmpCCDBias  (MonChannel,
    argMap("CCD Bias Voltage", "V",
    "alarm", 0.0, 0.0,
    "alarm", 0.0, 0.0,
    "Bias", 0, "VOLT", "B", 0, 0.0, 1.0))
     */      
    /*
    Its name, used to identify it in databases, plots, etc.
    Its longer, more descriptive, name.
    The units the value is expressed in, e.g. "Volts".
    The device used for obtaining its value.
    The hardware channel number on the device.
    The channel type, e.g. temperature, pressure, etc, which is needed by some devices.
    The subtype, which supplies hardware configuration information.
    The offset and scale values needed for converting a raw hardware value to a physical one.
    Parameters used for checking the value against a limit.  There is one set for the low limit and one for the high one:
    The checking option: NONE, FLAG or ALARM
    The limit value.
    The alarm to be activated upon status transitions when ALARM is specified.
    The deadband value which delays a potential alarm action during a transition back to good status.
    Its id, which is its index in the list of all channels.

    The limit values are maintained by the configuration system and can be changed while running.  Any such change causes a status message to be broadcast, which can be used to update the trending database or to update any console displays.
     */

        temp_a  (Channel,
                    description:"Cryogenics temperature A", units:"C",
                           devcName:"Cryo", hwChan:5, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-110.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        temp_b  (Channel,
                    description:"Cryogenics temperature B", units:"C",
                           devcName:"Cryo", hwChan:6, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-110.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        temp_c  (Channel,
                    description:"Cryogenics temperature C", units:"C",
                           devcName:"Cryo", hwChan:7, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-110.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        temp_d  (Channel,
                    description:"Cryogenics temperature D", units:"C",
                           devcName:"Cryo", hwChan:8, type:"TEMP", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:-110.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:28.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        htrread1  (Channel,
                    description:"Cryogenics heater loop 1 % power", units:"C",
                           devcName:"Cryo", hwChan:3, type:"TEMP", subtype:"P", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:100.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        htrread2  (Channel,
                    description:"Cryogenics heater loop 2 % power", units:"C",
                           devcName:"Cryo", hwChan:4, type:"TEMP", subtype:"P", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:100.0, dbandHi:0.0, alarmHi:"AlarmHDWC")

        vqmpressure  (Channel,
                    description:"VQM Pressure Reading", units:"T",
                           devcName:"VQMonitor", hwChan:0, type:"PRESSURE", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:1000.0, dbandHi:0.0, alarmHi:"AlarmHDWV")

        dewarpressure  (Channel,
                    description:"Dewar Vacuum Reading", units:"T",
                           devcName:"VacuumGauge", hwChan:0, type:"PRESSURE", subtype:"T", offset:0.0, scale:1.0,
                           checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"alarm", limitHi:1000.0, dbandHi:0.0, alarmHi:"AlarmHDWV")


        roomtemperature  (Channel,
                    description:"Temperature", units:"C",
                           devcName:"Enviro", hwChan:1, type:"UNKNOWN", subtype:"C", offset:0.0, scale:1.0,
                           checkLo:"flag", limitLo:65.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"flag", limitHi:75.0, dbandHi:0.0, alarmHi:null)

        dewpoint  (Channel,
                    description:"Dew Point", units:"D",
                           devcName:"Enviro", hwChan:2, type:"UNKNOWN", subtype:"C", offset:0.0, scale:1.0,
                           checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"flag", limitHi:1.0, dbandHi:0.0, alarmHi:null)

        partcounter  (Channel,
                    description:"Particle Count", units:"1",
                           devcName:"Enviro", hwChan:3, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
                           checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
                           checkHi:"flag", limitHi:10.0, dbandHi:0.0, alarmHi:null)
}