/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class TempControl
implements HasLifecycle {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, PowerDevice> powerDevices = new HashMap<String, PowerDevice>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    private Double gain;
    private Double timeConst;
    private Double smoothTime;
    private Double maxOutput;
    private Double awGain;
    private Double basePower;
    private Double tolerance;
    private double minOutput = 0.0;
    private double maxInput = 100.0;
    private double minInput = -200.0;
    private Integer updateTime;
    private String powerDevc;
    private Integer powerChan;
    private String[] tempChans;
    private static final Logger LOG = Logger.getLogger((String)TempControl.class.getName());
    private PIController pic;
    private PowerDevice powerDevcC;
    private final List<Channel> tempChansL = new ArrayList<Channel>();
    private double lastPower;
    private boolean active;

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask(this.name + "-timer", () -> this.iterateLoop()).withPeriod(Duration.ofMillis(this.updateTime.intValue()));
        this.pts.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        if (this.gain == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"gain", (String)"is missing");
        }
        if (this.timeConst == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"timeConst", (String)"is missing");
        }
        if (this.smoothTime == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"smoothTime", (String)"is missing");
        }
        if (this.maxOutput == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"maxOutput", (String)"is missing");
        }
        if (this.awGain == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"awGain", (String)"is missing");
        }
        if (this.basePower == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"basePower", (String)"is missing");
        }
        if (this.tolerance == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tolerance", (String)"is missing");
        }
        if (this.updateTime == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"updateTime", (String)"is missing");
        }
        if (this.powerDevc == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"powerDevc", (String)"is missing");
        }
        this.powerDevcC = this.powerDevices.get(this.powerDevc);
        if (this.powerDevcC == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)this.powerDevc, (String)"doesn't exist");
        }
        if (this.powerChan == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"powerChan", (String)"is missing");
        }
        if (this.tempChans == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempChans", (String)"is missing");
        }
        for (String cName : this.tempChans) {
            Channel chan = this.allChannels.get(cName);
            if (chan == null) {
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)cName, (String)"doesn't exist");
            }
            this.tempChansL.add(chan);
        }
        this.pic = new PIController(this.gain.doubleValue(), this.timeConst.doubleValue());
        this.pic.setSmoothTime(this.smoothTime.doubleValue());
        this.pic.setAwGain(this.awGain.doubleValue());
        this.pic.setBaseOutput(this.basePower.doubleValue());
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput.doubleValue());
        this.pic.setTolerance(this.tolerance.doubleValue());
    }

    public PowerDevice getPowerDevice() {
        return this.powerDevcC;
    }

    public int getPowerChannel() {
        return this.powerChan;
    }

    public void setTemp(double value) {
        this.pic.setSetpoint(value);
    }

    public void reset() {
        this.pic.reset();
    }

    public void restart() {
        this.start(this.lastPower);
    }

    public void start(double power) {
        if (this.active) {
            return;
        }
        this.active = true;
        this.pic.reset();
        this.pic.setIntegral(power - this.basePower);
    }

    public void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
    }

    private void iterateLoop() {
        if (!this.active) {
            return;
        }
        int count = 0;
        double temp = 0.0;
        for (Channel tempChan : this.tempChansL) {
            double value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            temp += value;
            ++count;
        }
        if (count > 0) {
            double tod = (double)System.currentTimeMillis() / 1000.0;
            this.lastPower = this.pic.performPI(new double[]{temp / (double)count}, tod);
            this.powerDevcC.setPower(this.powerChan, this.lastPower);
        } else {
            LOG.error((Object)"Control loop iteration failed: no valid temperature values available");
        }
    }
}

