/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.refrig.data.HexState;
import org.lsst.ccs.subsystem.refrig.data.UpdatePeriod;
import org.lsst.ccs.utilities.logging.Logger;

public class HexMain
extends Subsystem
implements HasLifecycle,
AgentPresenceListener,
StatusMessageListener {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService apts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService aps;
    private static final Logger LOG = Logger.getLogger((String)HexMain.class.getName());
    private final HexState state = new HexState();

    public HexMain() {
        super("hex", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.aps.setAgentProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void postInit() {
        this.aps.setAgentProperty("hexType", HexMain.class.getCanonicalName());
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public void postStart() {
        LOG.info((Object)"Heat exchanger subsystem started");
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType")) continue;
            String agentName = agent.getName();
            this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
            break;
        }
    }

    public void disconnecting(AgentInfo agent) {
        if (agent.hasAgentProperty("compressorType")) {
            this.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData sd = (StatusSubsystemData)msg;
        if (sd.getDataKey().equals("UpdatePeriod")) {
            this.setTickPeriod(((UpdatePeriod)sd.getSubsystemData().getValue()).getTickMillis());
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the heat exchanger state")
    public HexState getSystemState() {
        this.state.setTickMillis(this.getTickPeriod());
        return this.state;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    private void publishState() {
        this.state.setTickMillis(this.getTickPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("HexState", (Serializable)this.state));
    }

    private void setTickPeriod(long period) {
        this.apts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.apts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }
}

