/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.HeaterPS;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class HeaterPsDevice
extends PowerDevice {
    public static final int CHANSET_COLD = 0;
    public static final int CHANSET_CRYO = 1;
    public static final int TYPE_VOLTAGE = 0;
    public static final int TYPE_CURRENT = 1;
    public static final int TYPE_POWER = 2;
    public static final int TYPE_TOTAL_POWER = 3;
    public static final int TYPE_TEMP = 4;
    public static final int TYPE_MAIN_VOLTS = 5;
    public static final int TYPE_MAIN_CURR = 6;
    public static final int TYPE_MAIN_POWER = 7;
    public static final int TYPE_MAIN_TEMP = 8;
    public static final int TYPE_MAIN_STATUS = 9;
    private static final int N_HW_CHANS = 12;
    private static final int N_SET_CHANS = 6;
    private static final int CRYO_CHANNEL_FIRST = 0;
    private static final int COLD_CHANNEL_FIRST = 6;
    private static final int COLD_CHANNEL_MINUS_Y = 6;
    private static final int COLD_CHANNEL_PLUS_Y = 11;
    private static final String NODE = "node";
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(name="node", category="Refrig", isFinal=true)
    private Integer node;
    private int[] cryoChannels;
    private int[] coldChannels;
    private static final Logger LOG;
    private final HeaterPS htr = new HeaterPS();
    private final Set<Integer> coldChannelSet = new HashSet<Integer>();
    private final Set<Integer> dsabColdChannelSet = new HashSet<Integer>();
    private final Set<Integer> cryoChannelSet = new HashSet<Integer>();
    private final Set<Integer>[] channelSets = new Set[2];
    private final double[] currents = new double[12];
    private final double[] voltages = new double[12];
    private final boolean[] outputs = new boolean[12];

    public HeaterPsDevice() {
        super("Heater PS", null, 0, 0, 0);
        this.connType = DriverConstants.ConnType.NET;
        this.devcId = "";
    }

    @Override
    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)NODE, (String)"is missing");
        }
        if (this.coldChannels != null) {
            for (int chan : this.coldChannels) {
                if (chan < 0 || chan >= 12) {
                    MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("coldChannel " + chan), (String)" is invalid");
                }
                if (chan < 6) {
                    MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("coldChannel " + chan), (String)" is a cryo channel");
                }
                if (this.coldChannelSet.add(chan)) continue;
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("coldChannel " + chan), (String)" is a duplicate");
            }
        } else {
            for (int chan = 6; chan < 12; ++chan) {
                this.coldChannelSet.add(chan);
            }
        }
        if (this.cryoChannels != null) {
            for (int chan : this.cryoChannels) {
                if (chan < 0 || chan >= 12) {
                    MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("cryoChannel " + chan), (String)" is invalid");
                }
                if (chan >= 6) {
                    MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("cryoChannel " + chan), (String)" is a cold channel");
                }
                if (this.cryoChannelSet.add(chan)) continue;
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("cryoChannel " + chan), (String)" is a duplicate");
            }
        } else {
            for (int chan = 0; chan < 6; ++chan) {
                this.cryoChannelSet.add(chan);
            }
        }
        this.channelSets[0] = this.coldChannelSet;
        this.channelSets[1] = this.cryoChannelSet;
        this.fullName = "Heater power supply (" + this.node + ")";
    }

    @Override
    protected void initialize() {
        try {
            this.htr.open(this.node.intValue());
            this.htr.setMainPowerOn(true);
            this.htr.setSwitchPeriod(500);
            this.setOnline(true);
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            if (this.htr != null) {
                this.close();
            }
        }
        finally {
            this.inited = true;
        }
    }

    @Override
    protected void close() {
        try {
            this.htr.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        for (int j = 0; j < 12; ++j) {
            this.currents[j] = 0.0;
        }
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int numChan;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        int n = iType == 0 || iType == 1 || iType == 2 ? 12 : (numChan = iType == 3 ? 2 : 1);
        if (hwChan < 0 || hwChan >= numChan) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"HW channel", (Object)hwChan);
        }
        return new int[]{iType, 0};
    }

    @Override
    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            for (int chan = 0; chan < 12; ++chan) {
                this.currents[chan] = this.htr.readCurrent(chan);
                this.voltages[chan] = this.htr.getVoltage(chan);
                this.outputs[chan] = this.htr.getOutput(chan);
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading currents & voltages from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        if (this.online) {
            try {
                switch (type) {
                    case 0: {
                        value = this.outputs[hwChan] ? this.voltages[hwChan] : 0.0;
                        break;
                    }
                    case 1: {
                        value = this.currents[hwChan];
                        break;
                    }
                    case 2: {
                        value = this.outputs[hwChan] ? this.voltages[hwChan] * this.currents[hwChan] : 0.0;
                        break;
                    }
                    case 3: {
                        int firstChan;
                        value = 0.0;
                        for (int chan = firstChan = hwChan == 0 ? 6 : 0; chan < firstChan + 6; ++chan) {
                            value += this.outputs[chan] ? this.voltages[chan] * this.currents[chan] : 0.0;
                        }
                        break;
                    }
                    case 4: {
                        value = this.htr.readBoardTemperature();
                        break;
                    }
                    case 5: {
                        value = this.htr.readMainVoltage();
                        break;
                    }
                    case 6: {
                        value = this.htr.readMainCurrent();
                        break;
                    }
                    case 7: {
                        value = this.htr.readMainVoltage() * this.htr.readMainCurrent();
                        break;
                    }
                    case 8: {
                        value = this.htr.readMainTemperature();
                        break;
                    }
                    case 9: {
                        value = this.htr.readMainStatus();
                    }
                }
            }
            catch (DriverException e) {
                LOG.error((Object)("Error reading value from " + this.fullName + ": " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
        return value;
    }

    public void enableColdSection(int section, boolean enable) {
        int chan;
        int n = chan = section == 0 ? 6 : 11;
        if (this.coldChannelSet.contains(chan)) {
            if (enable) {
                this.dsabColdChannelSet.remove(chan);
            } else {
                this.dsabColdChannelSet.add(chan);
            }
        }
    }

    @Override
    public void setOutput(int chanSet, boolean value) {
        if (!this.online) {
            return;
        }
        try {
            Iterator<Integer> iterator = this.channelSets[chanSet].iterator();
            while (iterator.hasNext()) {
                int chan;
                this.htr.setOutput(chan, this.dsabColdChannelSet.contains(chan = iterator.next().intValue()) ? false : value);
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public boolean getOutput(int chanSet) {
        if (!this.online) {
            return false;
        }
        try {
            boolean state = false;
            for (int chan : this.channelSets[chanSet]) {
                state |= this.htr.getOutput(chan);
            }
            return state;
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return false;
        }
    }

    @Override
    @Command(description="Set the voltage", type=Command.CommandType.ACTION)
    public void setVoltage(int chanSet, double value) {
        if (!this.online) {
            return;
        }
        try {
            for (int chan : this.channelSets[chanSet]) {
                this.htr.setVoltage(chan, value);
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public double readVoltage(int chanSet) {
        if (!this.online) {
            return -1.0;
        }
        try {
            double voltage = 0.0;
            int count = 0;
            for (int chan : this.channelSets[chanSet]) {
                if (!this.htr.getOutput(chan)) continue;
                voltage += this.htr.getVoltage(chan);
                ++count;
            }
            return count > 0 ? voltage / (double)count : 0.0;
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    @Override
    public void setCurrent(int chan, double value) {
    }

    @Override
    public double readCurrent(int chanSet) {
        if (!this.online) {
            return -1.0;
        }
        try {
            double current = 0.0;
            for (int chan : this.channelSets[chanSet]) {
                current += this.htr.readCurrent(chan);
            }
            return current;
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    static {
        typeMap.put("VOLTAGE", 0);
        typeMap.put("CURRENT", 1);
        typeMap.put("POWER", 2);
        typeMap.put("TOTALPOWER", 3);
        typeMap.put("TEMP", 4);
        typeMap.put("MAINVOLTS", 5);
        typeMap.put("MAINCURR", 6);
        typeMap.put("MAINPOWER", 7);
        typeMap.put("MAINTEMP", 8);
        typeMap.put("MAINSTAT", 9);
        LOG = Logger.getLogger((String)HeaterPsDevice.class.getName());
    }
}

