/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.refrig.data.RefrigState1;
import org.lsst.ccs.utilities.logging.Logger;

public class Compressor0
implements HasLifecycle,
Monitor.AlarmHandler {
    private static final int EVENT_ID_MAIN_POWER = 0;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, Line> allLines = new HashMap<String, Line>();
    private String cmprPowerLine;
    private String heaterPowerLine;
    private String resetLine;
    private static final Logger LOG = Logger.getLogger((String)Compressor0.class.getName());
    private boolean coldStart;
    private boolean running;
    private Line cmprPowerLineL;
    private Line heaterPowerLineL;
    private Line resetLineL;
    private final RefrigState1 state = new RefrigState1();

    public void postInit() {
        this.subsys.setAgentProperty("compressorType", Compressor0.class.getCanonicalName());
        this.state.setTickMillis(this.getTickPeriod());
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
        if (this.cmprPowerLine != null) {
            this.cmprPowerLineL = this.allLines.get(this.cmprPowerLine);
        }
        if (this.cmprPowerLineL == null) {
            LOG.error((Object)"Compressor power line not specified or not defined");
        }
        if (this.heaterPowerLine != null) {
            this.heaterPowerLineL = this.allLines.get(this.heaterPowerLine);
        }
        if (this.heaterPowerLineL == null) {
            LOG.error((Object)"Heater power line not specified or not defined");
        }
        if (this.resetLine != null) {
            this.resetLineL = this.allLines.get(this.resetLine);
        }
        if (this.resetLineL == null) {
            LOG.error((Object)"Reset line not specified or not defined");
        }
    }

    public void postStart() {
        if (this.cmprPowerLineL != null) {
            this.cmprPowerLineL.setWarm(!this.coldStart);
        }
        if (this.heaterPowerLineL != null) {
            this.heaterPowerLineL.setWarm(!this.coldStart);
        }
        if (this.cmprPowerLineL != null) {
            this.cmprPowerLineL.setWarm(false);
        }
        if (this.heaterPowerLineL != null) {
            this.heaterPowerLineL.setWarm(false);
        }
        this.setCompPowerEnable(this.isCompPowerOn() ? 1 : 0);
        this.setHeaterPowerEnable(this.isHeaterPowerOn() ? 1 : 0);
        this.running = true;
        LOG.info((Object)("Refrigeration subsystem (" + this.subsys.getName() + ") started"));
    }

    @Command(type=Command.CommandType.QUERY, description="Get the refrigeration state")
    public RefrigState1 getSystemState() {
        return this.state;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        this.setTickPeriod(value);
        this.state.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    public boolean processAlarm(int event, int parm, String cause, String name) {
        switch (parm) {
            case 0: {
                if (event == 0) {
                    if (this.state.getCmprPowerState(0) == 2) break;
                    this.state.setCmprPowerState(0, 2);
                    this.setCompPowerEnable(0);
                    this.publishState();
                    break;
                }
                if (event != 3 || this.state.getCmprPowerState(0) != 2) break;
                this.state.setCmprPowerState(0, 0);
                this.publishState();
                break;
            }
        }
        return false;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the main power enabled state")
    public void setCompPowerEnable(int value) {
        if (value != 0) {
            if (this.state.getCmprPowerState(0) != 2) {
                this.state.setCmprPowerState(0, 1);
            }
        } else {
            this.state.setCmprPowerState(0, 0);
        }
        this.setCompPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater power enabled state")
    public void setHeaterPowerEnable(int value) {
        if (value != 0) {
            this.state.setHeaterPowerState(1);
        } else {
            this.state.setHeaterPowerState(0);
        }
        this.setHeaterPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Reset the latches")
    public void reset() {
        if (this.resetLineL != null) {
            this.resetLineL.set(true);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.resetLineL.set(false);
        }
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("RefrigState", (Serializable)this.state));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private void setCompPower() {
        if (this.cmprPowerLineL != null) {
            this.cmprPowerLineL.set(this.state.getCmprPowerState(0) == 1);
        }
    }

    private void setHeaterPower() {
        if (this.heaterPowerLineL != null) {
            this.heaterPowerLineL.set(this.state.getHeaterPowerState() == 1);
        }
    }

    private boolean isCompPowerOn() {
        return this.cmprPowerLineL != null && this.cmprPowerLineL.isSet() != false;
    }

    private boolean isHeaterPowerOn() {
        return this.heaterPowerLineL != null && this.heaterPowerLineL.isSet() != false;
    }
}

