/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm.filtersim;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.mcm.filtersim.FilterInternalState;
import org.lsst.ccs.utilities.logging.Logger;

public class FilterSim
implements HasLifecycle,
SignalHandler {
    protected FilterInternalState state = FilterInternalState.ONLINE_NONE;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    protected volatile boolean alarmed = false;
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsystem;

    public void init() {
        this.subsystem.updateAgentState(new Enum[]{this.state.getPublicState(), this.state.getPublicReadinessState()});
    }

    public void build() {
        this.subsystem.getAgentPeriodicTaskService().scheduleAgentPeriodicTask(new AgentPeriodicTask("tick", (Runnable)new Tick()));
    }

    @Command
    public void setFilter(String filter) {
        log.info((Object)("FilterSim command: setFilter " + filter));
        this.setState(this.state.setFilter(this, filter.toUpperCase()));
    }

    @Command(level=1)
    public void rotateToSlot(int slot) {
        log.info((Object)("FilterSim command: rotateToSlot " + slot));
        this.setState(this.state.rotateToSlot(this, slot));
    }

    @Command(level=1)
    public void truckToOnline() {
        log.info((Object)"FilterSim command: truckToOnline ");
        this.setState(this.state.truckToOnline(this));
    }

    @Command(level=1)
    public void truckToStandby() {
        log.info((Object)"FilterSim command: truckToStandby ");
        this.setState(this.state.truckToStandby(this));
    }

    @Command
    public void triggerAlarm() {
        log.info((Object)"FilterSim: triggering alarm");
        this.alarmed = true;
        this.setState(this.state.stop(this));
        ((AlertService)this.subsystem.getAgentService(AlertService.class)).raiseAlert(new Alert("FCS001", "FCS alarm"), AlertState.ALARM, "FCS alarm");
    }

    @Command
    public void clearAlarm() {
        log.info((Object)"FilterSim: clearing alarm");
        this.alarmed = false;
        ((AlertService)this.subsystem.getAgentService(AlertService.class)).clearAlerts(new String[]{"FCS001"});
    }

    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT: {
                log.warn((Object)"HALT required");
                this.setState(this.state.stop(this));
                break;
            }
            case STOP: {
                log.warn((Object)"STOP required");
                this.setState(this.state.stop(this));
                break;
            }
        }
        return TreeWalkerDiag.GO;
    }

    Subsystem getSubsystem() {
        return this.subsystem;
    }

    public void setState(FilterInternalState s) {
        if (this.state == s) {
            return;
        }
        this.state.exit(this);
        this.state = s;
        this.state.enter(this);
        this.subsystem.updateAgentState(new Enum[]{this.state.getPublicState(), this.state.getPublicReadinessState()});
        log.info((Object)("FilterSim state: " + this.state.getPublicState() + " " + this.state.getPublicReadinessState()));
    }

    public ScheduledFuture<FilterInternalState> scheduleTransition(Duration delay, FilterInternalState to) {
        log.debug((Object)(" scheduling to " + to + " delay " + delay));
        return this.scheduler.schedule(() -> FilterInternalState.scheduled(this, this.state, to), delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void scheduleTick(Duration delay) {
        this.scheduler.schedule(() -> this.state.tick(this, delay), delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    Logger getLogger() {
        return log;
    }

    public class Tick
    implements Runnable {
        @Override
        public void run() {
            String extra = "";
            if (FilterSim.this.state == FilterInternalState.ROTATING) {
                extra = " vel " + FilterInternalState.getCarrouselVelocity() + " pos " + FilterInternalState.getCarrouselAngle() + " target " + FilterInternalState.getCarrouselTarget();
            }
            if (FilterSim.this.state == FilterInternalState.MOVING_TRUCKS_TO_ONLINE) {
                extra = " for filter " + (Object)((Object)FilterInternalState.getFilterTarget());
            }
            log.debug((Object)(FilterSim.this.state + " " + extra));
        }
    }

    static enum Filter {
        U,
        G,
        R,
        I,
        Z,
        Y,
        NONE;

    }
}

