/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.utility.MpmPlutoDevice;
import org.lsst.ccs.subsystem.utility.SwitchNames;
import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.MpmAlert;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.data.MpmSysState;
import org.lsst.ccs.subsystem.utility.data.UtilityException;
import org.lsst.ccs.utilities.logging.Logger;

public class MpmMain
implements HasLifecycle,
ClearAlertHandler {
    private static final int[] switchChannels = new int[7];
    private static final Map<Integer, MpmAlert> alertMap;
    private static final Map<String, Integer> revAlertMap;
    private static final String[] plcNames;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService apts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService as;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService aps;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MpmPlutoDevice plutoDevc;
    private static final Logger LOG;
    private final MpmSysState protState = new MpmSysState();
    private final Device[] switchDevices = new Device[7];
    private boolean running = false;
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("Protection-state", () -> this.updateProtState()).withPeriod(Duration.ofMillis(1000L));
        this.apts.scheduleAgentPeriodicTask(pt);
        for (MpmAlert alert : MpmAlert.values()) {
            this.activeAlertMap.put(alert.getId(), false);
        }
    }

    public void postInit() {
        this.aps.setAgentProperty("mpmType", MpmMain.class.getCanonicalName());
        if (this.plutoDevc != null) {
            Iterator<Integer> iterator = this.plutoDevc.getLatchIds().iterator();
            while (iterator.hasNext()) {
                int cond = (Integer)iterator.next();
                this.protState.setLatch(cond, LatchState.CLEAR);
            }
            for (int cond : this.plutoDevc.getConditionIds()) {
                this.protState.setCondition(cond, ConditionState.NO);
            }
        } else {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Pluto device", (String)"not specified");
        }
        for (Iterator<Integer> sw : (Iterator<Integer>)switchChannels) {
            this.protState.setSwitchState((int)sw, SwitchState.OFFLINE);
            this.switchDevices[sw] = this.plutoDevc;
        }
    }

    public void postStart() {
        LOG.info((Object)"Protection subsystem started");
        this.running = true;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the protection system state")
    public MpmSysState getSystemState() {
        this.protState.setTickMillis(this.getTickPeriod());
        return this.protState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names")
    public List<String> getSwitchNames() throws UtilityException {
        return new ArrayList<String>(SwitchNames.NAME_MAP.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a switch")
    public void setSwitchOn(@Argument(description="The switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws UtilityException {
        try {
            if (sw < 0 || sw >= 7) {
                throw new UtilityException("Invalid switch number: " + sw);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws UtilityException {
        Integer sw = SwitchNames.NAME_MAP.get(name);
        try {
            if (sw == null) {
                throw new UtilityException("Invalid switch name: " + name);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    private void setSwitch(int sw, boolean on) throws UtilityException {
        SwitchState state = this.protState.getSwitchState(sw);
        if (state == SwitchState.OFFLINE) {
            return;
        }
        Device swDevice = this.switchDevices[sw];
        if (swDevice == this.plutoDevc) {
            this.plutoDevc.setSwitchOn(switchChannels[sw], on);
        }
    }

    private Boolean isSwitchOn(int sw) {
        Boolean value = false;
        Device swDevice = this.switchDevices[sw];
        if (swDevice == this.plutoDevc) {
            value = this.plutoDevc.isSwitchOn(switchChannels[sw]);
        }
        return value;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a condition")
    public void clearLatch(@Argument(description="The condition number") int cond) throws UtilityException {
        try {
            this.plutoDevc.clearLatch(cond);
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    private void updateProtState() {
        Boolean active;
        int cond;
        Enum state;
        Enum oldState;
        if (!this.running) {
            return;
        }
        boolean changed = false;
        for (int plc = 0; plc < 3; ++plc) {
            PLCState newState;
            oldState = this.protState.getPlcState(plc);
            Boolean active2 = this.plutoDevc.isPlcActive(plc);
            PLCState pLCState = active2 == null ? PLCState.OFFLINE : (newState = active2 != false ? PLCState.ALIVE : PLCState.DEAD);
            if (newState == oldState) continue;
            changed = true;
            this.protState.setPlcState(plc, newState);
            String desc = plcNames[plc] + " protection PLC ";
            if (newState == PLCState.ALIVE) {
                this.lowerAlert(MpmAlert.PROT_PLC_NOT_ALIVE, desc + "is alive");
                continue;
            }
            this.raiseAlert(MpmAlert.PROT_PLC_NOT_ALIVE, desc + (newState == PLCState.DEAD ? "has died" : "is offline"));
        }
        for (int sw = 0; sw < 7; ++sw) {
            oldState = this.protState.getSwitchState(sw);
            Boolean isOn = this.isSwitchOn(sw);
            Enum enum_ = isOn != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : (state = SwitchState.OFFLINE);
            if (state == oldState) continue;
            this.protState.setSwitchState(sw, (SwitchState)state);
            changed = true;
        }
        for (cond = 0; cond < 11; ++cond) {
            LatchState oldState2;
            active = this.plutoDevc.isLatchActive(cond);
            Boolean latched = this.plutoDevc.isLatchLatched(cond);
            state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR));
            if (state == (oldState2 = this.protState.getLatch(cond))) continue;
            this.protState.setLatch(cond, (LatchState)state);
            MpmAlert alert = alertMap.get(cond);
            if (state == LatchState.ACTIVE) {
                this.raiseAlert(alert, "Protection PLC error condition set");
            } else if (state != LatchState.OFFLINE && oldState2 == LatchState.ACTIVE) {
                this.lowerAlert(alert, "Protection PLC error condition cleared");
            }
            changed = true;
        }
        for (cond = 0; cond < 7; ++cond) {
            ConditionState state2;
            active = this.plutoDevc.isConditionActive(cond);
            ConditionState conditionState = active == null ? ConditionState.OFF : (state2 = active != false ? ConditionState.YES : ConditionState.NO);
            if (state2 == this.protState.getCondition(cond)) continue;
            this.protState.setCondition(cond, state2);
            changed = true;
        }
        if (changed) {
            this.publishState();
        }
    }

    private void raiseAlert(MpmAlert alert, String cond) {
        this.as.raiseAlert(alert.getAlert(), AlertState.ALARM, cond);
        this.activeAlertMap.put(alert.getId(), true);
    }

    private boolean isAlertRaised(MpmAlert alert) {
        return this.activeAlertMap.get(alert.getId()).equals(Boolean.TRUE);
    }

    private void lowerAlert(MpmAlert alert, String cond) {
        this.as.raiseAlert(alert.getAlert(), AlertState.NOMINAL, cond);
        this.activeAlertMap.put(alert.getId(), false);
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        Integer cond;
        Boolean active = this.activeAlertMap.get(alert.getAlertId());
        if (active != null && !active.booleanValue() && (cond = revAlertMap.get(alert.getAlertId())) != null) {
            try {
                this.clearLatch(cond);
            }
            catch (UtilityException e) {
                LOG.severe((Object)("Error clearing latched PLC condition: " + e));
            }
        }
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    private void publishState() {
        this.protState.setTickMillis(this.getTickPeriod());
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("MPMState", (Serializable)this.protState));
    }

    private void setTickPeriod(long period) {
        this.apts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.apts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    static {
        MpmMain.switchChannels[4] = 3;
        MpmMain.switchChannels[3] = 4;
        MpmMain.switchChannels[6] = 5;
        MpmMain.switchChannels[5] = 6;
        MpmMain.switchChannels[2] = 2;
        MpmMain.switchChannels[1] = 0;
        MpmMain.switchChannels[0] = 1;
        alertMap = new HashMap<Integer, MpmAlert>();
        alertMap.put(5, MpmAlert.COLD_TEMP_HIGH);
        alertMap.put(6, MpmAlert.COLD_TEMP_LOW);
        alertMap.put(7, MpmAlert.CRYO_TEMP_HIGH);
        alertMap.put(8, MpmAlert.CRYO_TEMP_LOW);
        alertMap.put(9, MpmAlert.CRYO_VACUUM_BAD);
        alertMap.put(10, MpmAlert.HEX_VACUUM_BAD);
        alertMap.put(1, MpmAlert.UT_COOLANT_LEAK);
        alertMap.put(2, MpmAlert.UT_COOLANT_LEAK);
        alertMap.put(3, MpmAlert.UT_SMOKE_DETC);
        alertMap.put(4, MpmAlert.UT_SMOKE_DETC);
        alertMap.put(0, MpmAlert.UT_TEMP_HIGH);
        revAlertMap = new HashMap<String, Integer>();
        for (int cond : alertMap.keySet()) {
            revAlertMap.put(alertMap.get(cond).getId(), cond);
        }
        plcNames = new String[3];
        MpmMain.plcNames[0] = "Trunk";
        MpmMain.plcNames[1] = "Cold";
        MpmMain.plcNames[2] = "Cryo";
        LOG = Logger.getLogger((String)MpmMain.class.getName());
    }
}

