import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.PlutoDevice;
import org.lsst.ccs.subsystem.refrig.MCCDevice;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["ccs-refrig-compressor"]

builder.main (Compressor, tickMillis: 10000, monMillis: 1000, checkMillis: 5000,
              cmprPowerLine: "CmprLine", heaterPowerLine: "HtrLine",
              resetLine: "ResetLine") {

    Maq        (Maq20Device, node: "192.168.128.100",
                serial: ["0098704-16", "0100762-06"])

    Pluto      (PlutoDevice, node: "192.168.0.100", areas: [1, 1, 1, 2, 1, 3])

    Cmpr       (MCCDevice, devName: "TC_AI", serial: "00087534")

    ResetLine  (Line, devcName: "Pluto", chan: 0)

    CmprLine   (Line, devcName: "Cmpr", chan: 7)

    //CmprLine   (Line, devcName: "Pluto", chan: 16)

    HtrLine    (Line, devcName: "Pluto", chan: 32)

    CompOn     (Channel, description: "Control\\Compressor ON switch", format: ".0f",
                devcName: "Pluto", hwChan: 6, type: "GLOBAL:1")

    CompPerm   (Channel, description: "CCS compressor permit", format: ".0f",
                devcName: "Pluto", hwChan: 20, type: "GLOBAL:1")

    CompEnab   (Channel, description: "Compressor enable", format: ".0f",
                devcName: "Pluto", hwChan: 31, type: "GLOBAL:1")

    CompPwr    (Channel, description: "Compressor power", format: ".0f",
                devcName: "Pluto", hwChan: 16, type: "GLOBAL:1")

    HeaterOn   (Channel, description: "Heater ON switch", format: ".0f",
                devcName: "Pluto", hwChan: 0, type: "GLOBAL:1")

    HeaterPerm (Channel, description: "CCS heater permit", format: ".0f",
                devcName: "Pluto", hwChan: 21, type: "GLOBAL:1")

    HeaterPwr  (Channel, description: "Heater power", format: ".0f",
                devcName: "Pluto", hwChan: 17, type: "GLOBAL:1")

    Permit     (Channel, description: "External permit", format: ".0f",
                devcName: "Pluto", hwChan: 5, type: "GLOBAL:1")

    PermLatch  (Channel, description: "External permit latch", format: ".0f",
                devcName: "Pluto", hwChan: 30, type: "GLOBAL:1")

    LevelSw    (Channel, description: "Oil level switch", format: ".0f",
                devcName: "Pluto", hwChan: 4, type: "GLOBAL:1")

    LevelLatch (Channel, description: "Oil level OK latch", format: ".0f",
                devcName: "Pluto", hwChan: 22, type: "GLOBAL:1")

    FlowSw     (Channel, description: "Water flow switch", format: ".0f",
                devcName: "Pluto", hwChan: 0, type: "GLOBAL:1")

    FlowLatch  (Channel, description: "Water flow OK latch", format: ".0f",
                devcName: "Pluto", hwChan: 29, type: "GLOBAL:1")

    CompTemp   (Channel, description: "Compressor temperature", units: "\u00b0C",
                devcName: "Pluto", hwChan: 0, type: "ADDREG:0", scale: 0.01)

    CompTmpOk  (Channel, description: "Compressor temp valid", format: ".0f",
                devcName: "Pluto", hwChan: 23, type: "GLOBAL:1")

    CompTmpHi  (Channel, description: "Compressor temp high latch", format: ".0f",
                devcName: "Pluto", hwChan: 24, type: "GLOBAL:1")

    DisPress   (Channel, description: "Discharge pressure", units: "Psig",
                devcName: "Pluto", hwChan: 1, type: "ADDREG:0", scale: 0.1)

    DisPrsOk   (Channel, description: "Discharge pressure valid", format: ".0f",
                devcName: "Pluto", hwChan: 25, type: "GLOBAL:1")

    DisPrsHi   (Channel, description: "Discharge pressure high latch", format: ".0f",
                devcName: "Pluto", hwChan: 26, type: "GLOBAL:1")

    CmprTemp    (Channel, description: "Monitoring\\Compressor temperature", units: "\u00b0C",
                devcName: "Maq", hwChan: 3, type: "TTC:1", subtype: "T220")

    DisTemp    (Channel, description: "Discharge temperature", units: "\u00b0C",
                devcName: "Maq", hwChan: 2, type: "TTC:1", subtype: "T220")

    OilTemp    (Channel, description: "Oil temperature", units: "\u00b0C",
                devcName: "Maq", hwChan: 1, type: "TTC:1", subtype: "T220")

    WaterTemp  (Channel, description: "Water temperature", units: "\u00b0C",
                devcName: "Maq", hwChan: 5, type: "TTC:1", subtype: "T220")

    SepTemp    (Channel, description: "Separator temperature", units: "\u00b0C",
                devcName: "Maq", hwChan: 0, type: "TTC:1", subtype: "T220")

    C1Temp    (Channel, description: "C1 temperature", units: "\u00b0C",
                devcName: "Maq", hwChan: 4, type: "TTC:1", subtype: "T220")

    SucPress   (Channel, description: "Suction pressure", units: "Psig",
                devcName: "Maq", hwChan: 5, type: "VOLT:0", subtype: "V5",
                scale: 40.0)

    CompVolt   (Channel, description: "Compressor voltage", units: "Volts",
                devcName: "Maq", hwChan: 0, type: "VOLT:0", subtype: "V5",
                scale: 50.0)

    CompCurr   (Channel, description: "Compressor current", units: "Amps",
                devcName: "Maq", hwChan: 1, type: "VOLT:0", subtype: "V5",
                scale: 5.0)

    SupplyVolt (Channel, description: "24 volt supply", units: "Volts",
                devcName: "Pluto", hwChan: 1, type: "ADDREG:1", scale: 0.1)

}
