/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.teststand.Fe55Shutter;
import org.lsst.ccs.subsystem.teststand.KeithleyDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device;
import org.lsst.ccs.subsystem.teststand.data.TSDeviceStatus;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;
import org.lsst.ccs.utilities.logging.Logger;

public class BOTBench
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    Map<String, ThorlabsFWDevice> filterWheelMap = new HashMap<String, ThorlabsFWDevice>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    ThorlabsSC10Device shutterDev;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    List<Fe55Shutter> shuttersFe55 = new ArrayList<Fe55Shutter>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    KeithleyDevice photoDiodeDev;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    private final Logger log = Logger.getLogger((String)this.getClass().getPackage().getName());

    public void postInit() {
        this.subsys.setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, BOTBench.class.getCanonicalName());
    }

    @Command(type=Command.CommandType.QUERY, name="listFilterWheels", description="list filter wheels and connection status")
    public List<TSDeviceStatus> listFilterWheels() {
        ArrayList<TSDeviceStatus> listfw = new ArrayList<TSDeviceStatus>();
        Set<String> fwNames = this.filterWheelMap.keySet();
        for (String fwName : fwNames) {
            boolean fwOnline = this.filterWheelMap.get(fwName).isOnline();
            listfw.add(new TSDeviceStatus(fwName, fwOnline));
        }
        return listfw;
    }

    @Command(type=Command.CommandType.ACTION, name="fe55OpenShutters", description="open all Fe55 shutters")
    public void fe55OpenShutters() throws DriverException {
        if (this.shuttersFe55.isEmpty()) {
            this.log.error((Object)"No Fe55 shutters are configured");
            return;
        }
        Iterator<Fe55Shutter> iter = this.shuttersFe55.iterator();
        while (iter.hasNext()) {
            iter.next().setShutter(true);
        }
    }

    @Command(type=Command.CommandType.ACTION, name="fe55CloseShutters", description="close all Fe55 shutters")
    public void fe55CloseShutters() throws DriverException {
        if (this.shuttersFe55.isEmpty()) {
            this.log.error((Object)"No Fe55 shutters are configured");
            return;
        }
        Iterator<Fe55Shutter> iter = this.shuttersFe55.iterator();
        while (iter.hasNext()) {
            iter.next().setShutter(false);
        }
    }

    @Command(type=Command.CommandType.ACTION, name="readPDCurrent", description="read photodiode current")
    public double readPDcurrent() throws DriverException {
        return this.photoDiodeDev.readCurrent();
    }

    @Command(type=Command.CommandType.ACTION, name="accumPDBuffer", description="accumulate PD readings in buffer")
    public double accumPDBuffer(int nreads, double nplc) throws DriverException {
        return this.photoDiodeDev.accumBuffer(nreads, nplc);
    }

    @Command(type=Command.CommandType.ACTION, name="isPDAccumInProgress", description="tell if PD reading accumulation is in progress")
    public boolean isPDAccumInProgress() throws DriverException {
        return this.photoDiodeDev.isAccumInProgress();
    }

    @Command(type=Command.CommandType.ACTION, name="readPDbuffer", description="return array of PD readings from the buffer")
    public double[][] readPDBuffer(String filename) throws DriverException {
        return this.photoDiodeDev.readBuffer(filename);
    }

    @Command(type=Command.CommandType.ACTION, name="resetPD", description="reset PD device")
    public void resetPD() throws DriverException {
        this.photoDiodeDev.reset();
    }

    @Command(type=Command.CommandType.ACTION, name="clearPDbuff", description="clearPDbuff")
    public void clearPDbuff() throws DriverException {
        this.photoDiodeDev.clearBuffer();
    }
}

