/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Timed {
    private static final Logger LOG = Logger.getLogger(Timed.class.getName());
    private static final Level DEFAULT_LEVEL = Level.FINE;

    static <T> T execute(Callable<T> callable, String message, Object ... args) {
        return Timed.execute(DEFAULT_LEVEL, callable, message, args);
    }

    static <T> T execute(Level level, Callable<T> callable, String message, Object ... args) {
        return Timed.execute(level, callable, (long time) -> String.format(message, Timed.append(args, time)));
    }

    static <T> T execute(Callable<T> callable, MessageSupplier message) {
        return Timed.execute(DEFAULT_LEVEL, callable, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T execute(Level level, Callable<T> callable, MessageSupplier message) {
        long start = System.currentTimeMillis();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception x) {
            Object r = Timed.sneakyThrow(x);
            return (T)r;
        }
        finally {
            long stop = System.currentTimeMillis();
            LOG.log(level, () -> message.get(stop - start));
        }
    }

    static <T extends Exception, R> R sneakyThrow(Exception t) throws T {
        throw t;
    }

    private static Object[] append(Object[] args, Object ... arg) {
        Object[] result = new Object[args.length + arg.length];
        System.arraycopy(args, 0, result, 0, args.length);
        System.arraycopy(arg, 0, result, args.length, arg.length);
        return result;
    }

    static interface MessageSupplier {
        public String get(long var1);
    }
}

