/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.File;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;

public class ScriptingCommands {
    private final FocalPlaneSubsystem subsys;

    ScriptingCommands(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }

    @Command(type=Command.CommandType.QUERY, description="Wait for FITS files to be saved", level=0, autoAck=false)
    public FileList waitForFitsFiles(@Argument(defaultValue="PT30S") Duration timeout) {
        return (FileList)this.subsys.helper().enterFaultOnException(true).duration(timeout).action(() -> this.subsys.getImageHandling().waitForFITSFiles(timeout));
    }

    @Command(type=Command.CommandType.QUERY, description="Wait for image data to arrive", level=0, autoAck=false)
    public void waitForImages(@Argument(defaultValue="PT30S") Duration timeout) {
        this.subsys.helper().enterFaultOnException(true).duration(timeout).action(() -> this.subsys.getImageHandling().waitForImages(timeout));
    }

    @Command(type=Command.CommandType.QUERY, description="Wait for sequencer to stop", level=0, autoAck=false)
    public void waitForSequencer(@Argument(defaultValue="PT30S") Duration timeout) {
        this.subsys.helper().enterFaultOnException(true).duration(timeout).action(() -> this.subsys.waitFor(t -> t.isInState((Enum)FocalPlaneState.QUIESCENT) || t.isInState((Enum)FocalPlaneState.NEEDS_CLEAR), timeout.toMillis(), TimeUnit.MILLISECONDS));
    }

    public static class FileList
    extends ConcurrentSkipListSet<File> {
        private static final long serialVersionUID = 3543276216049016663L;

        void addAll(List<String> files) {
            files.forEach(file -> this.add(new File((String)file)));
        }

        public File getCommonParentDirectory() {
            Iterator iterator = this.iterator();
            if (!iterator.hasNext()) {
                return new File("/");
            }
            File result = ((File)iterator.next()).getParentFile();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                while (!file.getAbsolutePath().startsWith(result.getAbsolutePath())) {
                    result = result.getParentFile();
                }
            }
            return result;
        }
    }
}

