/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.common.devices.PlutoDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class VacPlutoDevice
extends PlutoDevice {
    public static final int SW_BLOCK_HVSTAT = 0;
    public static final int SW_BLOCK_CVSTAT = 1;
    public static final int SW_OPEN_VHX00 = 2;
    public static final int SW_OPEN_VCR00 = 3;
    public static final int SW_OPEN_VCR01 = 4;
    public static final int SW_OPEN_VCR02 = 5;
    public static final int SW_OPEN_VCR03 = 6;
    public static final int SW_OPEN_VCR04 = 7;
    public static final int SW_BLOCK_HVPUMP = 8;
    public static final int SW_BLOCK_CVPUMP = 9;
    public static final int NUM_SWITCHES = 10;
    private static final int NUM_AREAS = 19;
    private static final int SWDI_ON_BIT = 0;
    private static final int SWDI_OFF_BIT = 1;
    private static final int SWDI_READ_AREA = 2;
    private static final int SWDI_READ_BIT = 3;
    private static final int CNDI_RESET_BIT = 0;
    private static final int CNDI_READ_AREA = 1;
    private static final int CNDI_READ_BIT = 2;
    private static final int CNDI_PEND_AREA = 3;
    private static final int CNDI_PEND_BIT = 4;
    private static final int[][] switches = new int[10][];
    private static final int[][] conditions;
    private List<Integer> condsUsed;
    private static final Logger LOG;

    public VacPlutoDevice() {
        super(19);
    }

    protected void initDevice() {
        super.initDevice();
        if (this.condsUsed == null) {
            this.condsUsed = new ArrayList<Integer>();
        }
        for (int cond : this.condsUsed) {
            if (cond >= 0 && cond < 8) continue;
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"condsUsed item", (String)"is invalid");
        }
    }

    public void setSwitchOn(int sw, boolean on) {
        int bitNum = switches[sw][on ? 0 : 1];
        this.toggleBit(bitNum / 16, bitNum & 0xF);
    }

    public Boolean isSwitchOn(int sw) {
        int[] swData = switches[sw];
        Integer value = this.readAddBit(swData[2], swData[3] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public List<Integer> getConditionIds() {
        return this.condsUsed;
    }

    public Boolean isConditionActive(int cond) {
        int[] condData = conditions[cond];
        Integer value = this.readAddBit(condData[1], condData[2] + 16);
        return value != null ? Boolean.valueOf(value == 0) : null;
    }

    public Boolean isConditionLatched(int cond) {
        int[] condData = conditions[cond];
        Integer value = this.readAddBit(condData[3], condData[4] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public void clearCondition(int cond) {
        int bitNum = conditions[cond][0];
        this.toggleBit(bitNum / 16, bitNum & 0xF);
    }

    static {
        VacPlutoDevice.switches[3] = new int[]{7, 6, 15, 0};
        VacPlutoDevice.switches[4] = new int[]{12, 13, 12, 0};
        VacPlutoDevice.switches[5] = new int[]{14, 15, 12, 3};
        VacPlutoDevice.switches[6] = new int[]{16, 17, 13, 0};
        VacPlutoDevice.switches[7] = new int[]{18, 19, 13, 3};
        VacPlutoDevice.switches[2] = new int[]{3, 2, 15, 2};
        VacPlutoDevice.switches[0] = new int[]{0, 20, 14, 0};
        VacPlutoDevice.switches[1] = new int[]{1, 21, 14, 3};
        VacPlutoDevice.switches[8] = new int[]{10, 22, 11, 0};
        VacPlutoDevice.switches[9] = new int[]{11, 23, 11, 3};
        conditions = new int[8][];
        VacPlutoDevice.conditions[0] = new int[]{1, 14, 3, 18, 0};
        VacPlutoDevice.conditions[2] = new int[]{9, 15, 4, 18, 2};
        VacPlutoDevice.conditions[1] = new int[]{8, 10, 3, 18, 1};
        VacPlutoDevice.conditions[3] = new int[]{11, 11, 3, 18, 3};
        VacPlutoDevice.conditions[4] = new int[]{0, 14, 0, 18, 4};
        VacPlutoDevice.conditions[6] = new int[]{5, 15, 5, 18, 6};
        VacPlutoDevice.conditions[5] = new int[]{4, 9, 3, 18, 5};
        VacPlutoDevice.conditions[7] = new int[]{10, 11, 0, 18, 7};
        LOG = Logger.getLogger((String)VacPlutoDevice.class.getName());
    }
}

