/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.refrig.HeaterPsDevice;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.constants.ColdState;
import org.lsst.ccs.subsystem.refrig.constants.HeaterControlState;
import org.lsst.ccs.subsystem.refrig.constants.HeaterPowerState;
import org.lsst.ccs.subsystem.refrig.constants.ThermalAlert;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.utilities.logging.Logger;

public class ThermalMain
implements HasLifecycle,
AgentPresenceListener,
StatusMessageListener,
ClearAlertHandler {
    private static final String THERMAL_LIMITS = "ThermalLimits";
    private static final int POWER_SET_INTVL = 5000;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService aps;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService as;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, TempControl> tempControlMap = new HashMap<String, TempControl>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, PowerDevice> powerDeviceMap = new HashMap<String, PowerDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @ConfigurationParameter(category="ThermalLimits", isFinal=true)
    private double coldTempLimit = 40.0;
    private String coldTempCtrl;
    private String cryoTempCtrl;
    private String[] auxPowerNames;
    private String[] coldTempNames;
    private static final Logger LOG = Logger.getLogger((String)ThermalMain.class.getName());
    private final TrimHeater[] trimHeaters = new TrimHeater[2];
    private final AuxHeater[] auxHeaters = new AuxHeater[3];
    private final List<Channel> coldTemps = new ArrayList<Channel>();
    private final ThermalState thermalState = new ThermalState();
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private int highTempCount = 0;
    private ColdState refrigColdState = ColdState.UNKNOWN;

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("heater-power", () -> this.setHeaterPower()).withPeriod(Duration.ofMillis(5000L));
        this.pts.scheduleAgentPeriodicTask(pt);
        pt = new AgentPeriodicTask("thermal-state", () -> this.updateThermalState()).withPeriod(Duration.ofMillis(1000L));
        this.pts.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        int htr;
        this.aps.setAgentProperty("thermalType", ThermalMain.class.getCanonicalName());
        this.subsys.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.thermalState.setTickMillis(this.getTickPeriod());
        for (htr = 0; htr < 2; ++htr) {
            TempControl ctrl = this.tempControlMap.get(htr == 0 ? this.coldTempCtrl : this.cryoTempCtrl);
            if (ctrl == null) {
                String type = htr == 0 ? "cold" : "cryo";
                LOG.error((Object)("No " + type + "-plate temperature controller (or heater control) specified"));
                continue;
            }
            this.trimHeaters[htr] = new TrimHeater(ctrl, ctrl.getPowerDevice(), ctrl.getPowerChannel());
        }
        if (this.auxPowerNames == null) {
            LOG.info((Object)"No auxiliary heater devices specified");
        } else if (this.auxPowerNames.length > 3) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"auxHeaterPower", (String)"contains more than 3 items");
        } else {
            for (htr = 0; htr < 3; ++htr) {
                String name;
                String string = name = htr < this.auxPowerNames.length ? this.auxPowerNames[htr] : null;
                if (name == null) {
                    LOG.info((Object)("Auxiliary heater " + htr + " has not been specified"));
                    continue;
                }
                PowerDevice power = this.powerDeviceMap.get(name);
                if (power == null) {
                    MonitorLogUtils.reportConfigError((Logger)LOG, (String)name, (String)"auxHeaterPower", (String)"contains non-power item");
                }
                this.auxHeaters[htr] = new AuxHeater(power, 0);
            }
        }
        if (this.coldTempNames == null) {
            LOG.severe((Object)"No cold-plate temperature monitoring channels specified");
        } else {
            for (String coldName : this.coldTempNames) {
                Channel chan = this.allChannels.get(coldName);
                if (chan == null) {
                    MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"coldTempNames", (String)"contains non-channel item");
                }
                this.coldTemps.add(chan);
            }
        }
    }

    public void postStart() {
        Object heater;
        int htr;
        for (htr = 0; htr < 2; ++htr) {
            heater = this.trimHeaters[htr];
            if (heater == null) continue;
            this.thermalState.setTrimHeaterState(htr, !((TrimHeater)heater).powerDevc.isOnline() ? HeaterPowerState.OFFLINE : (((TrimHeater)heater).powerDevc.getOutput(((TrimHeater)heater).powerChan) ? HeaterPowerState.ON : HeaterPowerState.OFF));
            this.thermalState.setTrimHeaterCtrlState(htr, HeaterControlState.OFF);
        }
        for (htr = 0; htr < 3; ++htr) {
            heater = this.auxHeaters[htr];
            if (heater == null) continue;
            this.thermalState.setAuxHeaterState(htr, !((AuxHeater)heater).powerDevc.isOnline() ? HeaterPowerState.OFFLINE : (((AuxHeater)heater).powerDevc.getOutput(((AuxHeater)heater).powerChan) ? HeaterPowerState.ON : HeaterPowerState.OFF));
        }
        LOG.info((Object)"Thermal control system started");
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType")) continue;
            String agentName = agent.getName();
            this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName));
            break;
        }
    }

    public void disconnecting(AgentInfo agent) {
        if (agent.hasAgentProperty("compressorType")) {
            this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        this.refrigColdState = (ColdState)msg.getState().getState(ColdState.class);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the thermal control state")
    public ThermalState getSystemState() {
        return this.thermalState;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        this.setTickPeriod(value);
        this.thermalState.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Enables/disables a cold trim heater section")
    public void enableColdSection(int section, boolean enable) {
        TrimHeater heater = this.trimHeaters[0];
        if (heater != null) {
            TrimHeater trimHeater = heater;
            synchronized (trimHeater) {
                this.thermalState.enableColdSection(section, enable);
                ((HeaterPsDevice)heater.powerDevc).enableColdSection(section, enable);
                this.setHeaterPower();
            }
        }
        this.publishState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater power enabled state")
    public void setTrimHeaterPowerEnable(int htr, int value) throws RefrigException {
        try {
            TrimHeater trimHeater = this.getTrimHeater(htr);
            synchronized (trimHeater) {
                HeaterPowerState oldState = this.thermalState.getTrimHeaterState(htr);
                if (oldState != HeaterPowerState.OFFLINE && oldState != HeaterPowerState.DISABLD) {
                    HeaterPowerState newState;
                    HeaterPowerState heaterPowerState = newState = value != 0 ? HeaterPowerState.ON : HeaterPowerState.OFF;
                    if (newState != oldState) {
                        this.thermalState.setTrimHeaterState(htr, newState);
                        this.setTrimHeaterPowerSwitch(htr);
                    }
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater control state")
    public void setTrimHeaterControl(int htr, int value) throws RefrigException {
        try {
            TrimHeater heater;
            TrimHeater trimHeater = heater = this.getTrimHeater(htr);
            synchronized (trimHeater) {
                HeaterControlState oldState = this.thermalState.getTrimHeaterCtrlState(htr);
                if (oldState != HeaterControlState.OFFLINE) {
                    HeaterControlState newState;
                    HeaterControlState heaterControlState = value == 0 ? HeaterControlState.OFF : (newState = value > 0 ? HeaterControlState.POWER : HeaterControlState.TEMP);
                    if (newState != oldState) {
                        this.thermalState.setTrimHeaterCtrlState(htr, newState);
                        if (newState == HeaterControlState.TEMP) {
                            heater.tempCtrl.setTemp(this.thermalState.getPlateTemperature(htr));
                            this.startTempControl(htr);
                        } else {
                            this.stopTempControl(htr);
                            this.setTrimHeaterPower(htr);
                        }
                    }
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater power set point")
    public void setTrimHeaterPower(int htr, double value) throws RefrigException {
        try {
            TrimHeater heater;
            TrimHeater trimHeater = heater = this.getTrimHeater(htr);
            synchronized (trimHeater) {
                this.thermalState.setTrimHeaterPower(htr, value);
                if (heater.startPower != null) {
                    heater.startPower = value;
                }
                this.setTrimHeaterPower(htr);
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a plate temperature set point")
    public void setPlateTemperature(int htr, double value) throws RefrigException {
        try {
            TrimHeater heater;
            TrimHeater trimHeater = heater = this.getTrimHeater(htr);
            synchronized (trimHeater) {
                this.thermalState.setPlateTemperature(htr, value);
                heater.tempCtrl.setTemp(value);
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set an aux heater power enabled state")
    public void setAuxHeaterPowerEnable(int htr, int value) throws RefrigException {
        try {
            AuxHeater auxHeater = this.getAuxHeater(htr);
            synchronized (auxHeater) {
                HeaterPowerState oldState = this.thermalState.getAuxHeaterState(htr);
                if (oldState != HeaterPowerState.OFFLINE && oldState != HeaterPowerState.DISABLD) {
                    HeaterPowerState newState;
                    HeaterPowerState heaterPowerState = newState = value != 0 ? HeaterPowerState.ON : HeaterPowerState.OFF;
                    if (newState != oldState) {
                        this.thermalState.setAuxHeaterState(htr, newState);
                        this.setAuxHeaterPower(htr);
                    }
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set an aux heater power set point")
    public void setAuxHeaterPower(int htr, double value) throws RefrigException {
        try {
            AuxHeater auxHeater = this.getAuxHeater(htr);
            synchronized (auxHeater) {
                this.thermalState.setAuxHeaterPower(htr, value);
                this.setAuxHeaterPower(htr);
            }
        }
        finally {
            this.publishState();
        }
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ThermalState", (Serializable)this.thermalState));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThermalState() {
        boolean coldHigh = false;
        for (Channel chan : this.coldTemps) {
            coldHigh |= chan.getValue() > this.coldTempLimit;
        }
        if (coldHigh) {
            coldHigh &= ++this.highTempCount >= 3;
        } else {
            this.highTempCount = 0;
        }
        boolean changed = false;
        for (int htr = 0; htr < 2; ++htr) {
            TrimHeater heater = this.trimHeaters[htr];
            if (heater == null) continue;
            TrimHeater trimHeater = heater;
            synchronized (trimHeater) {
                HeaterPowerState state;
                HeaterPowerState heaterPowerState = coldHigh && htr == 0 ? HeaterPowerState.DISABLD : (!heater.powerDevc.isOnline() ? HeaterPowerState.OFFLINE : (state = heater.powerDevc.isEnabled(heater.powerChan) ? HeaterPowerState.ON : HeaterPowerState.OFF));
                if (state != this.thermalState.getTrimHeaterState(htr)) {
                    this.thermalState.setTrimHeaterState(htr, state);
                    this.setTrimHeaterPowerSwitch(htr);
                    changed = true;
                }
                continue;
            }
        }
        boolean coldCompsOff = this.refrigColdState == ColdState.BOTH_OFF || this.refrigColdState == ColdState.UNKNOWN;
        for (int htr = 0; htr < 3; ++htr) {
            AuxHeater heater = this.auxHeaters[htr];
            if (heater == null) continue;
            AuxHeater auxHeater = heater;
            synchronized (auxHeater) {
                HeaterPowerState state;
                HeaterPowerState heaterPowerState = coldHigh || coldCompsOff ? HeaterPowerState.DISABLD : (!heater.powerDevc.isOnline() ? HeaterPowerState.OFFLINE : (state = heater.powerDevc.isEnabled(heater.powerChan) ? HeaterPowerState.ON : HeaterPowerState.OFF));
                if (state != this.thermalState.getAuxHeaterState(htr)) {
                    this.thermalState.setAuxHeaterState(htr, state);
                    this.setAuxHeaterPower(htr);
                    changed = true;
                }
                continue;
            }
        }
        if (changed) {
            this.publishState();
            if (coldHigh) {
                this.raiseAlert(ThermalAlert.COLD_TEMP_HIGH, AlertState.ALARM, "At least one cold-plate RTD is above " + this.coldTempLimit + " C");
            } else {
                this.lowerAlert(ThermalAlert.COLD_TEMP_HIGH, "No cold-plate RTD is above " + this.coldTempLimit + " C");
            }
            if (coldCompsOff) {
                this.raiseAlert(ThermalAlert.COLD_COMP_OFF, AlertState.ALARM, "Both cold compressors are turned off");
            } else {
                this.lowerAlert(ThermalAlert.COLD_COMP_OFF, "At least one cold compressor is back on");
            }
        }
    }

    private void setTrimHeaterPowerSwitch(int htr) {
        TrimHeater heater = this.trimHeaters[htr];
        if (this.thermalState.getTrimHeaterState(htr) == HeaterPowerState.ON) {
            heater.powerDevc.enableOutput(heater.powerChan, true);
            if (this.thermalState.getTrimHeaterCtrlState(htr) == HeaterControlState.TEMP) {
                this.startTempControl(htr);
            }
        } else {
            this.stopTempControl(htr);
            heater.powerDevc.enableOutput(heater.powerChan, false);
        }
    }

    private void setHeaterPower() {
        int htr;
        for (htr = 0; htr < 2; ++htr) {
            this.setTrimHeaterPower(htr);
        }
        for (htr = 0; htr < 3; ++htr) {
            this.setAuxHeaterPower(htr);
        }
    }

    private void setTrimHeaterPower(int htr) {
        TrimHeater heater = this.trimHeaters[htr];
        if (heater == null || !heater.powerDevc.isOnline()) {
            return;
        }
        if (this.thermalState.getTrimHeaterState(htr) != HeaterPowerState.ON) {
            return;
        }
        heater.powerDevc.enableOutput(heater.powerChan, this.thermalState.getTrimHeaterCtrlState(htr) != HeaterControlState.OFF);
        if (this.thermalState.getTrimHeaterCtrlState(htr) == HeaterControlState.POWER) {
            double loadPower = this.thermalState.getTrimHeaterPower(htr);
            heater.powerDevc.setPower(heater.powerChan, loadPower);
            heater.startPower = loadPower;
        }
    }

    private void setAuxHeaterPower(int htr) {
        AuxHeater heater = this.auxHeaters[htr];
        if (heater == null || !heater.powerDevc.isOnline()) {
            return;
        }
        heater.powerDevc.enableOutput(heater.powerChan, this.thermalState.getAuxHeaterState(htr) == HeaterPowerState.ON);
        heater.powerDevc.setPower(heater.powerChan, this.thermalState.getAuxHeaterPower(htr));
    }

    private void startTempControl(int htr) {
        TrimHeater heater = this.trimHeaters[htr];
        if (heater != null) {
            if (heater.startPower == null) {
                heater.tempCtrl.restart();
            } else {
                heater.tempCtrl.start(heater.startPower);
                heater.startPower = null;
            }
        }
    }

    private void stopTempControl(int htr) {
        TrimHeater heater = this.trimHeaters[htr];
        if (heater != null) {
            heater.tempCtrl.stop();
        }
    }

    private void raiseAlert(ThermalAlert alert, AlertState state, String cond) {
        Boolean active = this.activeAlertMap.put(alert.getId(), true);
        if (active == null || !active.booleanValue()) {
            this.as.raiseAlert(alert.newAlert(), state, cond);
        }
    }

    private void lowerAlert(ThermalAlert alert, String cond) {
        Boolean active = this.activeAlertMap.put(alert.getId(), false);
        if (active != null && active.booleanValue()) {
            this.as.raiseAlert(alert.newAlert(), AlertState.NOMINAL, cond);
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        Boolean active = this.activeAlertMap.get(alert.getAlertId());
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    private TrimHeater getTrimHeater(int htr) throws RefrigException {
        if (htr < 0 || htr >= 2) {
            throw new RefrigException("Invalid trim heater number: " + htr);
        }
        TrimHeater heater = this.trimHeaters[htr];
        if (heater == null) {
            throw new RefrigException("Trim heater " + htr + " not defined");
        }
        return heater;
    }

    private AuxHeater getAuxHeater(int htr) throws RefrigException {
        if (htr < 0 || htr >= 3) {
            throw new RefrigException("Invalid auxiliary heater number: " + htr);
        }
        AuxHeater heater = this.auxHeaters[htr];
        if (heater == null) {
            throw new RefrigException("Auxiliary heater " + htr + " not defined");
        }
        return heater;
    }

    static class AuxHeater {
        PowerDevice powerDevc;
        int powerChan;

        AuxHeater(PowerDevice powerDevc, int powerChan) {
            this.powerDevc = powerDevc;
            this.powerChan = powerChan;
        }
    }

    static class TrimHeater {
        TempControl tempCtrl;
        PowerDevice powerDevc;
        int powerChan;
        Double startPower = 0.0;

        TrimHeater(TempControl tempCtrl, PowerDevice powerDevc, int powerChan) {
            this.tempCtrl = tempCtrl;
            this.powerDevc = powerDevc;
            this.powerChan = powerChan;
        }
    }
}

