import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.ThermalMain;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.DL34970Device;
import org.lsst.ccs.subsystem.refrig.HeaterPsDevice;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Page;

taskConfig = ["monitor-update/taskPeriodMillis":1000, "monitor-publish/taskPeriodMillis":10000]

CCSBuilder builder = ["thermal"]

builder.main (ThermalMain, nodeTags: taskConfig, cryoTempCtrl: "CryoTempCtrl") {

    CryoTempCtrl (TempControl, gain: 25.0, timeConst: 1000.0, smoothTime: 120.0,
                  maxOutput: 250.0, awGain: 4.0, basePower: 0.0, tolerance: 0.05,
                  updateTime: 30000, powerDevc: "Power", powerChan: HeaterPsDevice.CHANSET_CRYO,
                  tempChans: ["CryoTemp1"] as String[])

    Rtds       (Maq20Device, node: "192.168.1.128",
                modules: ["RTD:0121348-10", "RTD:0122975-01", "RTD:0119418-07",  // Cryo RTDs
                          "RTD:0121348-02", "RTD:0114836-04", "RTD:0121348-04",  //    "
                          "RTD:0121348-06", "RTD:0121348-07", "RTD:0121348-09",  // Refrig RTDs
                          "RTD:0121348-08", "RTD:0119418-08", "RTD:0122975-02",  //    "
                          "RTD:0121348-01",                                      //    "
                          "IS:0104377-14", "IS:0104377-15"] as String[])         // Refrig pressure

    Power      (HeaterPsDevice, node: 83)

    Page0      (Page, id: 0, label: "Cryostat")

/*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1,
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/  

    /*
    "CRY-CLP-RTD-50" (Channel, description: "Cold Plate RTD 50", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "0", subtype: "R200", pageId: 0)

    "CRY-CLP-RTD-53" (Channel, description: "Cold Plate RTD 53", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "0", subtype: "R200", pageId: 0)

    "CRY-CLP-RTD-05" (Channel, description: "Cold Plate RTD 05", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "3", subtype: "R200", pageId: 0)

    "CRY-CLP-RTD-02" (Channel, description: "Cold Plate RTD 02", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "3", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-34" (Channel, description: "Cryo Plate RTD 34", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "0", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-33" (Channel, description: "Cryo Plate RTD 33", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "0", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-53" (Channel, description: "Cryo Plate RTD 53", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "0", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-42" (Channel, description: "Cryo Plate RTD 42", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "0", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-52" (Channel, description: "Cryo Plate RTD 52", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "1", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-31" (Channel, description: "Cryo Plate RTD 31", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "1", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-51" (Channel, description: "Cryo Plate RTD 51", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "1", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-30" (Channel, description: "Cryo Plate RTD 30", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "1", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-25" (Channel, description: "Cryo Plate RTD 25", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "3", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-24" (Channel, description: "Cryo Plate RTD 24", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "3", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-04" (Channel, description: "Cryo Plate RTD 04", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "3", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-13" (Channel, description: "Cryo Plate RTD 13", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "3", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-03" (Channel, description: "Cryo Plate RTD 03", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "4", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-22" (Channel, description: "Cryo Plate RTD 22", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "4", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-02" (Channel, description: "Cryo Plate RTD 02", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "4", subtype: "R200", pageId: 0)

    "CRY-CYP-RTD-21" (Channel, description: "Cryo Plate RTD 21", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "4", subtype: "R200", pageId: 0)

    "CRY-GRD-RTD-01" (Channel, description: "Grid RTD 01", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "1", subtype: "R200", pageId: 0)

    "CRY-GRD-RTD-02" (Channel, description: "Grid RTD 02", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "1", subtype: "R200", pageId: 0)

    "CRY-GRD-RTD-03" (Channel, description: "Grid RTD 03", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "4", subtype: "R200", pageId: 0)

    "CRY-GRD-RTD-04" (Channel, description: "Grid RTD 04", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "4", subtype: "R200", pageId: 0)

    "CRY-GFX-RTD-01" (Channel, description: "Grid Flexure RTD 01", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "2", subtype: "R200", pageId: 0)

    "CRY-GFX-RTD-02" (Channel, description: "Grid Flexure RTD 02", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "2", subtype: "R200", pageId: 0)

    "CRY-GFX-RTD-03" (Channel, description: "Grid Flexure RTD 03", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "5", subtype: "R200", pageId: 0)

    "CRY-GFX-RTD-04" (Channel, description: "Grid Flexure RTD 04", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "5", subtype: "R200", pageId: 0)

    "CRY-CFX-RTD-01" (Channel, description: "Cryo Flexure RTD 01", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "2", subtype: "R200", pageId: 0)

    "CRY-CFX-RTD-02" (Channel, description: "Cryo Flexure RTD 02", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "2", subtype: "R200", pageId: 0)

    "CRY-CFX-RTD-03" (Channel, description: "Cryo Flexure RTD 03", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "5", subtype: "R200", pageId: 0)

    "CRY-CFX-RTD-04" (Channel, description: "Cryo Flexure RTD 04", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "5", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-01" (Channel, description: "Heat Exchanger RTD 01", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "6", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-02" (Channel, description: "Heat Exchanger RTD 02", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "6", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-03" (Channel, description: "Heat Exchanger RTD 03", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "6", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-04" (Channel, description: "Heat Exchanger RTD 04", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "6", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-05" (Channel, description: "Heat Exchanger RTD 05", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "6", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-06" (Channel, description: "Heat Exchanger RTD 06", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "6", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-07" (Channel, description: "Heat Exchanger RTD 07", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "7", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-08" (Channel, description: "Heat Exchanger RTD 08", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "7", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-09" (Channel, description: "Heat Exchanger RTD 09", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "7", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-10" (Channel, description: "Heat Exchanger RTD 10", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "7", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-11" (Channel, description: "Heat Exchanger RTD 11", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "7", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-12" (Channel, description: "Heat Exchanger RTD 12", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "7", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-13" (Channel, description: "Heat Exchanger RTD 13", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "8", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-14" (Channel, description: "Heat Exchanger RTD 14", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "8", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-15" (Channel, description: "Heat Exchanger RTD 15", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "8", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-16" (Channel, description: "Heat Exchanger RTD 16", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "8", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-17" (Channel, description: "Heat Exchanger RTD 17", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "8", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-18" (Channel, description: "Heat Exchanger RTD 18", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "8", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-19" (Channel, description: "Heat Exchanger RTD 19", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "9", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-20" (Channel, description: "Heat Exchanger RTD 20", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "9", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-21" (Channel, description: "Heat Exchanger RTD 21", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "9", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-22" (Channel, description: "Heat Exchanger RTD 22", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "9", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-23" (Channel, description: "Heat Exchanger RTD 23", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "9", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-24" (Channel, description: "Heat Exchanger RTD 24", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "9", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-25" (Channel, description: "Heat Exchanger RTD 25", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "10", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-26" (Channel, description: "Heat Exchanger RTD 26", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "10", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-27" (Channel, description: "Heat Exchanger RTD 27", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "10", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-28" (Channel, description: "Heat Exchanger RTD 28", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "10", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-29" (Channel, description: "Heat Exchanger RTD 29", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "10", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-30" (Channel, description: "Heat Exchanger RTD 30", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "10", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-31" (Channel, description: "Heat Exchanger RTD 31", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "11", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-32" (Channel, description: "Heat Exchanger RTD 32", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "11", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-33" (Channel, description: "Heat Exchanger RTD 33", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "11", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-34" (Channel, description: "Heat Exchanger RTD 34", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "11", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-35" (Channel, description: "Heat Exchanger RTD 35", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "11", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-36" (Channel, description: "Heat Exchanger RTD 36", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "11", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-37" (Channel, description: "Heat Exchanger RTD 37", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 0, type: "12", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-38" (Channel, description: "Heat Exchanger RTD 38", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 1, type: "12", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-39" (Channel, description: "Heat Exchanger RTD 39", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 2, type: "12", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-40" (Channel, description: "Heat Exchanger RTD 40", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 3, type: "12", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-41" (Channel, description: "Heat Exchanger RTD 41", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 4, type: "12", subtype: "R200", pageId: 0)

    "RFG-HEX-RTD-42" (Channel, description: "Heat Exchanger RTD 42", units: "\u00b0C",
                      devcName: "Rtds", hwChan: 5, type: "12", subtype: "R200", pageId: 0)
    */

    /*
    "RFG-TPH-PRS-01" (Channel, description: "Cryo Circ 0 Gas Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 0, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-02" (Channel, description: "Cryo Circ 0 Liq Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 1, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-03" (Channel, description: "Cryo Circ 0 Suc Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 2, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-04" (Channel, description: "Cryo Circ 1 Gas Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 3, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-05" (Channel, description: "Cryo Circ 1 Liq Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 4, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-06" (Channel, description: "Cryo Circ 1 Suc Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 5, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-07" (Channel, description: "Cryo Circ 2 Gas Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 6, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-08" (Channel, description: "Cryo Circ 2 Liq Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 7, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-09" (Channel, description: "Cryo Circ 2 Suc Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 8, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-10" (Channel, description: "Cryo Circ 3 Gas Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 9, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-11" (Channel, description: "Cryo Circ 3 Liq Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 10, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-12" (Channel, description: "Cryo Circ 3 Suc Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 11, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-13" (Channel, description: "Cryo Circ 4 Gas Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 12, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-14" (Channel, description: "Cryo Circ 4 Liq Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 13, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-15" (Channel, description: "Cryo Circ 4 Suc Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 14, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-16" (Channel, description: "Cryo Circ 5 Gas Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 15, type: "13", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-17" (Channel, description: "Cryo Circ 5 Liq Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 0, type: "14", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-18" (Channel, description: "Cryo Circ 5 Suc Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 1, type: "14", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-19" (Channel, description: "Cold Circ 0 sup Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 2, type: "14", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-20" (Channel, description: "Cold Circ 0 suc Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 3, type: "14", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-21" (Channel, description: "Cold Circ 1 sup Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 4, type: "14", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)

    "RFG-TPH-PRS-22" (Channel, description: "Cold Circ 1 suc Pressure", units: "Psig",
                      devcName: "Rtds", hwChan: 5, type: "14", subtype: "MA0_20", offset: 0, scale: 1, pageId: 0)
    */

    "CryoTemp1" (Channel, description: "Cryo Temperature 1", units: "\u00b0C",
                 devcName: "Rtds", hwChan: 0, type: "0", subtype: "R200", pageId: 0)

    "HtrPsTemp" (Channel, description: "Heater PS Temperature", units: "\u00b0C",
                 devcName: "Power", hwChan: 0, type: "TEMP", subtype: "", pageId: 0)

    "HtrBulkTemp" (Channel, description: "Heater Bulk PS Temperature", units: "\u00b0C",
                   devcName: "Power", hwChan: 0, type: "MAINTEMP", subtype: "", pageId: 0)

    "HtrBulk_V" (Channel, description: "Heater Bulk PS Voltage", units: "Volts",
                 devcName: "Power", hwChan: 0, type: "MAINVOLTS", subtype: "", pageId: 0)

    "HtrBulk_I" (Channel, description: "Heater Bulk PS Current", units: "Amps",
                 devcName: "Power", hwChan: 0, type: "MAINCURR", subtype: "", pageId: 0)

    "HtrBulk_P" (Channel, description: "Heater Bulk PS Power", units: "Watts",
                 devcName: "Power", hwChan: 0, type: "MAINPOWER", subtype: "", pageId: 0)

    "CryoHtr1_V" (Channel, description: "Cryo Heater 1 Voltage", units: "Volts",
                  devcName: "Power", hwChan: 6, type: "VOLTAGE", subtype: "", pageId: 0)

    "CryoHtr1_I" (Channel, description: "Cryo Heater 1 Current", units: "Amps",
                  devcName: "Power", hwChan: 6, type: "CURRENT", subtype: "", pageId: 0)

    "CryoHtr1_P" (Channel, description: "Cryo Heater 1 Power", units: "Watts",
                  devcName: "Power", hwChan: 6, type: "POWER", subtype: "", pageId: 0)

}
