import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.BOTBench;
import org.lsst.ccs.subsystem.teststand.Fe55Shutter;
import org.lsst.ccs.subsystem.teststand.KeithleyDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["bot-bench"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");

Class keithleyClass = Class.forName("org.lsst.ccs.subsystem.teststand.KeithleyDevice");
Class thorlabsFWClass = Class.forName("org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice");
Class thorlabsSC10Class = Class.forName("org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device");
Class Fe55ShutterClass = Class.forName("org.lsst.ccs.subsystem.teststand.Fe55Shutter");

builder.
    main (BOTBench) {


    PhotoDiode  (keithleyClass, devName:"/dev/ttyS0", baudRate:9600, connType:"serial")
    {
        voltage  (Channel,
            description:"photodiode supply voltage", units:"V",
            devcName:"Monitor", hwChan:KeithleyDevice.CHAN_VOLTAGE, offset:0.0, scale:1.0,
            /*checkLo:"alarm",*/ limitLo:-74.0, dbandLo:0.0/*, alarmLo:"AlarmHDWPD"*/,
            /*checkHi:"alarm",*/   limitHi:2.0, dbandHi:0.0/*, alarmHi:"AlarmHDWPD"*/)

        current  (Channel,
            description:"photodiode supply current", units:"I",
            devcName:"Monitor", hwChan:KeithleyDevice.CHAN_CURRENT, offset:0.0, scale:1.0,
            /*checkLo:"alarm",*/ limitLo:-1.0e6, dbandLo:0.0/*, alarmLo:"AlarmHDWPD"*/,
            /*checkHi:"alarm",*/  limitHi:1.0e6, dbandHi:0.0/*, alarmHi:"AlarmHDWPD"*/)
    }


    SpotProjFWheel (thorlabsFWClass, devcId:"",
        fwsize:6, speedMode:true, sensorMode:false,
        filterNames:["Mask_grid","Mask_spot","empty3","empty4","empty5","empty6"])
    {
        SpotProjFWheelPos (Channel, 
                           description:"Spot projector filter wheel position",
                           devcName:"SpotProjFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    NeutralFWheel (thorlabsFWClass, devcId:"",
        fwsize:12, speedMode:true, sensorMode:false,
        filterNames:["empty", "ND_OD0.1", "ND_OD0.2", "ND_OD0.3", "ND_OD0.4", 
                     "ND_OD0.5", "ND_OD0.6", "ND_OD1.0", "ND_OD1.3", 
                     "ND_OD2.0", "ND_OD3.0", "ND_OD4.0" ])
    {
        NeutralFWheelPos (Channel, 
                           description:"Neutral density filter wheel position",
                           devcName:"NeutralFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    ColorFWheel (thorlabsFWClass, devcId:"",
        fwsize:12, speedMode:true, sensorMode:false,
        filterNames:["480nm", "650nm", "750nm", "870nm", "950nm", "SDSS_u", 
                     "SDSS_g", "SDSS_r", "SDSS_i", "SDSS_z", "SDSS_Y", "empty"])
    {
        ColorFWheelPos (Channel, 
                           description:"Color filter wheel position",
                           devcName:"ColorFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    ProjectorShutter (thorlabsSC10Class, devcId:"",
       //devcId:"/dev/serial/by-id/usb-FTDI_USB__-__Serial_Cable_FT1RAJQE-if01-port0", 
       outputMode:false)
    {
    }

    Fe55ShutterA (Fe55ShutterClass, gpioLine:"GPIO508")
    {}

    Fe55ShutterB (Fe55ShutterClass, gpioLine:"GPIO509")
    {}

}
