/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.GP390;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class GP390Device
extends Device {
    private static final int BAUD_RATE = 19200;
    private String serial;
    private int address;
    private static final Logger LOG = Logger.getLogger((String)GP390Device.class.getName());
    private GP390 gp;

    public GP390Device(String serialNo, int addr) {
        this.serial = serialNo;
        this.address = addr;
    }

    public GP390Device() {
    }

    protected void initDevice() {
        super.configure(this.mon);
        if (this.serial == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"serial", (String)"is missing");
        }
        this.fullName = "GP390 vacuum gauge (" + this.serial + ":" + this.address + ")";
    }

    protected void initialize() {
        try {
            if (!this.inited || this.gp == null) {
                this.gp = new GP390();
            }
            this.gp.open(GP390.ConnType.FTDI, this.serial, 19200, this.address);
            this.gp.setLock(false);
            this.gp.setPressureUnit(0);
            this.gp.setLock(true);
            this.setOnline(true);
            this.initSensors();
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            if (this.gp != null) {
                this.close();
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
        try {
            this.gp.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            try {
                value = this.gp.readPressure();
            }
            catch (DriverException e) {
                LOG.error((Object)("Error reading pressure: " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
        return value;
    }
}

