/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.abb.Cms;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CmsDevice
extends Device {
    public static final int TYPE_RMS = 0;
    public static final int TYPE_AC = 1;
    public static final int TYPE_DC = 2;
    private static final Map<String, Modbus.ConnType> cTypeMap = new HashMap<String, Modbus.ConnType>();
    private static final Map<String, Integer> sTypeMap;
    private String connType;
    private String devcId;
    private int baudRate = 0;
    private int address = 1;
    private final Logger sLog = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private final Cms cms = new Cms();
    private Modbus.ConnType cType;

    protected void initDevice() {
        if (this.connType == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"connType", (String)"is missing");
        }
        this.cType = cTypeMap.get(this.connType.toUpperCase());
        if (this.cType == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"connType", (String)"is invalid");
        }
        if (this.devcId == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "CMS100 (" + this.devcId + ":" + this.address + ")";
    }

    protected void initialize() {
        try {
            this.cms.open(this.cType, this.devcId, this.baudRate);
            this.setOnline(true);
            this.initSensors();
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.cms.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer sType;
        if (hwChan <= 0 || hwChan > 64) {
            MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"hwchan", (Object)hwChan);
        }
        if ((sType = sTypeMap.get(type == null || type.isEmpty() ? "RMS" : type.toUpperCase())) == null) {
            MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"type", (Object)type);
        }
        return new int[]{sType, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        try {
            switch (type) {
                case 0: {
                    value = this.cms.readRMS(this.address, hwChan);
                    break;
                }
                case 1: {
                    value = this.cms.readAC(this.address, hwChan);
                    break;
                }
                case 2: {
                    value = this.cms.readDC(this.address, hwChan);
                }
            }
        }
        catch (DriverException e) {
            this.sLog.error((Object)("Error reading CMS100 data: " + (Object)((Object)e)));
            this.setOnline(false);
        }
        return value;
    }

    static {
        cTypeMap.put("SERIAL", Modbus.ConnType.SERIAL);
        cTypeMap.put("FTDI", Modbus.ConnType.FTDI);
        sTypeMap = new HashMap<String, Integer>();
        sTypeMap.put("RMS", 0);
        sTypeMap.put("AC", 1);
        sTypeMap.put("DC", 2);
    }
}

